/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class MapKeyTests
extends JavaResourceModelTestCase {
    public MapKeyTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMapKey() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKey"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKey");
            }
        });
    }

    private ICompilationUnit createTestMapKeyWithName() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapKey"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKey(name=\"key\")");
            }
        });
    }

    public void testMapKey() throws Exception {
        ICompilationUnit cu = this.createTestMapKey();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.MapKey");
        MapKeyTests.assertNotNull((Object)mapKey);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.MapKey");
        MapKeyTests.assertEquals((String)"key", (String)mapKey.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestMapKey();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.MapKey");
        mapKey.setName("foo");
        this.assertSourceContains("@MapKey(name=\"foo\")", cu);
        mapKey.setName(null);
        this.assertSourceContains("@MapKey", cu);
        this.assertSourceDoesNotContain("@MapKey(name=\"foo\")", cu);
    }
}

