/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OneToManyTests
extends JavaResourceModelTestCase {
    public OneToManyTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestOneToMany() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToMany"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany");
            }
        });
    }

    private ICompilationUnit createTestOneToManyWithFetch() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToMany", "javax.persistence.FetchType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany(fetch=FetchType.EAGER)");
            }
        });
    }

    private ICompilationUnit createTestOneToManyWithTargetEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToMany"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany(targetEntity=AnnotationTestType.class)");
            }
        });
    }

    private ICompilationUnit createTestOneToManyWithMappedBy() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToMany"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany(mappedBy=\"foo\")");
            }
        });
    }

    private ICompilationUnit createTestOneToManyWithCascade() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToMany", "javax.persistence.CascadeType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany(cascade=CascadeType.ALL)");
            }
        });
    }

    private ICompilationUnit createTestOneToManyWithMultipleCascade() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToMany", "javax.persistence.CascadeType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany(cascade={CascadeType.MERGE, CascadeType.REMOVE})");
            }
        });
    }

    private ICompilationUnit createTestOneToManyWithDuplicateCascade() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToMany", "javax.persistence.CascadeType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany(cascade={CascadeType.MERGE, CascadeType.MERGE})");
            }
        });
    }

    public void testOneToMany() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertNotNull((Object)oneToMany);
    }

    public void testGetFetch() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertEquals((Object)FetchType.EAGER, (Object)oneToMany.getFetch());
    }

    public void testSetFetch() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertEquals((Object)FetchType.EAGER, (Object)oneToMany.getFetch());
        oneToMany.setFetch(FetchType.LAZY);
        OneToManyTests.assertEquals((Object)FetchType.LAZY, (Object)oneToMany.getFetch());
        this.assertSourceContains("@OneToMany(fetch=LAZY)", cu);
    }

    public void testSetFetchNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertEquals((Object)FetchType.EAGER, (Object)oneToMany.getFetch());
        oneToMany.setFetch(null);
        OneToManyTests.assertNull((Object)oneToMany.getFetch());
        this.assertSourceContains("@OneToMany", cu);
        this.assertSourceDoesNotContain("fetch", cu);
    }

    public void testGetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertEquals((String)"AnnotationTestType", (String)oneToMany.getTargetEntity());
    }

    public void testSetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertEquals((String)"AnnotationTestType", (String)oneToMany.getTargetEntity());
        oneToMany.setTargetEntity("Foo");
        this.assertSourceContains("@OneToMany(targetEntity=Foo.class)", cu);
    }

    public void testSetTargetEntityNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertEquals((String)"AnnotationTestType", (String)oneToMany.getTargetEntity());
        oneToMany.setTargetEntity(null);
        this.assertSourceContains("@OneToMany", cu);
        this.assertSourceDoesNotContain("targetEntity", cu);
    }

    public void testGetFullyQualifiedTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertEquals((String)"test.AnnotationTestType", (String)oneToMany.getFullyQualifiedTargetEntity());
        oneToMany.setTargetEntity("Foo");
        this.assertSourceContains("@OneToMany(targetEntity=Foo.class)", cu);
        OneToManyTests.assertEquals((String)"Foo", (String)oneToMany.getTargetEntity());
        OneToManyTests.assertEquals((String)"Foo", (String)oneToMany.getFullyQualifiedTargetEntity());
    }

    public void testGetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithMappedBy();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertEquals((String)"foo", (String)oneToMany.getMappedBy());
    }

    public void testGetMappedByNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertEquals(null, (String)oneToMany.getMappedBy());
    }

    public void testSetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertNull((Object)oneToMany.getMappedBy());
        oneToMany.setMappedBy("bar");
        OneToManyTests.assertEquals((String)"bar", (String)oneToMany.getMappedBy());
        this.assertSourceContains("@OneToMany(mappedBy=\"bar\")", cu);
    }

    public void testSetMappedByNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithMappedBy();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertEquals((String)"foo", (String)oneToMany.getMappedBy());
        oneToMany.setMappedBy(null);
        OneToManyTests.assertNull((Object)oneToMany.getMappedBy());
        this.assertSourceContains("@OneToMany", cu);
        this.assertSourceDoesNotContain("mappedBy", cu);
    }

    public void testSetCascadeAll() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertFalse((boolean)oneToMany.isCascadeAll());
        oneToMany.setCascadeAll(true);
        this.assertSourceContains("@OneToMany(cascade=ALL)", cu);
        OneToManyTests.assertTrue((boolean)oneToMany.isCascadeAll());
    }

    public void testSetCascadeMerge() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertFalse((boolean)oneToMany.isCascadeMerge());
        oneToMany.setCascadeMerge(true);
        this.assertSourceContains("@OneToMany(cascade=MERGE)", cu);
        OneToManyTests.assertTrue((boolean)oneToMany.isCascadeMerge());
    }

    public void testSetCascadePersist() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertFalse((boolean)oneToMany.isCascadePersist());
        oneToMany.setCascadePersist(true);
        this.assertSourceContains("@OneToMany(cascade=PERSIST)", cu);
        OneToManyTests.assertTrue((boolean)oneToMany.isCascadePersist());
    }

    public void testSetCascadeRemove() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertFalse((boolean)oneToMany.isCascadeRemove());
        oneToMany.setCascadeRemove(true);
        this.assertSourceContains("@OneToMany(cascade=REMOVE)", cu);
        OneToManyTests.assertTrue((boolean)oneToMany.isCascadeRemove());
    }

    public void testSetCascadeRefresh() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertFalse((boolean)oneToMany.isCascadeRefresh());
        oneToMany.setCascadeRefresh(true);
        this.assertSourceContains("@OneToMany(cascade=REFRESH)", cu);
        OneToManyTests.assertTrue((boolean)oneToMany.isCascadeRefresh());
    }

    public void testCascadeMoreThanOnce() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithCascade();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertTrue((boolean)oneToMany.isCascadeAll());
        oneToMany.setCascadeAll(true);
        OneToManyTests.assertTrue((boolean)oneToMany.isCascadeAll());
        this.assertSourceContains("@OneToMany(cascade=CascadeType.ALL)", cu);
        oneToMany.setCascadeAll(false);
        OneToManyTests.assertFalse((boolean)oneToMany.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
        oneToMany.setCascadeAll(false);
        OneToManyTests.assertFalse((boolean)oneToMany.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testDuplicateCascade() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithDuplicateCascade();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertTrue((boolean)oneToMany.isCascadeMerge());
        oneToMany.setCascadeMerge(false);
        OneToManyTests.assertTrue((boolean)oneToMany.isCascadeMerge());
        oneToMany.setCascadeMerge(false);
        OneToManyTests.assertFalse((boolean)oneToMany.isCascadeMerge());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testMultipleCascade() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithMultipleCascade();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToMany");
        OneToManyTests.assertTrue((boolean)oneToMany.isCascadeMerge());
        OneToManyTests.assertTrue((boolean)oneToMany.isCascadeRemove());
        oneToMany.setCascadeMerge(false);
        this.assertSourceContains("@OneToMany(cascade=REMOVE)", cu);
        oneToMany.setCascadeRemove(false);
        this.assertSourceDoesNotContain("cascade", cu);
    }
}

