/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OneToOneTests
extends JavaResourceModelTestCase {
    public OneToOneTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestOneToOne() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithFetch() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne", "javax.persistence.FetchType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(fetch=FetchType.EAGER)");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithTargetEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(targetEntity=AnnotationTestType.class)");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithOptional() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(optional=true)");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithMappedBy() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(mappedBy=\"foo\")");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithCascade() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne", "javax.persistence.CascadeType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(cascade=CascadeType.ALL)");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithMultipleCascade() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne", "javax.persistence.CascadeType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(cascade={CascadeType.MERGE, CascadeType.REMOVE})");
            }
        });
    }

    private ICompilationUnit createTestOneToOneWithDuplicateCascade() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.OneToOne", "javax.persistence.CascadeType"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne(cascade={CascadeType.MERGE, CascadeType.MERGE})");
            }
        });
    }

    public void testOneToOne() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertNotNull((Object)oneToOne);
    }

    public void testGetFetch() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertEquals((Object)FetchType.EAGER, (Object)oneToOne.getFetch());
    }

    public void testSetFetch() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertEquals((Object)FetchType.EAGER, (Object)oneToOne.getFetch());
        oneToOne.setFetch(FetchType.LAZY);
        OneToOneTests.assertEquals((Object)FetchType.LAZY, (Object)oneToOne.getFetch());
        this.assertSourceContains("@OneToOne(fetch=LAZY)", cu);
    }

    public void testSetFetchNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertEquals((Object)FetchType.EAGER, (Object)oneToOne.getFetch());
        oneToOne.setFetch(null);
        OneToOneTests.assertNull((Object)oneToOne.getFetch());
        this.assertSourceContains("@OneToOne", cu);
        this.assertSourceDoesNotContain("fetch", cu);
    }

    public void testGetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertEquals((String)"AnnotationTestType", (String)oneToOne.getTargetEntity());
    }

    public void testSetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertEquals((String)"AnnotationTestType", (String)oneToOne.getTargetEntity());
        oneToOne.setTargetEntity("Foo");
        this.assertSourceContains("@OneToOne(targetEntity=Foo.class)", cu);
    }

    public void testSetTargetEntityNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertEquals((String)"AnnotationTestType", (String)oneToOne.getTargetEntity());
        oneToOne.setTargetEntity(null);
        this.assertSourceContains("@OneToOne", cu);
        this.assertSourceDoesNotContain("targetEntity", cu);
    }

    public void testGetFullyQualifiedTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertEquals((String)"test.AnnotationTestType", (String)oneToOne.getFullyQualifiedTargetEntity());
        oneToOne.setTargetEntity("Foo");
        this.assertSourceContains("@OneToOne(targetEntity=Foo.class)", cu);
        OneToOneTests.assertEquals((String)"Foo", (String)oneToOne.getTargetEntity());
        OneToOneTests.assertEquals((String)"Foo", (String)oneToOne.getFullyQualifiedTargetEntity());
    }

    public void testGetOptional() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithOptional();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOptional());
    }

    public void testSetOptional() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithOptional();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOptional());
        oneToOne.setOptional(Boolean.FALSE);
        OneToOneTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOne.getOptional());
        this.assertSourceContains("@OneToOne(optional=false)", cu);
    }

    public void testSetOptionalNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithOptional();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOptional());
        oneToOne.setOptional(null);
        OneToOneTests.assertNull((Object)oneToOne.getOptional());
        this.assertSourceContains("@OneToOne", cu);
        this.assertSourceDoesNotContain("optional", cu);
    }

    public void testGetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithMappedBy();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertEquals((String)"foo", (String)oneToOne.getMappedBy());
    }

    public void testGetMappedByNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertEquals(null, (String)oneToOne.getMappedBy());
    }

    public void testSetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertNull((Object)oneToOne.getMappedBy());
        oneToOne.setMappedBy("bar");
        OneToOneTests.assertEquals((String)"bar", (String)oneToOne.getMappedBy());
        this.assertSourceContains("@OneToOne(mappedBy=\"bar\")", cu);
    }

    public void testSetMappedByNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithMappedBy();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertEquals((String)"foo", (String)oneToOne.getMappedBy());
        oneToOne.setMappedBy(null);
        OneToOneTests.assertNull((Object)oneToOne.getMappedBy());
        this.assertSourceContains("@OneToOne", cu);
        this.assertSourceDoesNotContain("mappedBy", cu);
    }

    public void testSetCascadeAll() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertFalse((boolean)oneToOne.isCascadeAll());
        oneToOne.setCascadeAll(true);
        this.assertSourceContains("@OneToOne(cascade=ALL)", cu);
        OneToOneTests.assertTrue((boolean)oneToOne.isCascadeAll());
    }

    public void testSetCascadeMerge() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertFalse((boolean)oneToOne.isCascadeMerge());
        oneToOne.setCascadeMerge(true);
        this.assertSourceContains("@OneToOne(cascade=MERGE)", cu);
        OneToOneTests.assertTrue((boolean)oneToOne.isCascadeMerge());
    }

    public void testSetCascadePersist() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertFalse((boolean)oneToOne.isCascadePersist());
        oneToOne.setCascadePersist(true);
        this.assertSourceContains("@OneToOne(cascade=PERSIST)", cu);
        OneToOneTests.assertTrue((boolean)oneToOne.isCascadePersist());
    }

    public void testSetCascadeRemove() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertFalse((boolean)oneToOne.isCascadeRemove());
        oneToOne.setCascadeRemove(true);
        this.assertSourceContains("@OneToOne(cascade=REMOVE)", cu);
        OneToOneTests.assertTrue((boolean)oneToOne.isCascadeRemove());
    }

    public void testSetCascadeRefresh() throws Exception {
        ICompilationUnit cu = this.createTestOneToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertFalse((boolean)oneToOne.isCascadeRefresh());
        oneToOne.setCascadeRefresh(true);
        this.assertSourceContains("@OneToOne(cascade=REFRESH)", cu);
        OneToOneTests.assertTrue((boolean)oneToOne.isCascadeRefresh());
    }

    public void testCascadeMoreThanOnce() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithCascade();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertTrue((boolean)oneToOne.isCascadeAll());
        oneToOne.setCascadeAll(true);
        OneToOneTests.assertTrue((boolean)oneToOne.isCascadeAll());
        this.assertSourceContains("@OneToOne(cascade=CascadeType.ALL)", cu);
        oneToOne.setCascadeAll(false);
        OneToOneTests.assertFalse((boolean)oneToOne.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
        oneToOne.setCascadeAll(false);
        OneToOneTests.assertFalse((boolean)oneToOne.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testDuplicateCascade() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithDuplicateCascade();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertTrue((boolean)oneToOne.isCascadeMerge());
        oneToOne.setCascadeMerge(false);
        OneToOneTests.assertTrue((boolean)oneToOne.isCascadeMerge());
        oneToOne.setCascadeMerge(false);
        OneToOneTests.assertFalse((boolean)oneToOne.isCascadeMerge());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testMultipleCascade() throws Exception {
        ICompilationUnit cu = this.createTestOneToOneWithMultipleCascade();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getMappingAnnotation("javax.persistence.OneToOne");
        OneToOneTests.assertTrue((boolean)oneToOne.isCascadeMerge());
        OneToOneTests.assertTrue((boolean)oneToOne.isCascadeRemove());
        oneToOne.setCascadeMerge(false);
        this.assertSourceContains("@OneToOne(cascade=REMOVE)", cu);
        oneToOne.setCascadeRemove(false);
        this.assertSourceDoesNotContain("cascade", cu);
    }
}

