/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class QueryHintTests
extends JavaResourceModelTestCase {
    private static final String QUERY_HINT_NAME = "myHint";
    private static final String QUERY_HINT_VALUE = "myValue";

    public QueryHintTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestNamedQueryWithQueryHints() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedQuery", "javax.persistence.QueryHint"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedQuery(hints={@QueryHint(name=\"myHint\", value=\"myValue\"), @QueryHint})");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQuery");
        QueryHintAnnotation queryHint = (QueryHintAnnotation)namedQuery.hints().next();
        QueryHintTests.assertEquals((String)QUERY_HINT_NAME, (String)queryHint.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQuery");
        QueryHintAnnotation queryHint = (QueryHintAnnotation)namedQuery.hints().next();
        QueryHintTests.assertEquals((String)QUERY_HINT_NAME, (String)queryHint.getName());
        queryHint.setName("foo");
        QueryHintTests.assertEquals((String)"foo", (String)queryHint.getName());
        this.assertSourceContains("@QueryHint(name=\"foo\", value=\"myValue\")", cu);
    }
}

