/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.ResourceModelListener;
import org.eclipse.jpt.core.internal.AbstractJpaNode;
import org.eclipse.jpt.utility.internal.ListenerList;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaFile
extends AbstractJpaNode
implements JpaFile {
    private final IFile file;
    private final Hashtable<Object, JpaStructureNode> rootStructureNodes;
    private final ResourceModelListener resourceModelListener;
    private final ListenerList<ResourceModelListener> resourceModelListenerList;

    protected AbstractJpaFile(JpaProject jpaProject, IFile file) {
        super(jpaProject);
        this.file = file;
        this.rootStructureNodes = new Hashtable();
        this.resourceModelListener = this.buildResourceModelListener();
        this.resourceModelListenerList = new ListenerList(ResourceModelListener.class);
    }

    @Override
    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add("rootStructureNodes");
    }

    protected ResourceModelListener buildResourceModelListener() {
        return new ResourceModelListener(){

            public void resourceModelChanged() {
                AbstractJpaFile.this.resourceModelChanged();
            }
        };
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    protected ResourceModelListener getResourceModelListener() {
        return this.resourceModelListener;
    }

    @Override
    public void addResourceModelListener(ResourceModelListener listener) {
        this.resourceModelListenerList.add((EventListener)listener);
    }

    @Override
    public void removeResourceModelListener(ResourceModelListener listener) {
        this.resourceModelListenerList.remove((EventListener)listener);
    }

    protected void resourceModelChanged() {
        ResourceModelListener[] resourceModelListenerArray = (ResourceModelListener[])this.resourceModelListenerList.getListeners();
        int n = resourceModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceModelListener listener = resourceModelListenerArray[n2];
            listener.resourceModelChanged();
            ++n2;
        }
    }

    @Override
    public Iterator<JpaStructureNode> rootStructureNodes() {
        return new CloneIterator(this.rootStructureNodes.values());
    }

    @Override
    public int rootStructureNodesSize() {
        return this.rootStructureNodes.size();
    }

    @Override
    public void addRootStructureNode(Object key, JpaStructureNode rootStructureNode) {
        JpaStructureNode old = this.rootStructureNodes.put(key, rootStructureNode);
        if (rootStructureNode != old) {
            if (old != null) {
                this.fireItemRemoved("rootStructureNodes", old);
            }
            this.fireItemAdded("rootStructureNodes", rootStructureNode);
        }
    }

    @Override
    public void removeRootStructureNode(Object key) {
        this.fireItemRemoved("rootStructureNodes", this.rootStructureNodes.remove(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        Hashtable<Object, JpaStructureNode> hashtable = this.rootStructureNodes;
        synchronized (hashtable) {
            for (JpaStructureNode rootNode : this.rootStructureNodes.values()) {
                JpaStructureNode node = rootNode.getStructureNode(textOffset);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.file);
        sb.append('[');
        sb.append(this.getResourceType());
        sb.append(']');
    }
}

