/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaBaseEmbeddedMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.context.java.VirtualAttributeOverride;
import org.eclipse.jpt.core.internal.resource.java.NullColumn;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaBaseEmbeddedMapping<T extends JavaResourceNode>
extends AbstractJavaAttributeMapping<T>
implements JavaBaseEmbeddedMapping {
    protected final List<JavaAttributeOverride> specifiedAttributeOverrides = new ArrayList<JavaAttributeOverride>();
    protected final List<JavaAttributeOverride> virtualAttributeOverrides = new ArrayList<JavaAttributeOverride>();
    private Embeddable embeddable;

    protected AbstractJavaBaseEmbeddedMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public Iterator<String> correspondingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides"});
    }

    @Override
    public ColumnMapping getColumnMapping(String attributeName) {
        return MappingTools.getColumnMapping(attributeName, this.getEmbeddable());
    }

    @Override
    public boolean isVirtual(BaseOverride override) {
        return this.virtualAttributeOverrides.contains(override);
    }

    @Override
    public BaseOverride setVirtual(boolean virtual, BaseOverride override) {
        if (virtual) {
            return this.setAttributeOverrideVirtual((JavaAttributeOverride)override);
        }
        return this.setAttributeOverrideSpecified((JavaAttributeOverride)override);
    }

    protected JavaAttributeOverride setAttributeOverrideVirtual(JavaAttributeOverride attributeOverride) {
        int index = this.specifiedAttributeOverrides.indexOf(attributeOverride);
        this.specifiedAttributeOverrides.remove(index);
        String attributeOverrideName = attributeOverride.getName();
        JavaAttributeOverride virtualAttributeOverride = null;
        if (attributeOverrideName != null) {
            for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAttributes())) {
                if (!persistentAttribute.getName().equals(attributeOverrideName)) continue;
                virtualAttributeOverride = this.buildVirtualAttributeOverride(this.getResourcePersistentAttribute(), persistentAttribute.getName());
                this.virtualAttributeOverrides.add(virtualAttributeOverride);
                break;
            }
        }
        this.getResourcePersistentAttribute().removeSupportingAnnotation(index, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.fireItemRemoved("specifiedAttributeOverrides", index, attributeOverride);
        if (virtualAttributeOverride != null) {
            this.fireItemAdded("virtualAttributeOverrides", this.virtualAttributeOverridesSize() - 1, virtualAttributeOverride);
        }
        return virtualAttributeOverride;
    }

    protected JavaAttributeOverride setAttributeOverrideSpecified(JavaAttributeOverride oldAttributeOverride) {
        int index = this.specifiedAttributeOverridesSize();
        JavaAttributeOverride newAttributeOverride = this.getJpaFactory().buildJavaAttributeOverride(this, this);
        this.specifiedAttributeOverrides.add(index, newAttributeOverride);
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)this.getResourcePersistentAttribute().addSupportingAnnotation(index, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        newAttributeOverride.initialize(attributeOverrideResource);
        int defaultIndex = this.virtualAttributeOverrides.indexOf(oldAttributeOverride);
        this.virtualAttributeOverrides.remove(defaultIndex);
        newAttributeOverride.setName(oldAttributeOverride.getName());
        newAttributeOverride.getColumn().setSpecifiedName(oldAttributeOverride.getColumn().getName());
        this.fireItemRemoved("virtualAttributeOverrides", defaultIndex, oldAttributeOverride);
        this.fireItemAdded("specifiedAttributeOverrides", index, newAttributeOverride);
        return newAttributeOverride;
    }

    @Override
    public ListIterator<JavaAttributeOverride> attributeOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributeOverrides(), this.virtualAttributeOverrides()});
    }

    @Override
    public int attributeOverridesSize() {
        return this.specifiedAttributeOverridesSize() + this.virtualAttributeOverridesSize();
    }

    @Override
    public ListIterator<JavaAttributeOverride> virtualAttributeOverrides() {
        return new CloneListIterator(this.virtualAttributeOverrides);
    }

    @Override
    public int virtualAttributeOverridesSize() {
        return this.virtualAttributeOverrides.size();
    }

    @Override
    public ListIterator<JavaAttributeOverride> specifiedAttributeOverrides() {
        return new CloneListIterator(this.specifiedAttributeOverrides);
    }

    @Override
    public int specifiedAttributeOverridesSize() {
        return this.specifiedAttributeOverrides.size();
    }

    protected void addSpecifiedAttributeOverride(int index, JavaAttributeOverride attributeOverride) {
        this.addItemToList(index, attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverridesList");
    }

    protected void addSpecifiedAttributeOverride(JavaAttributeOverride attributeOverride) {
        this.addSpecifiedAttributeOverride(this.specifiedAttributeOverrides.size(), attributeOverride);
    }

    protected void removeSpecifiedAttributeOverride_(JavaAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverridesList");
    }

    @Override
    public void moveSpecifiedAttributeOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAttributeOverrides, (int)targetIndex, (int)sourceIndex);
        this.getResourcePersistentAttribute().moveSupportingAnnotation(targetIndex, sourceIndex, "javax.persistence.AttributeOverrides");
        this.fireItemMoved("specifiedAttributeOverridesList", targetIndex, sourceIndex);
    }

    protected void addVirtualAttributeOverride(JavaAttributeOverride attributeOverride) {
        this.addItemToList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverridesList");
    }

    protected void removeVirtualAttributeOverride(JavaAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverridesList");
    }

    @Override
    public JavaAttributeOverride getAttributeOverrideNamed(String name) {
        return (JavaAttributeOverride)this.getOverrideNamed(name, this.attributeOverrides());
    }

    public boolean containsAttributeOverride(String name) {
        return this.containsOverride(name, this.attributeOverrides());
    }

    public boolean containsDefaultAttributeOverride(String name) {
        return this.containsOverride(name, this.virtualAttributeOverrides());
    }

    public boolean containsSpecifiedAttributeOverride(String name) {
        return this.containsOverride(name, this.specifiedAttributeOverrides());
    }

    protected BaseOverride getOverrideNamed(String name, ListIterator<? extends BaseOverride> overrides) {
        for (BaseOverride override : CollectionTools.iterable(overrides)) {
            String overrideName = override.getName();
            if (overrideName == null && name == null) {
                return override;
            }
            if (overrideName == null || !overrideName.equals(name)) continue;
            return override;
        }
        return null;
    }

    protected boolean containsOverride(String name, ListIterator<? extends BaseOverride> overrides) {
        return this.getOverrideNamed(name, overrides) != null;
    }

    public Embeddable getEmbeddable() {
        return this.embeddable;
    }

    @Override
    public void initialize(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.initialize(resourcePersistentAttribute);
        this.initializeAttributeOverrides(resourcePersistentAttribute);
        this.initializeDefaultAttributeOverrides(resourcePersistentAttribute);
        this.embeddable = MappingTools.getEmbeddableFor((JavaPersistentAttribute)this.getPersistentAttribute());
    }

    protected void initializeAttributeOverrides(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        ListIterator<NestableAnnotation> annotations = resourcePersistentAttribute.supportingAnnotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        while (annotations.hasNext()) {
            JavaAttributeOverride attributeOverride = this.getJpaFactory().buildJavaAttributeOverride(this, this);
            attributeOverride.initialize((AttributeOverrideAnnotation)((Object)annotations.next()));
            this.specifiedAttributeOverrides.add(attributeOverride);
        }
    }

    protected void initializeDefaultAttributeOverrides(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        Iterator<String> i = this.allOverridableAttributeNames();
        while (i.hasNext()) {
            String attributeName = i.next();
            JavaAttributeOverride attributeOverride = this.getAttributeOverrideNamed(attributeName);
            if (attributeOverride != null) continue;
            this.virtualAttributeOverrides.add(this.buildVirtualAttributeOverride(resourcePersistentAttribute, attributeName));
        }
    }

    @Override
    public void update(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        super.update(resourcePersistentAttribute);
        this.embeddable = MappingTools.getEmbeddableFor((JavaPersistentAttribute)this.getPersistentAttribute());
        this.updateSpecifiedAttributeOverrides(resourcePersistentAttribute);
        this.updateVirtualAttributeOverrides(resourcePersistentAttribute);
    }

    protected void updateSpecifiedAttributeOverrides(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        ListIterator<JavaAttributeOverride> attributeOverrides = this.specifiedAttributeOverrides();
        ListIterator<NestableAnnotation> resourceAttributeOverrides = resourcePersistentAttribute.supportingAnnotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        while (attributeOverrides.hasNext()) {
            JavaAttributeOverride attributeOverride = attributeOverrides.next();
            if (resourceAttributeOverrides.hasNext()) {
                attributeOverride.update((AttributeOverrideAnnotation)((Object)resourceAttributeOverrides.next()));
                continue;
            }
            this.removeSpecifiedAttributeOverride_(attributeOverride);
        }
        while (resourceAttributeOverrides.hasNext()) {
            this.addSpecifiedAttributeOverride(this.buildAttributeOverride((AttributeOverrideAnnotation)((Object)resourceAttributeOverrides.next())));
        }
    }

    protected JavaAttributeOverride buildAttributeOverride(AttributeOverrideAnnotation attributeOverrideResource) {
        JavaAttributeOverride attributeOverride = this.getJpaFactory().buildJavaAttributeOverride(this, this);
        attributeOverride.initialize(attributeOverrideResource);
        return attributeOverride;
    }

    protected JavaAttributeOverride buildVirtualAttributeOverride(JavaResourcePersistentAttribute resourcePersistentAttribute, String attributeName) {
        return this.buildAttributeOverride(this.buildVirtualAttributeOverrideResource(resourcePersistentAttribute, attributeName));
    }

    protected VirtualAttributeOverride buildVirtualAttributeOverrideResource(JavaResourcePersistentAttribute resourcePersistentAttribute, String attributeName) {
        ColumnMapping columnMapping = (ColumnMapping)((Object)this.getEmbeddable().getPersistentType().getAttributeNamed(attributeName).getMapping());
        return new VirtualAttributeOverride(resourcePersistentAttribute, attributeName, columnMapping.getColumn());
    }

    protected void updateVirtualAttributeOverrides(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        Iterator<String> i = this.allOverridableAttributeNames();
        while (i.hasNext()) {
            String attributeName = i.next();
            JavaAttributeOverride attributeOverride = this.getAttributeOverrideNamed(attributeName);
            if (attributeOverride == null) {
                this.addVirtualAttributeOverride(this.buildVirtualAttributeOverride(resourcePersistentAttribute, attributeName));
                continue;
            }
            if (!attributeOverride.isVirtual()) continue;
            attributeOverride.getColumn().update(new NullColumn(resourcePersistentAttribute));
        }
        HashBag attributeNames = CollectionTools.collection(this.allOverridableAttributeNames());
        for (JavaAttributeOverride attributeOverride : CollectionTools.iterable(this.virtualAttributeOverrides())) {
            if (attributeNames.contains(attributeOverride.getName()) && !this.containsSpecifiedAttributeOverride(attributeOverride.getName())) continue;
            this.removeVirtualAttributeOverride(attributeOverride);
        }
    }

    public Iterator<String> allOverridableAttributeNames() {
        return new TransformationIterator<PersistentAttribute, String>(this.allOverridableAttributes()){

            protected String transform(PersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    public Iterator<PersistentAttribute> allOverridableAttributes() {
        if (this.getEmbeddable() == null) {
            return EmptyIterator.instance();
        }
        return new FilteringIterator<PersistentAttribute, PersistentAttribute>(this.getEmbeddable().getPersistentType().attributes()){

            protected boolean accept(PersistentAttribute o) {
                return o.isOverridableAttribute();
            }
        };
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (AttributeOverride override : CollectionTools.iterable(this.attributeOverrides())) {
            result = ((JavaAttributeOverride)override).javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, CompilationUnit astRoot) {
        super.validate(messages, astRoot);
        ListIterator<JavaAttributeOverride> stream = this.attributeOverrides();
        while (stream.hasNext()) {
            ((JavaAttributeOverride)stream.next()).validate(messages, astRoot);
        }
    }
}

