/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaRelationshipMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.context.java.JavaCascade;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.RelationshipMappingAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaRelationshipMapping<T extends RelationshipMappingAnnotation>
extends AbstractJavaAttributeMapping<T>
implements JavaRelationshipMapping {
    protected String specifiedTargetEntity;
    protected String defaultTargetEntity;
    protected Entity resolvedTargetEntity;
    protected final JavaCascade cascade = new JavaCascade(this);
    protected FetchType specifiedFetch;

    protected AbstractJavaRelationshipMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public JavaPersistentAttribute getParent() {
        return (JavaPersistentAttribute)super.getParent();
    }

    @Override
    public String getTargetEntity() {
        return this.specifiedTargetEntity != null ? this.specifiedTargetEntity : this.defaultTargetEntity;
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String targetEntity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = targetEntity;
        ((RelationshipMappingAnnotation)this.getResourceMapping()).setTargetEntity(targetEntity);
        this.firePropertyChanged("specifiedTargetEntity", old, targetEntity);
    }

    protected void setSpecifiedTargetEntity_(String targetEntity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = targetEntity;
        this.firePropertyChanged("specifiedTargetEntity", old, targetEntity);
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    protected void setDefaultTargetEntity(String targetEntity) {
        String old = this.defaultTargetEntity;
        this.defaultTargetEntity = targetEntity;
        this.firePropertyChanged("defaultTargetEntity", old, targetEntity);
    }

    @Override
    public Entity getResolvedTargetEntity() {
        return this.resolvedTargetEntity;
    }

    protected void setResolvedTargetEntity(Entity entity) {
        Entity old = this.resolvedTargetEntity;
        this.resolvedTargetEntity = entity;
        this.firePropertyChanged("resolvedTargetEntity", old, entity);
    }

    @Override
    public JavaCascade getCascade() {
        return this.cascade;
    }

    @Override
    public FetchType getFetch() {
        return this.specifiedFetch != null ? this.specifiedFetch : this.getDefaultFetch();
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        ((RelationshipMappingAnnotation)this.getResourceMapping()).setFetch(FetchType.toJavaResourceModel(fetch));
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected void setSpecifiedFetch_(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    @Override
    public void initialize(JavaResourcePersistentAttribute jrpa) {
        this.defaultTargetEntity = this.buildDefaultTargetEntity(jrpa);
        super.initialize(jrpa);
    }

    @Override
    public void update(JavaResourcePersistentAttribute jrpa) {
        this.setDefaultTargetEntity(this.buildDefaultTargetEntity(jrpa));
        super.update(jrpa);
    }

    @Override
    protected void initialize(T relationshipMappingAnnotation) {
        this.specifiedFetch = this.buildFetch(relationshipMappingAnnotation);
        this.cascade.initialize((RelationshipMappingAnnotation)relationshipMappingAnnotation);
        this.specifiedTargetEntity = this.buildSpecifiedTargetEntity(relationshipMappingAnnotation);
        this.resolvedTargetEntity = this.buildResolvedTargetEntity(relationshipMappingAnnotation);
    }

    @Override
    protected void update(T relationshipMappingAnnotation) {
        super.update(relationshipMappingAnnotation);
        this.setSpecifiedFetch_(this.buildFetch(relationshipMappingAnnotation));
        this.cascade.update((RelationshipMappingAnnotation)relationshipMappingAnnotation);
        this.setSpecifiedTargetEntity_(this.buildSpecifiedTargetEntity(relationshipMappingAnnotation));
        this.setResolvedTargetEntity(this.buildResolvedTargetEntity(relationshipMappingAnnotation));
    }

    protected FetchType buildFetch(T relationshipMappingAnnotation) {
        return FetchType.fromJavaResourceModel(relationshipMappingAnnotation.getFetch());
    }

    protected String buildSpecifiedTargetEntity(T relationshipMappingAnnotation) {
        return relationshipMappingAnnotation.getTargetEntity();
    }

    protected abstract String buildDefaultTargetEntity(JavaResourcePersistentAttribute var1);

    protected Entity buildResolvedTargetEntity(T relationshipMappingAnnotation) {
        String qualifiedTargetEntity = this.getDefaultTargetEntity();
        if (this.getSpecifiedTargetEntity() != null) {
            qualifiedTargetEntity = relationshipMappingAnnotation.getFullyQualifiedTargetEntity();
        }
        if (qualifiedTargetEntity == null) {
            return null;
        }
        return this.getPersistenceUnit().getEntity(qualifiedTargetEntity);
    }

    @Override
    public Entity getEntity() {
        TypeMapping typeMapping = this.getTypeMapping();
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    @Override
    public String getJoinTableDefaultName() {
        return MappingTools.buildJoinTableDefaultName(this);
    }

    protected Iterator<String> allTargetEntityAttributeNames() {
        Entity targetEntity = this.getResolvedTargetEntity();
        return targetEntity == null ? EmptyIterator.instance() : targetEntity.getPersistentType().allAttributeNames();
    }

    public Iterator<String> candidateMappedByAttributeNames() {
        return this.allTargetEntityAttributeNames();
    }

    protected Iterator<String> candidateMappedByAttributeNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateMappedByAttributeNames(), filter);
    }

    protected Iterator<String> javaCandidateMappedByAttributeNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateMappedByAttributeNames(filter));
    }

    @Override
    public void validate(List<IMessage> messages, CompilationUnit astRoot) {
        super.validate(messages, astRoot);
        this.validateTargetEntity(messages, astRoot);
    }

    protected void validateTargetEntity(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getTargetEntity() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_NOT_DEFINED", new String[]{this.getAttributeName()}, this, this.getValidationTextRange(astRoot)));
        } else if (this.getResolvedTargetEntity() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_IS_NOT_AN_ENTITY", new String[]{this.getTargetEntity(), this.getAttributeName()}, this, this.getTargetEntityTextRange(astRoot)));
        }
    }

    protected TextRange getTextRange(TextRange textRange, CompilationUnit astRoot) {
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    protected TextRange getTargetEntityTextRange(CompilationUnit astRoot) {
        return this.getTextRange(((RelationshipMappingAnnotation)this.getResourceMapping()).getTargetEntityTextRange(astRoot), astRoot);
    }
}

