/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlBaseTable;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraintImpl;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmTable
extends AbstractXmlContextNode
implements Table,
UniqueConstraint.Owner {
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected final List<OrmUniqueConstraint> uniqueConstraints = new ArrayList<OrmUniqueConstraint>();

    protected AbstractOrmTable(XmlContextNode parent) {
        super(parent);
    }

    protected abstract XmlBaseTable getResourceTable();

    protected abstract XmlBaseTable addResourceTable();

    protected abstract void removeResourceTable();

    protected abstract String buildDefaultName();

    protected abstract String buildDefaultSchema();

    protected abstract String buildDefaultCatalog();

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        if (this.attributeValueHasChanged(old, name)) {
            XmlBaseTable resourceTable = this.getResourceTable();
            if (resourceTable == null) {
                resourceTable = this.addResourceTable();
            }
            resourceTable.setName(name);
            if (resourceTable.isAllFeaturesUnset()) {
                this.removeResourceTable();
            }
            this.firePropertyChanged("specifiedName", old, name);
        }
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        if (this.attributeValueHasChanged(old, schema)) {
            XmlBaseTable resourceTable = this.getResourceTable();
            if (resourceTable == null) {
                resourceTable = this.addResourceTable();
            }
            resourceTable.setSchema(schema);
            if (resourceTable.isAllFeaturesUnset()) {
                this.removeResourceTable();
            }
            this.firePropertyChanged("specifiedSchema", old, schema);
        }
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        if (this.attributeValueHasChanged(old, catalog)) {
            XmlBaseTable resourceTable = this.getResourceTable();
            if (resourceTable == null) {
                resourceTable = this.addResourceTable();
            }
            resourceTable.setCatalog(catalog);
            if (resourceTable.isAllFeaturesUnset()) {
                this.removeResourceTable();
            }
            this.firePropertyChanged("specifiedCatalog", old, catalog);
        }
    }

    protected void setSpecifiedCatalog_(String newSpecifiedCatalog) {
        String oldSpecifiedCatalog = this.specifiedCatalog;
        this.specifiedCatalog = newSpecifiedCatalog;
        this.firePropertyChanged("specifiedCatalog", oldSpecifiedCatalog, newSpecifiedCatalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String newDefaultCatalog) {
        String oldDefaultCatalog = this.defaultCatalog;
        this.defaultCatalog = newDefaultCatalog;
        this.firePropertyChanged("defaultCatalog", oldDefaultCatalog, newDefaultCatalog);
    }

    public ListIterator<OrmUniqueConstraint> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public OrmUniqueConstraint addUniqueConstraint(int index) {
        XmlUniqueConstraintImpl resourceConstraint = OrmFactory.eINSTANCE.createXmlUniqueConstraintImpl();
        OrmUniqueConstraint contextConstraint = this.buildUniqueConstraint(resourceConstraint);
        this.uniqueConstraints.add(index, contextConstraint);
        XmlBaseTable resourceTable = this.getResourceTable();
        if (resourceTable == null) {
            resourceTable = this.addResourceTable();
        }
        resourceTable.getUniqueConstraints().add(index, (Object)resourceConstraint);
        this.fireItemAdded("uniqueConstraints", index, contextConstraint);
        return contextConstraint;
    }

    protected void addUniqueConstraint(int index, OrmUniqueConstraint uniqueConstraint) {
        this.addItemToList(index, uniqueConstraint, this.uniqueConstraints, "uniqueConstraints");
    }

    protected void addUniqueConstraint(OrmUniqueConstraint uniqueConstraint) {
        this.addUniqueConstraint(this.uniqueConstraints.size(), uniqueConstraint);
    }

    @Override
    public void removeUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraints.indexOf(uniqueConstraint));
    }

    @Override
    public void removeUniqueConstraint(int index) {
        OrmUniqueConstraint removedUniqueConstraint = this.uniqueConstraints.remove(index);
        this.getResourceTable().getUniqueConstraints().remove(index);
        this.fireItemRemoved("uniqueConstraints", index, removedUniqueConstraint);
    }

    protected void removeUniqueConstraint_(OrmUniqueConstraint uniqueConstraint) {
        this.removeItemFromList(uniqueConstraint, this.uniqueConstraints, "uniqueConstraints");
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.uniqueConstraints, (int)targetIndex, (int)sourceIndex);
        this.getResourceTable().getUniqueConstraints().move(targetIndex, sourceIndex);
        this.fireItemMoved("uniqueConstraints", targetIndex, sourceIndex);
    }

    protected TextRange getTextRange(TextRange textRange) {
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    protected TextRange getNameTextRange() {
        return this.getTextRange(this.getResourceTableNameTextRange());
    }

    protected TextRange getResourceTableNameTextRange() {
        XmlBaseTable resourceTable = this.getResourceTable();
        return resourceTable == null ? null : resourceTable.getNameTextRange();
    }

    protected TextRange getSchemaTextRange() {
        return this.getTextRange(this.getResourceTableSchemaTextRange());
    }

    protected TextRange getResourceTableSchemaTextRange() {
        XmlBaseTable resourceTable = this.getResourceTable();
        return resourceTable == null ? null : resourceTable.getSchemaTextRange();
    }

    protected TextRange getCatalogTextRange() {
        return this.getTextRange(this.getResourceTableCatalogTextRange());
    }

    protected TextRange getResourceTableCatalogTextRange() {
        XmlBaseTable resourceTable = this.getResourceTable();
        return resourceTable == null ? null : resourceTable.getCatalogTextRange();
    }

    protected OrmUniqueConstraint buildUniqueConstraint(XmlUniqueConstraint resourceUniqueConstraint) {
        return this.getJpaFactory().buildOrmUniqueConstraint(this, this, resourceUniqueConstraint);
    }

    protected void initialize(XmlBaseTable xmlTable) {
        this.defaultName = this.buildDefaultName();
        this.specifiedName = this.buildSpecifiedName(xmlTable);
        this.defaultSchema = this.buildDefaultSchema();
        this.specifiedSchema = this.buildSpecifiedSchema(xmlTable);
        this.defaultCatalog = this.buildDefaultCatalog();
        this.specifiedCatalog = this.buildSpecifiedCatalog(xmlTable);
        this.initializeUniqueContraints(xmlTable);
    }

    protected void initializeUniqueContraints(XmlBaseTable xmlTable) {
        if (xmlTable == null) {
            return;
        }
        for (XmlUniqueConstraint uniqueConstraint : xmlTable.getUniqueConstraints()) {
            this.uniqueConstraints.add(this.buildUniqueConstraint(uniqueConstraint));
        }
    }

    protected void update(XmlBaseTable xmlTable) {
        this.setDefaultName(this.buildDefaultName());
        this.setSpecifiedName_(this.buildSpecifiedName(xmlTable));
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setSpecifiedSchema_(this.buildSpecifiedSchema(xmlTable));
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.setSpecifiedCatalog_(this.buildSpecifiedCatalog(xmlTable));
        this.updateUniqueConstraints(xmlTable);
    }

    protected String buildSpecifiedName(XmlBaseTable xmlTable) {
        return xmlTable == null ? null : xmlTable.getName();
    }

    protected String buildSpecifiedSchema(XmlBaseTable xmlTable) {
        return xmlTable == null ? null : xmlTable.getSchema();
    }

    protected String buildSpecifiedCatalog(XmlBaseTable xmlTable) {
        return xmlTable == null ? null : xmlTable.getCatalog();
    }

    protected void updateUniqueConstraints(XmlBaseTable xmlTable) {
        ListIterator<OrmUniqueConstraint> contextConstraints = this.uniqueConstraints();
        ListIterator resourceConstraints = EmptyListIterator.instance();
        if (xmlTable != null) {
            resourceConstraints = new CloneListIterator(xmlTable.getUniqueConstraints());
        }
        while (contextConstraints.hasNext()) {
            OrmUniqueConstraint contextConstraint = contextConstraints.next();
            if (resourceConstraints.hasNext()) {
                contextConstraint.update((XmlUniqueConstraint)resourceConstraints.next());
                continue;
            }
            this.removeUniqueConstraint_(contextConstraint);
        }
        while (resourceConstraints.hasNext()) {
            this.addUniqueConstraint(this.buildUniqueConstraint((XmlUniqueConstraint)resourceConstraints.next()));
        }
    }

    public void initializeFrom(Table oldTable) {
        this.setSpecifiedName(oldTable.getSpecifiedName());
        this.setSpecifiedCatalog(oldTable.getSpecifiedCatalog());
        this.setSpecifiedSchema(oldTable.getSpecifiedSchema());
    }

    @Override
    public org.eclipse.jpt.db.Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getName());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.getDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        if (catalog == null) {
            return null;
        }
        return this.getDbCatalog(catalog);
    }

    @Override
    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    @Override
    public boolean hasResolvedSchema() {
        return this.getDbSchema() != null;
    }

    @Override
    public boolean hasResolvedCatalog() {
        String catalog = this.getCatalog();
        if (catalog == null) {
            return true;
        }
        return this.getDbCatalog(catalog) != null;
    }

    @Override
    public Iterator<String> candidateUniqueConstraintColumnNames() {
        org.eclipse.jpt.db.Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.sortedColumnIdentifiers() : EmptyIterator.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getTextRange(this.getResourceTableValidationTextRange());
    }

    protected TextRange getResourceTableValidationTextRange() {
        XmlBaseTable resourceTable = this.getResourceTable();
        return resourceTable == null ? null : resourceTable.getValidationTextRange();
    }

    @Override
    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getQualifiedName());
    }

    protected String getQualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName((String)this.getCatalog(), (String)this.getSchema(), (String)this.getName());
    }
}

