/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.java.JavaMappedSuperclass;
import org.eclipse.jpt.core.context.orm.OrmMappedSuperclass;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmTypeMapping;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.orm.XmlIdClass;
import org.eclipse.jpt.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmMappedSuperclass
extends AbstractOrmTypeMapping<XmlMappedSuperclass>
implements OrmMappedSuperclass {
    protected String idClass;

    public GenericOrmMappedSuperclass(OrmPersistentType parent) {
        super(parent);
    }

    @Override
    public JavaMappedSuperclass getJavaMappedSuperclass() {
        if (this.javaPersistentType != null && this.javaPersistentType.getMappingKey() == "mappedSuperclass") {
            return (JavaMappedSuperclass)this.javaPersistentType.getMapping();
        }
        return null;
    }

    protected JavaMappedSuperclass getJavaMappedSuperclassForDefaults() {
        if (this.isMetadataComplete()) {
            return null;
        }
        return this.getJavaMappedSuperclass();
    }

    @Override
    public String getIdClass() {
        return this.idClass;
    }

    @Override
    public void setIdClass(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        if (oldIdClass != newIdClass) {
            if (this.getResourceIdClass() != null) {
                this.getResourceIdClass().setClassName(newIdClass);
                if (this.getResourceIdClass().isAllFeaturesUnset()) {
                    this.removeResourceIdClass();
                }
            } else if (newIdClass != null) {
                this.addResourceIdClass();
                this.getResourceIdClass().setClassName(newIdClass);
            }
        }
        this.firePropertyChanged("idClassProperty", oldIdClass, newIdClass);
    }

    protected void setIdClass_(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        this.firePropertyChanged("idClassProperty", oldIdClass, newIdClass);
    }

    protected XmlIdClass getResourceIdClass() {
        return ((XmlMappedSuperclass)this.resourceTypeMapping).getIdClass();
    }

    protected void addResourceIdClass() {
        ((XmlMappedSuperclass)this.resourceTypeMapping).setIdClass(OrmFactory.eINSTANCE.createXmlIdClass());
    }

    protected void removeResourceIdClass() {
        ((XmlMappedSuperclass)this.resourceTypeMapping).setIdClass(null);
    }

    @Override
    public String getKey() {
        return "mappedSuperclass";
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return false;
    }

    @Override
    public Iterator<String> associatedTableNamesIncludingInherited() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<Table> associatedTables() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<Table> associatedTablesIncludingInherited() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> overridableAttributeNames() {
        return this.namesOf(this.overridableAttributes());
    }

    @Override
    public Iterator<OrmPersistentAttribute> overridableAttributes() {
        return new FilteringIterator<OrmPersistentAttribute, OrmPersistentAttribute>(this.getPersistentType().attributes()){

            protected boolean accept(OrmPersistentAttribute o) {
                return o.isOverridableAttribute();
            }
        };
    }

    @Override
    public Iterator<String> overridableAssociationNames() {
        return this.namesOf(this.overridableAssociations());
    }

    @Override
    public Iterator<OrmPersistentAttribute> overridableAssociations() {
        return new FilteringIterator<OrmPersistentAttribute, OrmPersistentAttribute>(this.getPersistentType().attributes()){

            protected boolean accept(OrmPersistentAttribute o) {
                return o.isOverridableAssociation();
            }
        };
    }

    private Iterator<String> namesOf(Iterator<OrmPersistentAttribute> attributes) {
        return new TransformationIterator<OrmPersistentAttribute, String>(attributes){

            protected String transform(OrmPersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    @Override
    public int getXmlSequence() {
        return 0;
    }

    protected Boolean metadataComplete(XmlMappedSuperclass mappedSuperclass) {
        return mappedSuperclass.getMetadataComplete();
    }

    @Override
    public void removeFromResourceModel(XmlEntityMappings entityMappings) {
        entityMappings.getMappedSuperclasses().remove((Object)this.resourceTypeMapping);
    }

    @Override
    public XmlMappedSuperclass addToResourceModel(XmlEntityMappings entityMappings) {
        XmlMappedSuperclass mappedSuperclass = OrmFactory.eINSTANCE.createXmlMappedSuperclass();
        this.getPersistentType().initialize(mappedSuperclass);
        entityMappings.getMappedSuperclasses().add((Object)mappedSuperclass);
        return mappedSuperclass;
    }

    @Override
    public void initialize(XmlMappedSuperclass mappedSuperclass) {
        super.initialize(mappedSuperclass);
        this.initializeIdClass(this.getResourceIdClass());
    }

    protected void initializeIdClass(XmlIdClass idClassResource) {
        this.idClass = this.idClass(idClassResource);
    }

    @Override
    public void update(XmlMappedSuperclass mappedSuperclass) {
        super.update(mappedSuperclass);
        this.updateIdClass(this.getResourceIdClass());
    }

    protected void updateIdClass(XmlIdClass idClassResource) {
        this.setIdClass_(this.idClass(idClassResource));
    }

    protected String idClass(XmlIdClass idClassResource) {
        return idClassResource == null ? null : idClassResource.getClassName();
    }
}

