/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmSingleRelationshipMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.AbstractXmlTypeMapping;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.core.resource.orm.XmlOneToOneImpl;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumnImpl;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmOneToOneMapping
extends AbstractOrmSingleRelationshipMapping<XmlOneToOne>
implements OrmOneToOneMapping {
    protected String mappedBy;
    protected final List<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns = new ArrayList<OrmPrimaryKeyJoinColumn>();

    public GenericOrmOneToOneMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String mappedBy) {
        String old = this.mappedBy;
        this.mappedBy = mappedBy;
        ((XmlOneToOne)this.resourceAttributeMapping).setMappedBy(mappedBy);
        this.firePropertyChanged("mappedByProperty", old, mappedBy);
    }

    protected void setMappedBy_(String mappedBy) {
        String old = this.mappedBy;
        this.mappedBy = mappedBy;
        this.firePropertyChanged("mappedByProperty", old, mappedBy);
    }

    @Override
    public boolean mappedByIsValid(AttributeMapping mappedByMapping) {
        return mappedByMapping.getKey() == "oneToOne";
    }

    public TextRange getMappedByTextRange() {
        TextRange mappedByTextRange = ((XmlOneToOne)this.resourceAttributeMapping).getMappedByTextRange();
        return mappedByTextRange != null ? mappedByTextRange : this.getValidationTextRange();
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return new CloneListIterator(this.primaryKeyJoinColumns);
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.primaryKeyJoinColumns.size();
    }

    @Override
    public OrmPrimaryKeyJoinColumn addPrimaryKeyJoinColumn(int index) {
        XmlPrimaryKeyJoinColumnImpl resourcePkJoinColumn = OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumnImpl();
        OrmPrimaryKeyJoinColumn contextPkJoinColumn = this.buildPrimaryKeyJoinColumn(resourcePkJoinColumn);
        this.primaryKeyJoinColumns.add(index, contextPkJoinColumn);
        ((XmlOneToOne)this.resourceAttributeMapping).getPrimaryKeyJoinColumns().add(index, (Object)resourcePkJoinColumn);
        this.fireItemAdded("primaryKeyJoinColumnsList", index, contextPkJoinColumn);
        return contextPkJoinColumn;
    }

    protected void addPrimaryKeyJoinColumn(int index, OrmPrimaryKeyJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.primaryKeyJoinColumns, "primaryKeyJoinColumnsList");
    }

    protected void addPrimaryKeyJoinColumn(OrmPrimaryKeyJoinColumn joinColumn) {
        this.addPrimaryKeyJoinColumn(this.primaryKeyJoinColumns.size(), joinColumn);
    }

    @Override
    public void removePrimaryKeyJoinColumn(PrimaryKeyJoinColumn pkJoinColumn) {
        this.removePrimaryKeyJoinColumn(this.primaryKeyJoinColumns.indexOf(pkJoinColumn));
    }

    @Override
    public void removePrimaryKeyJoinColumn(int index) {
        OrmPrimaryKeyJoinColumn removedPkJoinColumn = this.primaryKeyJoinColumns.remove(index);
        ((XmlOneToOne)this.resourceAttributeMapping).getPrimaryKeyJoinColumns().remove(index);
        this.fireItemRemoved("primaryKeyJoinColumnsList", index, removedPkJoinColumn);
    }

    protected void removePrimaryKeyJoinColumn_(OrmPrimaryKeyJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.primaryKeyJoinColumns, "primaryKeyJoinColumnsList");
    }

    @Override
    public void movePrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.primaryKeyJoinColumns, (int)targetIndex, (int)sourceIndex);
        ((XmlOneToOne)this.resourceAttributeMapping).getPrimaryKeyJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("primaryKeyJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public boolean containsPrimaryKeyJoinColumns() {
        return !this.primaryKeyJoinColumns.isEmpty();
    }

    @Override
    public String getKey() {
        return "oneToOne";
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmOneToOneMapping(this);
    }

    @Override
    public int getXmlSequence() {
        return 60;
    }

    @Override
    public void initializeFromOrmNonOwningMapping(NonOwningMapping oldMapping) {
        super.initializeFromOrmNonOwningMapping(oldMapping);
        this.setMappedBy(oldMapping.getMappedBy());
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return true;
    }

    @Override
    public XmlOneToOne addToResourceModel(AbstractXmlTypeMapping typeMapping) {
        XmlOneToOneImpl oneToOne = OrmFactory.eINSTANCE.createXmlOneToOneImpl();
        this.getPersistentAttribute().initialize(oneToOne);
        typeMapping.getAttributes().getOneToOnes().add((Object)oneToOne);
        return oneToOne;
    }

    @Override
    public void removeFromResourceModel(AbstractXmlTypeMapping typeMapping) {
        typeMapping.getAttributes().getOneToOnes().remove((Object)this.resourceAttributeMapping);
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.getMappedBy() == null;
    }

    @Override
    public void initialize(XmlAttributeMapping attributeMapping) {
        super.initialize(attributeMapping);
        this.mappedBy = ((XmlOneToOne)this.resourceAttributeMapping).getMappedBy();
        this.initializePrimaryKeyJoinColumns();
    }

    protected void initializePrimaryKeyJoinColumns() {
        if (this.resourceAttributeMapping != null) {
            for (XmlPrimaryKeyJoinColumn resourcePkJoinColumn : ((XmlOneToOne)this.resourceAttributeMapping).getPrimaryKeyJoinColumns()) {
                this.primaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn(resourcePkJoinColumn));
            }
        }
    }

    protected OrmPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(XmlPrimaryKeyJoinColumn resourcePkJoinColumn) {
        return this.getJpaFactory().buildOrmPrimaryKeyJoinColumn(this, new AbstractOrmSingleRelationshipMapping.JoinColumnOwner(), resourcePkJoinColumn);
    }

    @Override
    public void update() {
        super.update();
        this.setMappedBy_(((XmlOneToOne)this.resourceAttributeMapping).getMappedBy());
        this.updatePrimaryKeyJoinColumns();
    }

    protected void updatePrimaryKeyJoinColumns() {
        ListIterator<OrmPrimaryKeyJoinColumn> contextPkJoinColumns = this.primaryKeyJoinColumns();
        CloneListIterator resourcePkJoinColumns = new CloneListIterator(((XmlOneToOne)this.resourceAttributeMapping).getPrimaryKeyJoinColumns());
        while (contextPkJoinColumns.hasNext()) {
            OrmPrimaryKeyJoinColumn pkJoinColumn = contextPkJoinColumns.next();
            if (resourcePkJoinColumns.hasNext()) {
                pkJoinColumn.update((XmlPrimaryKeyJoinColumn)resourcePkJoinColumns.next());
                continue;
            }
            this.removePrimaryKeyJoinColumn_(pkJoinColumn);
        }
        while (resourcePkJoinColumns.hasNext()) {
            this.addPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn((XmlPrimaryKeyJoinColumn)resourcePkJoinColumns.next()));
        }
    }

    @Override
    public void validate(List<IMessage> messages) {
        super.validate(messages);
        if (this.mappedBy != null) {
            this.validateMappedBy(messages);
        }
    }

    @Override
    protected void validateJoinColumns(List<IMessage> messages) {
        if (this.primaryKeyJoinColumns.isEmpty() || this.containsSpecifiedJoinColumns()) {
            super.validateJoinColumns(messages);
        }
    }

    protected void validateMappedBy(List<IMessage> messages) {
        Entity targetEntity = this.getResolvedTargetEntity();
        if (targetEntity == null) {
            return;
        }
        PersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(this.mappedBy);
        if (attribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{this.mappedBy}, this, this.getMappedByTextRange()));
            return;
        }
        AttributeMapping mappedByMapping = attribute.getMapping();
        if (!this.mappedByIsValid(mappedByMapping)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{this.mappedBy}, this, this.getMappedByTextRange()));
            return;
        }
        if (mappedByMapping instanceof NonOwningMapping && ((NonOwningMapping)mappedByMapping).getMappedBy() != null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", this, this.getMappedByTextRange()));
        }
    }
}

