/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmUniqueConstraint
extends AbstractXmlContextNode
implements OrmUniqueConstraint {
    protected final List<String> columnNames;
    protected XmlUniqueConstraint resourceUniqueConstraint;
    protected UniqueConstraint.Owner owner;

    public GenericOrmUniqueConstraint(XmlContextNode parent, UniqueConstraint.Owner owner, XmlUniqueConstraint resourceUniqueConstraint) {
        super(parent);
        this.owner = owner;
        this.columnNames = new ArrayList<String>();
        this.initialize(resourceUniqueConstraint);
    }

    @Override
    public ListIterator<String> columnNames() {
        return new CloneListIterator(this.columnNames);
    }

    @Override
    public int columnNamesSize() {
        return this.columnNames.size();
    }

    @Override
    public void addColumnName(int index, String columnName) {
        this.columnNames.add(index, columnName);
        this.resourceUniqueConstraint.getColumnNames().add(index, (Object)columnName);
        this.fireItemAdded("columnNames", index, columnName);
    }

    protected void addColumnName_(int index, String columnName) {
        this.columnNames.add(index, columnName);
        this.fireItemAdded("columnNames", index, columnName);
    }

    @Override
    public void removeColumnName(String columnName) {
        this.removeColumnName(this.columnNames.indexOf(columnName));
    }

    @Override
    public void removeColumnName(int index) {
        String removedColumnName = this.columnNames.remove(index);
        this.resourceUniqueConstraint.getColumnNames().remove(index);
        this.fireItemRemoved("columnNames", index, removedColumnName);
    }

    protected void removeColumnName_(int index) {
        String removedColumnName = this.columnNames.remove(index);
        this.fireItemRemoved("columnNames", index, removedColumnName);
    }

    @Override
    public void moveColumnName(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.columnNames, (int)targetIndex, (int)sourceIndex);
        this.resourceUniqueConstraint.getColumnNames().move(targetIndex, sourceIndex);
        this.fireItemMoved("columnNames", targetIndex, sourceIndex);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.resourceUniqueConstraint.getValidationTextRange();
    }

    protected void initialize(XmlUniqueConstraint resourceUniqueConstraint) {
        this.resourceUniqueConstraint = resourceUniqueConstraint;
        this.initializeColumnNames();
    }

    protected void initializeColumnNames() {
        CloneListIterator xmlColumnNames = new CloneListIterator(this.resourceUniqueConstraint.getColumnNames());
        for (String annotationColumnName : CollectionTools.iterable((Iterator)xmlColumnNames)) {
            this.columnNames.add(annotationColumnName);
        }
    }

    @Override
    public void update(XmlUniqueConstraint resourceUniqueConstraint) {
        this.resourceUniqueConstraint = resourceUniqueConstraint;
        this.updateColumnNames();
    }

    protected void updateColumnNames() {
        CloneListIterator xmlColumnNames = new CloneListIterator(this.resourceUniqueConstraint.getColumnNames());
        int index = 0;
        for (String xmlColumnName : CollectionTools.iterable((Iterator)xmlColumnNames)) {
            if (this.columnNamesSize() > index) {
                if (this.columnNames.get(index) != xmlColumnName) {
                    this.addColumnName_(index, xmlColumnName);
                }
            } else {
                this.addColumnName_(index, xmlColumnName);
            }
            ++index;
        }
        while (index < this.columnNamesSize()) {
            this.removeColumnName_(index);
        }
    }
}

