/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.resource.java.ContainerAnnotationTools;
import org.eclipse.jpt.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.MethodSignature;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaResourcePersistentMember<E extends Member>
extends AbstractJavaResourceNode
implements JavaResourcePersistentMember {
    private final E member;
    private final Vector<Annotation> mappingAnnotations;
    private final Vector<Annotation> supportingAnnotations;
    private boolean persistable;

    protected AbstractJavaResourcePersistentMember(JavaResourceNode parent, E member) {
        super(parent);
        this.member = member;
        this.supportingAnnotations = new Vector();
        this.mappingAnnotations = new Vector();
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.getMember().getBodyDeclaration(astRoot).accept(this.buildInitialAnnotationVisitor(astRoot));
        this.persistable = this.buildPersistable(astRoot);
    }

    protected ASTVisitor buildInitialAnnotationVisitor(CompilationUnit astRoot) {
        return new InitialAnnotationVisitor(astRoot, this.getMember().getBodyDeclaration(astRoot));
    }

    protected void addInitialAnnotation(org.eclipse.jdt.core.dom.Annotation node, CompilationUnit astRoot) {
        String jdtAnnotationName = JDTTools.resolveAnnotation(node);
        if (jdtAnnotationName == null) {
            return;
        }
        if (this.supportingAnnotationIsValid(jdtAnnotationName)) {
            if (this.getSupportingAnnotation(jdtAnnotationName) == null) {
                Annotation annotation = this.buildSupportingAnnotation(jdtAnnotationName);
                annotation.initialize(astRoot);
                this.supportingAnnotations.add(annotation);
            }
        } else if (this.mappingAnnotationIsValid(jdtAnnotationName) && this.getMappingAnnotation(jdtAnnotationName) == null) {
            Annotation annotation = this.buildMappingAnnotation(jdtAnnotationName);
            annotation.initialize(astRoot);
            this.mappingAnnotations.add(annotation);
        }
    }

    @Override
    public Iterator<Annotation> mappingAnnotations() {
        return new CloneIterator(this.mappingAnnotations);
    }

    @Override
    public int mappingAnnotationsSize() {
        return this.mappingAnnotations.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation getMappingAnnotation() {
        Vector<Annotation> vector = this.mappingAnnotations;
        synchronized (vector) {
            return this.getMappingAnnotation_();
        }
    }

    protected Annotation getMappingAnnotation_() {
        ListIterator<String> stream = this.validMappingAnnotationNames();
        while (stream.hasNext()) {
            Annotation annotation = this.getMappingAnnotation(stream.next());
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public Annotation getMappingAnnotation(String annotationName) {
        return AbstractJavaResourcePersistentMember.getAnnotation(this.mappingAnnotations(), annotationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMappingAnnotation(String annotationName) {
        Vector<Annotation> vector = this.mappingAnnotations;
        synchronized (vector) {
            this.setMappingAnnotation_(annotationName);
        }
        this.fireCollectionChanged("mappingAnnotations");
    }

    protected void setMappingAnnotation_(String annotationName) {
        if (annotationName == null) {
            this.removeMappingAnnotations_();
            return;
        }
        if (this.getMappingAnnotation(annotationName) != null) {
            throw new IllegalStateException("duplicate mapping annotation: " + annotationName);
        }
        this.removeMappingAnnotations_();
        Annotation newMapping = this.buildMappingAnnotation(annotationName);
        this.mappingAnnotations.add(newMapping);
        newMapping.newAnnotation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMappingAnnotations() {
        Vector<Annotation> vector = this.mappingAnnotations;
        synchronized (vector) {
            this.removeMappingAnnotations_();
        }
    }

    protected void removeMappingAnnotations_() {
        ListIterator<String> stream = this.validMappingAnnotationNames();
        while (stream.hasNext()) {
            Annotation mappingAnnotation = this.getMappingAnnotation(stream.next());
            if (mappingAnnotation == null) continue;
            this.mappingAnnotations.remove(mappingAnnotation);
            mappingAnnotation.removeAnnotation();
        }
    }

    @Override
    public JavaResourceNode getNullMappingAnnotation(String annotationName) {
        return this.buildNullMappingAnnotation(annotationName);
    }

    protected abstract Annotation buildNullMappingAnnotation(String var1);

    protected boolean mappingAnnotationIsValid(String annotationName) {
        return CollectionTools.contains(this.validMappingAnnotationNames(), (Object)annotationName);
    }

    protected abstract ListIterator<String> validMappingAnnotationNames();

    protected abstract Annotation buildMappingAnnotation(String var1);

    protected void addMappingAnnotation(Annotation annotation) {
        this.addItemToCollection(annotation, this.mappingAnnotations, "mappingAnnotations");
    }

    protected void removeMappingAnnotation(Annotation annotation) {
        this.removeMappingAnnotation_(annotation);
        annotation.removeAnnotation();
    }

    protected void removeMappingAnnotation_(Annotation annotation) {
        this.removeItemFromCollection(annotation, this.mappingAnnotations, "mappingAnnotations");
    }

    @Override
    public Iterator<Annotation> supportingAnnotations() {
        return new CloneIterator(this.supportingAnnotations);
    }

    @Override
    public int supportingAnnotationsSize() {
        return this.supportingAnnotations.size();
    }

    @Override
    public ListIterator<NestableAnnotation> supportingAnnotations(String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getSupportingContainerAnnotation(containerAnnotationName);
        if (containerAnnotation != null) {
            return containerAnnotation.nestedAnnotations();
        }
        NestableAnnotation nestableAnnotation = this.getSupportingNestableAnnotation(nestableAnnotationName);
        return nestableAnnotation == null ? EmptyListIterator.instance() : new SingleElementListIterator((Object)nestableAnnotation);
    }

    protected NestableAnnotation getSupportingNestableAnnotation(String annotationName) {
        return (NestableAnnotation)this.getSupportingAnnotation(annotationName);
    }

    @Override
    public Annotation getSupportingAnnotation(String annotationName) {
        return AbstractJavaResourcePersistentMember.getAnnotation(this.supportingAnnotations(), annotationName);
    }

    @Override
    public JavaResourceNode getNonNullSupportingAnnotation(String annotationName) {
        Annotation annotation = this.getSupportingAnnotation(annotationName);
        return annotation != null ? annotation : this.buildNullSupportingAnnotation(annotationName);
    }

    protected abstract Annotation buildNullSupportingAnnotation(String var1);

    @Override
    public Annotation addSupportingAnnotation(String annotationName) {
        Annotation annotation = this.buildSupportingAnnotation(annotationName);
        this.supportingAnnotations.add(annotation);
        annotation.newAnnotation();
        this.fireItemAdded("supportingAnnotations", annotation);
        return annotation;
    }

    protected abstract Annotation buildSupportingAnnotation(String var1);

    protected void addSupportingAnnotation(Annotation annotation) {
        this.addItemToCollection(annotation, this.supportingAnnotations, "supportingAnnotations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSupportingAnnotation(String annotationName) {
        Vector<Annotation> vector = this.supportingAnnotations;
        synchronized (vector) {
            this.removeSupportingAnnotation_(annotationName);
        }
    }

    protected void removeSupportingAnnotation_(String annotationName) {
        Annotation annotation = this.getSupportingAnnotation(annotationName);
        if (annotation != null) {
            this.removeSupportingAnnotation(annotation);
        }
    }

    protected void removeSupportingAnnotation(Annotation annotation) {
        this.removeSupportingAnnotation_(annotation);
        annotation.removeAnnotation();
    }

    protected void removeSupportingAnnotation_(Annotation annotation) {
        this.removeItemFromCollection(annotation, this.supportingAnnotations, "supportingAnnotations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NestableAnnotation addSupportingAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        Vector<Annotation> vector = this.supportingAnnotations;
        synchronized (vector) {
            return this.addSupportingAnnotation_(index, nestableAnnotationName, containerAnnotationName);
        }
    }

    protected NestableAnnotation addSupportingAnnotation_(int index, String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getSupportingContainerAnnotation(containerAnnotationName);
        if (containerAnnotation != null) {
            NestableAnnotation newNestedAnnotation = ContainerAnnotationTools.addNestedAnnotation(index, containerAnnotation);
            return newNestedAnnotation;
        }
        NestableAnnotation nestedAnnotation = this.getSupportingNestableAnnotation(nestableAnnotationName);
        if (nestedAnnotation == null) {
            return this.addSupportingNestableAnnotation(nestableAnnotationName);
        }
        ContainerAnnotation<NestableAnnotation> newContainerAnnotation = this.addSupportingContainerAnnotationTwoNestableAnnotations(containerAnnotationName);
        if (index == 0) {
            newContainerAnnotation.nestedAnnotationAt(1).initializeFrom(nestedAnnotation);
        } else {
            newContainerAnnotation.nestedAnnotationAt(0).initializeFrom(nestedAnnotation);
        }
        this.removeSupportingAnnotation(nestedAnnotation);
        return newContainerAnnotation.nestedAnnotationAt(index);
    }

    protected ContainerAnnotation<NestableAnnotation> getSupportingContainerAnnotation(String annotationName) {
        return (ContainerAnnotation)this.getSupportingAnnotation(annotationName);
    }

    protected NestableAnnotation addSupportingNestableAnnotation(String annotationName) {
        return (NestableAnnotation)this.addSupportingAnnotation(annotationName);
    }

    protected ContainerAnnotation<NestableAnnotation> addSupportingContainerAnnotationTwoNestableAnnotations(String annotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.buildContainerAnnotation(annotationName);
        this.supportingAnnotations.add(containerAnnotation);
        containerAnnotation.newAnnotation();
        containerAnnotation.addInternal(0).newAnnotation();
        containerAnnotation.addInternal(1).newAnnotation();
        return containerAnnotation;
    }

    protected ContainerAnnotation<NestableAnnotation> buildContainerAnnotation(String annotationName) {
        return (ContainerAnnotation)this.buildSupportingAnnotation(annotationName);
    }

    protected boolean supportingAnnotationIsValid(String annotationName) {
        return CollectionTools.contains(this.validSupportingAnnotationNames(), (Object)annotationName);
    }

    protected abstract ListIterator<String> validSupportingAnnotationNames();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSupportingAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        Vector<Annotation> vector = this.supportingAnnotations;
        synchronized (vector) {
            this.removeSupportingAnnotation_(index, nestableAnnotationName, containerAnnotationName);
        }
    }

    protected void removeSupportingAnnotation_(int index, String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getSupportingContainerAnnotation(containerAnnotationName);
        if (containerAnnotation == null) {
            Annotation annotation = this.getSupportingAnnotation(nestableAnnotationName);
            this.removeSupportingAnnotation(annotation);
        } else {
            this.removeSupportingAnnotation(index, containerAnnotation);
        }
    }

    protected void removeSupportingAnnotation(int index, ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        NestableAnnotation nestableAnnotation = containerAnnotation.nestedAnnotationAt(index);
        containerAnnotation.remove(index);
        nestableAnnotation.removeAnnotation();
        ContainerAnnotationTools.synchAnnotationsAfterRemove(index, containerAnnotation);
        if (containerAnnotation.nestedAnnotationsSize() == 0) {
            this.removeSupportingAnnotation(containerAnnotation);
        } else if (containerAnnotation.nestedAnnotationsSize() == 1) {
            NestableAnnotation nestedAnnotation = containerAnnotation.nestedAnnotationAt(0);
            this.supportingAnnotations.remove(containerAnnotation);
            containerAnnotation.removeAnnotation();
            NestableAnnotation newAnnotation = (NestableAnnotation)this.buildSupportingAnnotation(containerAnnotation.getNestableAnnotationName());
            this.supportingAnnotations.add(newAnnotation);
            newAnnotation.newAnnotation();
            newAnnotation.initializeFrom(nestedAnnotation);
            this.fireItemAdded("supportingAnnotations", newAnnotation);
            this.fireItemRemoved("supportingAnnotations", containerAnnotation);
        }
    }

    @Override
    public void moveSupportingAnnotation(int targetIndex, int sourceIndex, String containerAnnotationName) {
        this.moveAnnotation(targetIndex, sourceIndex, this.getSupportingContainerAnnotation(containerAnnotationName));
    }

    protected void moveAnnotation(int targetIndex, int sourceIndex, ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        containerAnnotation.move(targetIndex, sourceIndex);
        ContainerAnnotationTools.synchAnnotationsAfterMove(targetIndex, sourceIndex, containerAnnotation);
    }

    @Override
    public boolean isPersistable() {
        return this.persistable;
    }

    protected void setPersistable(boolean persistable) {
        boolean old = this.persistable;
        this.persistable = persistable;
        this.firePropertyChanged("persistable", old, persistable);
    }

    protected boolean buildPersistable(CompilationUnit astRoot) {
        return this.getMember().isPersistable(astRoot);
    }

    @Override
    public boolean isPersisted() {
        return this.getMappingAnnotation() != null;
    }

    @Override
    public boolean isFor(String memberName, int occurrence) {
        return this.member.matches(memberName, occurrence);
    }

    @Override
    public boolean isFor(MethodSignature methodSignature, int occurrence) {
        return false;
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return this.fullTextRange(astRoot);
    }

    protected TextRange fullTextRange(CompilationUnit astRoot) {
        return AbstractJavaResourcePersistentMember.getTextRange((ASTNode)this.getMember().getBodyDeclaration(astRoot));
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getMember().getNameTextRange(astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.updateAnnotations(astRoot);
        this.setPersistable(this.buildPersistable(astRoot));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAnnotations(CompilationUnit astRoot) {
        Vector<Annotation> vector = this.mappingAnnotations;
        synchronized (vector) {
            Vector<Annotation> vector2 = this.supportingAnnotations;
            synchronized (vector2) {
                this.updateAnnotations_(astRoot);
            }
        }
    }

    protected void updateAnnotations_(CompilationUnit astRoot) {
        HashSet<Annotation> mappingAnnotationsToRemove = new HashSet<Annotation>(this.mappingAnnotations);
        HashSet<Annotation> supportingAnnotationsToRemove = new HashSet<Annotation>(this.supportingAnnotations);
        this.getMember().getBodyDeclaration(astRoot).accept(this.buildUpdateAnnotationVisitor(astRoot, mappingAnnotationsToRemove, supportingAnnotationsToRemove));
        for (Annotation annotation : mappingAnnotationsToRemove) {
            this.removeMappingAnnotation_(annotation);
        }
        for (Annotation annotation : supportingAnnotationsToRemove) {
            this.removeSupportingAnnotation_(annotation);
        }
    }

    protected ASTVisitor buildUpdateAnnotationVisitor(CompilationUnit astRoot, Set<Annotation> mappingAnnotationsToRemove, Set<Annotation> supportingAnnotationsToRemove) {
        return new UpdateAnnotationVisitor(astRoot, this.getMember().getBodyDeclaration(astRoot), mappingAnnotationsToRemove, supportingAnnotationsToRemove);
    }

    protected void addOrUpdateAnnotation(org.eclipse.jdt.core.dom.Annotation node, CompilationUnit astRoot, Set<Annotation> mappingAnnotationsToRemove, Set<Annotation> supportingAnnotationsToRemove) {
        String jdtAnnotationName = JDTTools.resolveAnnotation(node);
        if (jdtAnnotationName == null) {
            return;
        }
        if (this.supportingAnnotationIsValid(jdtAnnotationName)) {
            this.addOrUpdateSupportingAnnotation(jdtAnnotationName, astRoot, supportingAnnotationsToRemove);
            return;
        }
        if (this.mappingAnnotationIsValid(jdtAnnotationName)) {
            this.addOrUpdateMappingAnnotation(jdtAnnotationName, astRoot, mappingAnnotationsToRemove);
            return;
        }
    }

    protected void addOrUpdateSupportingAnnotation(String jdtAnnotationName, CompilationUnit astRoot, Set<Annotation> supportingAnnotationsToRemove) {
        Annotation annotation = AbstractJavaResourcePersistentMember.getAnnotation(supportingAnnotationsToRemove, jdtAnnotationName);
        if (annotation != null) {
            annotation.update(astRoot);
            supportingAnnotationsToRemove.remove(annotation);
        } else {
            annotation = this.buildSupportingAnnotation(jdtAnnotationName);
            annotation.initialize(astRoot);
            this.addSupportingAnnotation(annotation);
        }
    }

    protected void addOrUpdateMappingAnnotation(String jdtAnnotationName, CompilationUnit astRoot, Set<Annotation> mappingAnnotationsToRemove) {
        Annotation annotation = AbstractJavaResourcePersistentMember.getAnnotation(mappingAnnotationsToRemove, jdtAnnotationName);
        if (annotation != null) {
            annotation.update(astRoot);
            mappingAnnotationsToRemove.remove(annotation);
        } else {
            annotation = this.buildMappingAnnotation(jdtAnnotationName);
            annotation.initialize(astRoot);
            this.addMappingAnnotation(annotation);
        }
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        this.setPersistable(this.buildPersistable(astRoot));
    }

    protected E getMember() {
        return this.member;
    }

    protected static Annotation getAnnotation(Iterable<Annotation> annotations, String annotationName) {
        return AbstractJavaResourcePersistentMember.getAnnotation(annotations.iterator(), annotationName);
    }

    protected static Annotation getAnnotation(Iterator<Annotation> annotations, String annotationName) {
        while (annotations.hasNext()) {
            Annotation annotation = annotations.next();
            if (!annotation.getAnnotationName().equals(annotationName)) continue;
            return annotation;
        }
        return null;
    }

    protected static TextRange getTextRange(ASTNode astNode) {
        return astNode == null ? null : new ASTNodeTextRange(astNode);
    }

    protected static <T extends JavaResourcePersistentMember> Iterator<T> persistableMembers(Iterator<T> members) {
        return new FilteringIterator<T, T>(members){

            protected boolean accept(T member) {
                return member.isPersistable();
            }
        };
    }

    protected static abstract class AnnotationVisitor
    extends ASTVisitor {
        private final CompilationUnit astRoot;
        private final BodyDeclaration bodyDeclaration;

        protected AnnotationVisitor(CompilationUnit astRoot, BodyDeclaration bodyDeclaration) {
            this.astRoot = astRoot;
            this.bodyDeclaration = bodyDeclaration;
        }

        public boolean visit(SingleMemberAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        public boolean visit(NormalAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        public boolean visit(MarkerAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        protected boolean visit_(org.eclipse.jdt.core.dom.Annotation node) {
            if (node.getParent() == this.bodyDeclaration) {
                this.visitChildAnnotation(node);
            }
            return false;
        }

        protected CompilationUnit getASTRoot() {
            return this.astRoot;
        }

        protected abstract void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InitialAnnotationVisitor
    extends AnnotationVisitor {
        protected InitialAnnotationVisitor(CompilationUnit astRoot, BodyDeclaration bodyDeclaration) {
            super(astRoot, bodyDeclaration);
        }

        @Override
        protected void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation node) {
            AbstractJavaResourcePersistentMember.this.addInitialAnnotation(node, this.getASTRoot());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UpdateAnnotationVisitor
    extends AnnotationVisitor {
        protected final Set<Annotation> mappingAnnotationsToRemove;
        protected final Set<Annotation> supportingAnnotationsToRemove;

        protected UpdateAnnotationVisitor(CompilationUnit astRoot, BodyDeclaration bodyDeclaration, Set<Annotation> mappingAnnotationsToRemove, Set<Annotation> supportingAnnotationsToRemove) {
            super(astRoot, bodyDeclaration);
            this.mappingAnnotationsToRemove = mappingAnnotationsToRemove;
            this.supportingAnnotationsToRemove = supportingAnnotationsToRemove;
        }

        @Override
        protected void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation node) {
            AbstractJavaResourcePersistentMember.this.addOrUpdateAnnotation(node, this.getASTRoot(), this.mappingAnnotationsToRemove, this.supportingAnnotationsToRemove);
        }
    }
}

