/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.ContainerAnnotationTools;
import org.eclipse.jpt.core.internal.resource.java.JoinColumnImpl;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JoinColumnsAnnotation;
import org.eclipse.jpt.core.resource.java.NestableJoinColumn;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinColumnsImpl
extends AbstractResourceAnnotation<Member>
implements JoinColumnsAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinColumns");
    private List<NestableJoinColumn> joinColumns = new ArrayList<NestableJoinColumn>();

    protected JoinColumnsImpl(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        ContainerAnnotationTools.initializeNestedAnnotations(astRoot, this);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.JoinColumns";
    }

    @Override
    public String getNestableAnnotationName() {
        return "javax.persistence.JoinColumn";
    }

    @Override
    public ListIterator<NestableJoinColumn> nestedAnnotations() {
        return new CloneListIterator(this.joinColumns);
    }

    @Override
    public int nestedAnnotationsSize() {
        return this.joinColumns.size();
    }

    @Override
    public NestableJoinColumn addInternal(int index) {
        JoinColumnImpl joinColumn = this.createJoinColumn(index);
        this.joinColumns.add(index, joinColumn);
        return joinColumn;
    }

    @Override
    public NestableJoinColumn add(int index) {
        JoinColumnImpl joinColumn = this.createJoinColumn(index);
        this.add(index, joinColumn);
        return joinColumn;
    }

    protected void add(int index, NestableJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.joinColumns, "joinColumnsList");
    }

    @Override
    public void remove(NestableJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.joinColumns, "joinColumnsList");
    }

    @Override
    public void remove(int index) {
        this.removeItemFromList(index, this.joinColumns, "joinColumnsList");
    }

    @Override
    public int indexOf(NestableJoinColumn joinColumn) {
        return this.joinColumns.indexOf(joinColumn);
    }

    @Override
    public NestableJoinColumn nestedAnnotationAt(int index) {
        return this.joinColumns.get(index);
    }

    @Override
    public NestableJoinColumn nestedAnnotationFor(Annotation jdtAnnotation) {
        for (NestableJoinColumn joinColumn : this.joinColumns) {
            if (jdtAnnotation != joinColumn.getJdtAnnotation((CompilationUnit)jdtAnnotation.getRoot())) continue;
            return joinColumn;
        }
        return null;
    }

    @Override
    public void move(int targetIndex, int sourceIndex) {
        this.moveItemInList(targetIndex, sourceIndex, this.joinColumns, "joinColumnsList");
    }

    @Override
    public void moveInternal(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.joinColumns, (int)targetIndex, (int)sourceIndex);
    }

    @Override
    public String getElementName() {
        return "value";
    }

    @Override
    public void update(CompilationUnit astRoot) {
        ContainerAnnotationTools.updateNestedAnnotationsFromJava(astRoot, this);
    }

    private JoinColumnImpl createJoinColumn(int index) {
        return JoinColumnImpl.createNestedJoinColumn(this, this.getMember(), index, this.getDeclarationAnnotationAdapter());
    }

    public static class JoinColumnsAnnotationDefinition
    implements AnnotationDefinition {
        private static final JoinColumnsAnnotationDefinition INSTANCE = new JoinColumnsAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private JoinColumnsAnnotationDefinition() {
        }

        public JoinColumnsAnnotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new JoinColumnsImpl(parent, member);
        }

        public JoinColumnsAnnotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.JoinColumns";
        }
    }
}

