/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource.common;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jpt.core.resource.common.JpaEObject;
import org.eclipse.jpt.core.resource.common.JpaXmlResource;
import org.eclipse.jpt.core.utility.AbstractTextRange;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaEObject
extends EObjectImpl
implements JpaEObject {
    protected IDOMNode node;
    private static final Hashtable<Class<? extends AbstractJpaEObject>, HashSet<Integer>> insignificantFeatureIdSets = new Hashtable();

    protected AbstractJpaEObject() {
    }

    @Override
    public JpaXmlResource getResource() {
        return (JpaXmlResource)this.eResource();
    }

    @Override
    public IResource getPlatformResource() {
        return this.getResource().getFile();
    }

    @Override
    public JpaEObject getRoot() {
        return ((JpaEObject)this.eContainer()).getRoot();
    }

    @Override
    public boolean isAllFeaturesUnset() {
        for (EStructuralFeature feature : this.eClass().getEAllStructuralFeatures()) {
            if (!this.eIsSet(feature)) continue;
            return false;
        }
        return true;
    }

    public EList<Adapter> eAdapters() {
        if (this.eAdapters == null) {
            this.eAdapters = new XmlEAdapterList((Notifier)this);
        }
        return this.eAdapters;
    }

    public void eNotify(Notification notification) {
        if (!notification.isTouch()) {
            super.eNotify(notification);
            this.featureChanged(notification.getFeatureID(this.getClass()));
        }
    }

    protected void featureChanged(int featureId) {
        if (this.featureIsSignificant(featureId)) {
            this.getResource().resourceModelChanged();
        }
    }

    protected boolean featureIsSignificant(int featureId) {
        return !this.featureIsInsignificant(featureId);
    }

    protected boolean featureIsInsignificant(int featureId) {
        return this.insignificantFeatureIds().contains(new Integer(featureId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Integer> insignificantFeatureIds() {
        Hashtable<Class<? extends AbstractJpaEObject>, HashSet<Integer>> hashtable = insignificantFeatureIdSets;
        synchronized (hashtable) {
            HashSet<Integer> insignificantXmlFeatureIds = insignificantFeatureIdSets.get(this.getClass());
            if (insignificantXmlFeatureIds == null) {
                insignificantXmlFeatureIds = new HashSet();
                this.addInsignificantXmlFeatureIdsTo(insignificantXmlFeatureIds);
                insignificantFeatureIdSets.put(this.getClass(), insignificantXmlFeatureIds);
            }
            return insignificantXmlFeatureIds;
        }
    }

    protected void addInsignificantXmlFeatureIdsTo(Set<Integer> insignificantXmlFeatureIds) {
    }

    protected TextRange getAttributeTextRange(String attributeName) {
        IDOMNode attributeNode = this.getAttributeNode(attributeName);
        return attributeNode != null ? AbstractJpaEObject.buildTextRange(attributeNode) : this.getValidationTextRange();
    }

    protected IDOMNode getAttributeNode(String attributeName) {
        return (IDOMNode)this.node.getAttributes().getNamedItem(attributeName);
    }

    protected TextRange getElementTextRange(String elementName) {
        IDOMNode elementNode = this.getElementNode(elementName);
        return elementNode != null ? AbstractJpaEObject.buildTextRange(elementNode) : this.getValidationTextRange();
    }

    protected IDOMNode getElementNode(String elementName) {
        int i = 0;
        while (i < this.node.getChildNodes().getLength()) {
            IDOMNode node = (IDOMNode)this.node.getChildNodes().item(i);
            if (node.getNodeType() == 1 && elementName.equals(node.getNodeName())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getFullTextRange();
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getFullTextRange();
    }

    protected TextRange getFullTextRange() {
        return AbstractJpaEObject.buildTextRange(this.node);
    }

    protected static TextRange buildTextRange(IDOMNode domNode) {
        return domNode == null ? null : new DOMNodeTextRange(domNode);
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.node == null ? false : this.node.contains(textOffset);
    }

    protected static class DOMNodeTextRange
    extends AbstractTextRange {
        private final IDOMNode node;

        DOMNodeTextRange(IDOMNode node) {
            this.node = node;
        }

        public int getOffset() {
            return this.node.getStartOffset();
        }

        public int getLength() {
            if (this.node.getNodeType() == 1) {
                return ((IDOMElement)this.node).getStartEndOffset() - this.node.getStartOffset();
            }
            return this.node.getLength();
        }

        public int getLineNumber() {
            return this.node.getStructuredDocument().getLineOfOffset(this.getOffset()) + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlEAdapterList<E>
    extends BasicNotifierImpl.EAdapterList<E> {
        public XmlEAdapterList(Notifier notifier) {
            super(notifier);
        }

        protected void didAdd(int index, E newObject) {
            Node node;
            super.didAdd(index, newObject);
            if (newObject instanceof EMF2DOMAdapter && (node = ((EMF2DOMAdapter)newObject).getNode()) instanceof IDOMNode) {
                AbstractJpaEObject.this.node = (IDOMNode)node;
            }
        }

        protected void didRemove(int index, E oldObject) {
            if (oldObject instanceof EMF2DOMAdapter && ((EMF2DOMAdapter)oldObject).getNode() == AbstractJpaEObject.this.node) {
                AbstractJpaEObject.this.node = null;
            }
            super.didRemove(index, oldObject);
        }
    }
}

