/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource.common;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jpt.core.ResourceModelListener;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResourceImpl;

public abstract class JpaXmlResource
extends TranslatorResourceImpl {
    private ResourceModelListener resourceModelListener;

    protected JpaXmlResource(URI uri, Renderer renderer) {
        super(uri, renderer);
    }

    public void eNotify(Notification notification) {
        if (!notification.isTouch() && this.isLoaded()) {
            super.eNotify(notification);
            this.resourceModelChanged();
        }
    }

    protected String getDefaultPublicId() {
        return null;
    }

    protected String getDefaultSystemId() {
        return null;
    }

    protected int getDefaultVersionID() {
        return 10;
    }

    public String getDoctype() {
        return null;
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public IFile getFile() {
        IFile file = JpaXmlResource.getFile(this.uri);
        return file != null ? file : this.getConvertedURIFile();
    }

    protected IFile getConvertedURIFile() {
        if (this.resourceSet == null) {
            return null;
        }
        URI convertedURI = this.resourceSet.getURIConverter().normalize(this.uri);
        return this.uri.equals((Object)convertedURI) ? null : JpaXmlResource.getFile(convertedURI);
    }

    protected static IFile getFile(URI uri) {
        if (!WorkbenchResourceHelperBase.isPlatformResourceURI((URI)uri)) {
            return null;
        }
        String fileName = URI.decode((String)uri.path()).substring("resource".length() + 1);
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName));
    }

    public abstract String getType();

    public String toString() {
        return StringTools.buildToStringFor((Object)((Object)this), (Object)this.getURI());
    }

    public void setResourceModelListener(ResourceModelListener resourceModelListener) {
        this.resourceModelListener = resourceModelListener;
    }

    public void resourceModelChanged() {
        if (this.resourceModelListener != null) {
            this.resourceModelListener.resourceModelChanged();
        }
    }

    public EList eAdapters() {
        return super.eAdapters();
    }

    public EList getContents() {
        return super.getContents();
    }
}

