/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.ExactNumericDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.NumericalDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.internal.DTPDatabaseObjectWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.utility.JavaType;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.SimpleJavaType;

final class DTPColumnWrapper
extends DTPDatabaseObjectWrapper
implements Column {
    private final org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn;
    private static final JavaType DEFAULT_JAVA_TYPE = new SimpleJavaType(Object.class);
    private static final JavaType BLOB_JAVA_TYPE = new SimpleJavaType(Blob.class);
    private static final JavaType BYTE_ARRAY_JAVA_TYPE = new SimpleJavaType(byte[].class);
    private static final JavaType CLOB_JAVA_TYPE = new SimpleJavaType(Clob.class);
    private static final JavaType STRING_JAVA_TYPE = new SimpleJavaType(String.class);
    private static final JavaType UTIL_DATE_JAVA_TYPE = new SimpleJavaType(java.util.Date.class);
    private static final JavaType SQL_DATE_JAVA_TYPE = new SimpleJavaType(Date.class);
    private static final JavaType SQL_TIME_JAVA_TYPE = new SimpleJavaType(Time.class);
    private static final JavaType SQL_TIMESTAMP_JAVA_TYPE = new SimpleJavaType(Timestamp.class);
    private static final JavaType BIG_DECIMAL_JAVA_TYPE = new SimpleJavaType(BigDecimal.class);
    private static final JavaType LONG_JAVA_TYPE = new SimpleJavaType(Long.TYPE);

    DTPColumnWrapper(DTPTableWrapper table, org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn) {
        super(table, dtpColumn);
        this.dtpColumn = dtpColumn;
    }

    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
        this.getConnectionProfile().columnChanged(this);
    }

    public String getName() {
        return this.dtpColumn.getName();
    }

    public DTPTableWrapper getTable() {
        return (DTPTableWrapper)this.getParent();
    }

    public boolean isPartOfPrimaryKey() {
        return this.getTable().primaryKeyColumnsContains(this);
    }

    public boolean isPartOfForeignKey() {
        return this.getTable().foreignKeyBaseColumnsContains(this);
    }

    public boolean isPartOfUniqueConstraint() {
        return this.dtpColumn.isPartOfUniqueConstraint();
    }

    public boolean isNullable() {
        return this.dtpColumn.isNullable();
    }

    public String getDataTypeName() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType == null ? null : dataType.getName();
    }

    public boolean isNumeric() {
        return this.dtpColumn.getDataType() instanceof NumericalDataType;
    }

    public int getPrecision() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType instanceof NumericalDataType ? ((NumericalDataType)dataType).getPrecision() : -1;
    }

    public int getScale() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType instanceof ExactNumericDataType ? ((ExactNumericDataType)dataType).getScale() : -1;
    }

    public int getLength() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType instanceof CharacterStringDataType ? ((CharacterStringDataType)dataType).getLength() : -1;
    }

    public boolean isLOB() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType instanceof PredefinedDataType ? DTPColumnWrapper.primitiveTypeIsLob(((PredefinedDataType)dataType).getPrimitiveType()) : false;
    }

    public String getJavaTypeDeclaration() {
        return this.getJavaType().declaration();
    }

    public JavaType getJavaType() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType instanceof PredefinedDataType ? DTPColumnWrapper.convertToJPAJavaType(this.getJavaType((PredefinedDataType)dataType)) : DEFAULT_JAVA_TYPE;
    }

    public String getPrimaryKeyJavaTypeDeclaration() {
        return this.getPrimaryKeyJavaType().declaration();
    }

    public JavaType getPrimaryKeyJavaType() {
        return DTPColumnWrapper.convertToJPAPrimaryKeyJavaType(this.getJavaType());
    }

    private JavaType getJavaType(PredefinedDataType dataType) {
        String dtpJavaClassName = this.getDefinition(dataType).getJavaClassName();
        return new SimpleJavaType(ClassTools.classNameForTypeDeclaration((String)dtpJavaClassName));
    }

    private PredefinedDataTypeDefinition getDefinition(PredefinedDataType dataType) {
        return this.getDatabase().getDTPDefinition().getPredefinedDataTypeDefinition(dataType.getName());
    }

    public int compareTo(Column column) {
        return Collator.getInstance().compare(this.getName(), column.getName());
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.tables.Column column) {
        return this.dtpColumn == column;
    }

    void clear() {
    }

    private static JavaType convertToJPAJavaType(JavaType javaType) {
        if (javaType.equals(BLOB_JAVA_TYPE)) {
            return BYTE_ARRAY_JAVA_TYPE;
        }
        if (javaType.equals(CLOB_JAVA_TYPE)) {
            return STRING_JAVA_TYPE;
        }
        return javaType;
    }

    private static JavaType convertToJPAPrimaryKeyJavaType(JavaType javaType) {
        if (javaType.isVariablePrimitive() || javaType.isVariablePrimitiveWrapper() || javaType.equals(STRING_JAVA_TYPE) || javaType.equals(UTIL_DATE_JAVA_TYPE) || javaType.equals(SQL_DATE_JAVA_TYPE)) {
            return javaType;
        }
        if (javaType.equals(BIG_DECIMAL_JAVA_TYPE)) {
            return LONG_JAVA_TYPE;
        }
        if (javaType.equals(SQL_TIME_JAVA_TYPE)) {
            return UTIL_DATE_JAVA_TYPE;
        }
        if (javaType.equals(SQL_TIMESTAMP_JAVA_TYPE)) {
            return UTIL_DATE_JAVA_TYPE;
        }
        return STRING_JAVA_TYPE;
    }

    private static boolean primitiveTypeIsLob(PrimitiveType primitiveType) {
        return primitiveType == PrimitiveType.BINARY_LARGE_OBJECT_LITERAL || primitiveType == PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL || primitiveType == PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL;
    }
}

