/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.text.Collator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.DatabaseObject;
import org.eclipse.jpt.db.internal.DTPCatalogWrapper;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaContainerWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPDatabaseWrapper
extends DTPSchemaContainerWrapper
implements Database {
    private final org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase;
    private DTPCatalogWrapper[] catalogs;
    private DTPCatalogWrapper defaultCatalog;
    private boolean defaultCatalogCalculated = false;
    private static final DTPCatalogWrapper[] EMPTY_CATALOGS = new DTPCatalogWrapper[0];
    private static HashMap<String, Vendor> Vendors;

    DTPDatabaseWrapper(DTPConnectionProfileWrapper connectionProfile, org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase) {
        super(connectionProfile, dtpDatabase);
        this.dtpDatabase = dtpDatabase;
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
        this.getConnectionProfile().databaseChanged(this);
    }

    @Override
    public DTPDatabaseWrapper getDatabase() {
        return this;
    }

    @Override
    List<Schema> getDTPSchemata() {
        List<org.eclipse.datatools.modelbase.sql.schema.Catalog> dtpCatalogs = this.getDTPCatalogs();
        if (dtpCatalogs == null || dtpCatalogs.isEmpty()) {
            return this.dtpDatabase.getSchemas();
        }
        org.eclipse.datatools.modelbase.sql.schema.Catalog virtualCatalog = DTPDatabaseWrapper.getVirtualCatalog(dtpCatalogs);
        return virtualCatalog != null ? virtualCatalog.getSchemas() : Collections.emptyList();
    }

    @Override
    DTPSchemaWrapper getSchema(Schema dtpSchema) {
        return this.getSchema_(dtpSchema);
    }

    @Override
    DTPTableWrapper getTable(Table dtpTable) {
        return this.getTable_(dtpTable);
    }

    @Override
    DTPColumnWrapper getColumn(Column dtpColumn) {
        return this.getColumn_(dtpColumn);
    }

    @Override
    public String getName() {
        return this.dtpDatabase.getName();
    }

    @Override
    public String getVendorName() {
        return this.dtpDatabase.getVendor();
    }

    @Override
    public String getVersion() {
        return this.dtpDatabase.getVersion();
    }

    @Override
    public <T extends DatabaseObject> T selectDatabaseObjectForIdentifier(T[] databaseObjects, String identifier) {
        return (T)super.selectDatabaseObjectForIdentifier(databaseObjects, identifier);
    }

    @Override
    public boolean supportsCatalogs() {
        return DTPDatabaseWrapper.supportsCatalogs(this.getDTPCatalogs());
    }

    private static boolean supportsCatalogs(List<org.eclipse.datatools.modelbase.sql.schema.Catalog> dtpCatalogs) {
        if (dtpCatalogs == null || dtpCatalogs.isEmpty()) {
            return false;
        }
        return !DTPDatabaseWrapper.listContainsOnlyAVirtualCatalog(dtpCatalogs);
    }

    private static boolean listContainsOnlyAVirtualCatalog(List<org.eclipse.datatools.modelbase.sql.schema.Catalog> dtpCatalogs) {
        return DTPDatabaseWrapper.getVirtualCatalog(dtpCatalogs) != null;
    }

    private static org.eclipse.datatools.modelbase.sql.schema.Catalog getVirtualCatalog(List<org.eclipse.datatools.modelbase.sql.schema.Catalog> dtpCatalogs) {
        org.eclipse.datatools.modelbase.sql.schema.Catalog dtpCatalog;
        if (dtpCatalogs.size() == 1 && (dtpCatalog = dtpCatalogs.get(0)).getName().equals("")) {
            return dtpCatalog;
        }
        return null;
    }

    @Override
    public Iterator<Catalog> catalogs() {
        return new ArrayIterator((Object[])this.getCatalogs());
    }

    private Iterator<DTPCatalogWrapper> catalogWrappers() {
        return new ArrayIterator((Object[])this.getCatalogs());
    }

    private synchronized DTPCatalogWrapper[] getCatalogs() {
        if (this.catalogs == null) {
            this.catalogs = this.buildCatalogs();
        }
        return this.catalogs;
    }

    private DTPCatalogWrapper[] buildCatalogs() {
        List<org.eclipse.datatools.modelbase.sql.schema.Catalog> dtpCatalogs = this.getDTPCatalogs();
        if (!DTPDatabaseWrapper.supportsCatalogs(dtpCatalogs)) {
            return EMPTY_CATALOGS;
        }
        Object[] result = new DTPCatalogWrapper[dtpCatalogs.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPCatalogWrapper(this, dtpCatalogs.get(i));
        }
        return (DTPCatalogWrapper[])CollectionTools.sort((Object[])result);
    }

    private List<org.eclipse.datatools.modelbase.sql.schema.Catalog> getDTPCatalogs() {
        return this.dtpDatabase.getCatalogs();
    }

    @Override
    public int catalogsSize() {
        return this.getCatalogs().length;
    }

    DTPCatalogWrapper getCatalog(org.eclipse.datatools.modelbase.sql.schema.Catalog dtpCatalog) {
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.getCatalogs();
        int n = dTPCatalogWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            if (catalog.wraps(dtpCatalog)) {
                return catalog;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid DTP catalog: " + dtpCatalog);
    }

    @Override
    public DTPCatalogWrapper getCatalogNamed(String name) {
        return (DTPCatalogWrapper)this.selectDatabaseObjectNamed(this.getCatalogs(), name);
    }

    @Override
    public Iterator<String> sortedCatalogIdentifiers() {
        return new TransformationIterator<DTPCatalogWrapper, String>(this.catalogWrappers()){

            protected String transform(DTPCatalogWrapper next) {
                return next.getIdentifier();
            }
        };
    }

    @Override
    public DTPCatalogWrapper getCatalogForIdentifier(String identifier) {
        return (DTPCatalogWrapper)this.selectDatabaseObjectForIdentifier(this.getCatalogs(), identifier);
    }

    @Override
    public synchronized DTPCatalogWrapper getDefaultCatalog() {
        if (!this.defaultCatalogCalculated) {
            this.defaultCatalogCalculated = true;
            this.defaultCatalog = this.buildDefaultCatalog();
        }
        return this.defaultCatalog;
    }

    private DTPCatalogWrapper buildDefaultCatalog() {
        return this.supportsCatalogs() ? this.getVendor().getDefaultCatalog(this) : null;
    }

    @Override
    synchronized DTPSchemaWrapper[] getSchemata() {
        DTPCatalogWrapper cat = this.getDefaultCatalog();
        return cat != null ? cat.getSchemata() : super.getSchemata();
    }

    DTPSchemaWrapper getDefaultSchema(DTPSchemaContainerWrapper schemaContainer) {
        return this.getVendor().getDefaultSchema(schemaContainer);
    }

    String convertNameToIdentifier(String name, String defaultName) {
        return this.getVendor().convertNameToIdentifier(name, defaultName);
    }

    @Override
    public String convertNameToIdentifier(String name) {
        return this.getVendor().convertNameToIdentifier(name);
    }

    <T extends DatabaseObject> T selectDatabaseObjectForIdentifier_(T[] databaseObjects, String identifier) {
        return (T)this.selectDatabaseObjectNamed((DatabaseObject[])databaseObjects, this.convertIdentifierToName(identifier));
    }

    String convertIdentifierToName(String identifier) {
        return this.getVendor().convertIdentifierToName(identifier);
    }

    @Override
    public int compareTo(Database database) {
        return Collator.getInstance().compare(this.getName(), database.getName());
    }

    DatabaseDefinition getDTPDefinition() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.dtpDatabase);
    }

    private Vendor getVendor() {
        return DTPDatabaseWrapper.getVendor(this.getVendorName());
    }

    @Override
    synchronized void startListening() {
        if (this.catalogs != null) {
            this.startCatalogs();
        }
        super.startListening();
    }

    private void startCatalogs() {
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.catalogs;
        int n = this.catalogs.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            catalog.startListening();
            ++n2;
        }
    }

    @Override
    synchronized void stopListening() {
        if (this.catalogs != null) {
            this.stopCatalogs();
        }
        super.stopListening();
    }

    private void stopCatalogs() {
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.catalogs;
        int n = this.catalogs.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            catalog.stopListening();
            ++n2;
        }
    }

    @Override
    void clear() {
        this.defaultCatalogCalculated = false;
        this.defaultCatalog = null;
        if (this.catalogs != null) {
            this.clearCatalogs();
        }
        super.clear();
    }

    private void clearCatalogs() {
        this.stopCatalogs();
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.catalogs;
        int n = this.catalogs.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            catalog.clear();
            ++n2;
        }
        this.catalogs = null;
    }

    private static Vendor getVendor(String name) {
        Vendor vendor = DTPDatabaseWrapper.getVendors().get(name);
        return vendor != null ? vendor : Default.INSTANCE;
    }

    private static synchronized HashMap<String, Vendor> getVendors() {
        if (Vendors == null) {
            Vendors = DTPDatabaseWrapper.buildVendors();
        }
        return Vendors;
    }

    private static HashMap<String, Vendor> buildVendors() {
        HashMap<String, Vendor> map = new HashMap<String, Vendor>(20);
        DTPDatabaseWrapper.putVendor(map, Derby.INSTANCE);
        DTPDatabaseWrapper.putVendor(map, HSQLDB.INSTANCE);
        DTPDatabaseWrapper.putVendor(map, DB2.UDB);
        DTPDatabaseWrapper.putVendor(map, DB2.UDB_I_SERIES);
        DTPDatabaseWrapper.putVendor(map, DB2.UDB_Z_SERIES);
        DTPDatabaseWrapper.putVendor(map, Informix.INSTANCE);
        DTPDatabaseWrapper.putVendor(map, SQLServer.INSTANCE);
        DTPDatabaseWrapper.putVendor(map, MySQL.INSTANCE);
        DTPDatabaseWrapper.putVendor(map, Oracle.INSTANCE);
        DTPDatabaseWrapper.putVendor(map, Postgres.INSTANCE);
        DTPDatabaseWrapper.putVendor(map, MaxDB.INSTANCE);
        DTPDatabaseWrapper.putVendor(map, Sybase.ASA);
        DTPDatabaseWrapper.putVendor(map, Sybase.ASE);
        return map;
    }

    private static void putVendor(HashMap<String, Vendor> map, Vendor vendor) {
        String name = vendor.getName();
        if (map.put(name, vendor) != null) {
            throw new IllegalArgumentException("Duplicate vendor: " + name);
        }
    }

    private static class DB2
    extends Vendor {
        static final Vendor UDB_I_SERIES = new DB2("DB2 UDB iSeries");
        static final Vendor UDB = new DB2("DB2 UDB");
        static final Vendor UDB_Z_SERIES = new DB2("DB2 UDB zSeries");
        private final String name;
        private static final char[] NORMAL_NAME_PART_CHARACTERS = new char[]{'_'};

        private DB2(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        boolean supportsCatalogs() {
            return false;
        }

        char[] getNormalNamePartCharacters() {
            return NORMAL_NAME_PART_CHARACTERS;
        }
    }

    private static class Default
    extends Vendor {
        static final Vendor INSTANCE = new Default();

        private Default() {
        }

        String getName() {
            return "Default Vendor";
        }

        boolean supportsCatalogs() {
            return true;
        }
    }

    private static class Derby
    extends Vendor {
        static final Vendor INSTANCE = new Derby();
        private static final String DEFAULT_USER_NAME = "APP";
        private static final char[] NORMAL_NAME_PART_CHARACTERS = new char[]{'_'};

        private Derby() {
        }

        String getName() {
            return "Derby";
        }

        boolean supportsCatalogs() {
            return false;
        }

        String getDefaultSchemaIdentifier(DTPSchemaContainerWrapper sc) {
            String user = super.getDefaultSchemaIdentifier(sc);
            return user == null || user.length() == 0 ? DEFAULT_USER_NAME : user;
        }

        char[] getNormalNamePartCharacters() {
            return NORMAL_NAME_PART_CHARACTERS;
        }
    }

    private static class HSQLDB
    extends Vendor {
        static final Vendor INSTANCE = new HSQLDB();
        private static final String PUBLIC_SCHEMA_NAME = "PUBLIC";

        private HSQLDB() {
        }

        String getName() {
            return "HSQLDB";
        }

        boolean supportsCatalogs() {
            return false;
        }

        String getDefaultSchemaIdentifier(DTPSchemaContainerWrapper sc) {
            return PUBLIC_SCHEMA_NAME;
        }
    }

    private static class Informix
    extends Vendor {
        static final Vendor INSTANCE = new Informix();
        private static final char[] NORMAL_NAME_START_CHARACTERS = new char[]{'_'};
        private static final char[] NORMAL_NAME_PART_CHARACTERS = new char[]{'$'};

        private Informix() {
        }

        String getName() {
            return "Informix";
        }

        boolean supportsCatalogs() {
            return false;
        }

        Vendor.Folder getFolder() {
            return Vendor.Folder.LOWER;
        }

        char[] getNormalNameStartCharacters() {
            return NORMAL_NAME_START_CHARACTERS;
        }

        char[] getNormalNamePartCharacters() {
            return NORMAL_NAME_PART_CHARACTERS;
        }
    }

    private static class MaxDB
    extends Vendor {
        static final Vendor INSTANCE = new MaxDB();
        private static final char[] NORMAL_NAME_START_CHARACTERS = new char[]{'#', '@', '$'};
        private static final char[] NORMAL_NAME_PART_CHARACTERS = new char[]{'_'};

        private MaxDB() {
        }

        String getName() {
            return "MaxDB";
        }

        boolean supportsCatalogs() {
            return false;
        }

        char[] getNormalNameStartCharacters() {
            return NORMAL_NAME_START_CHARACTERS;
        }

        char[] getNormalNamePartCharacters() {
            return NORMAL_NAME_PART_CHARACTERS;
        }
    }

    private static class MySQL
    extends Vendor {
        static final Vendor INSTANCE = new MySQL();
        private static final char[] NORMAL_NAME_START_CHARACTERS = new char[]{'_', '$'};
        private static final char BACKTICK = '`';

        private MySQL() {
        }

        String getName() {
            return "MySql";
        }

        boolean supportsCatalogs() {
            return false;
        }

        Vendor.Folder getFolder() {
            return Vendor.Folder.NONE;
        }

        String getDefaultSchemaIdentifier(DTPSchemaContainerWrapper sc) {
            return sc.getDatabase().getName();
        }

        boolean characterIsNormalNameStart(char c) {
            return Character.isDigit(c) || super.characterIsNormalNameStart(c);
        }

        char[] getNormalNameStartCharacters() {
            return NORMAL_NAME_START_CHARACTERS;
        }

        boolean identifierIsDelimited(String identifier) {
            return StringTools.stringIsDelimited((String)identifier, (char)'`') || super.identifierIsDelimited(identifier);
        }
    }

    private static class Oracle
    extends Vendor {
        static final Vendor INSTANCE = new Oracle();
        private static final char[] NORMAL_NAME_PART_CHARACTERS = new char[]{'_', '$', '#'};

        private Oracle() {
        }

        String getName() {
            return "Oracle";
        }

        boolean supportsCatalogs() {
            return false;
        }

        char[] getNormalNamePartCharacters() {
            return NORMAL_NAME_PART_CHARACTERS;
        }
    }

    private static class Postgres
    extends Vendor {
        static final Vendor INSTANCE = new Postgres();
        private static final String PUBLIC_SCHEMA_NAME = "public";
        private static final char[] NORMAL_NAME_START_CHARACTERS = new char[]{'_'};
        private static final char[] NORMAL_NAME_PART_CHARACTERS = new char[]{'$'};

        private Postgres() {
        }

        String getName() {
            return "postgres";
        }

        Vendor.Folder getFolder() {
            return Vendor.Folder.LOWER;
        }

        boolean supportsCatalogs() {
            return false;
        }

        DTPSchemaWrapper getDefaultSchema(DTPSchemaContainerWrapper sc) {
            DTPSchemaWrapper userSchema = super.getDefaultSchema(sc);
            return userSchema != null ? userSchema : sc.getSchemaNamed(PUBLIC_SCHEMA_NAME);
        }

        char[] getNormalNameStartCharacters() {
            return NORMAL_NAME_START_CHARACTERS;
        }

        char[] getNormalNamePartCharacters() {
            return NORMAL_NAME_PART_CHARACTERS;
        }
    }

    private static class SQLServer
    extends Vendor {
        static final Vendor INSTANCE = new SQLServer();
        private static final String DEFAULT_SCHEMA_NAME = "dbo";
        private static final char[] NORMAL_NAME_START_CHARACTERS = new char[]{'_', '@', '#'};
        private static final char[] NORMAL_NAME_PART_CHARACTERS = new char[]{'$'};

        private SQLServer() {
        }

        String getName() {
            return "SQL Server";
        }

        boolean supportsCatalogs() {
            return true;
        }

        String getDefaultSchemaIdentifier(DTPSchemaContainerWrapper sc) {
            return DEFAULT_SCHEMA_NAME;
        }

        Vendor.Folder getFolder() {
            return Vendor.Folder.NONE;
        }

        char[] getNormalNameStartCharacters() {
            return NORMAL_NAME_START_CHARACTERS;
        }

        char[] getNormalNamePartCharacters() {
            return NORMAL_NAME_PART_CHARACTERS;
        }

        boolean identifierIsDelimited(String identifier) {
            return StringTools.stringIsBracketed((String)identifier) || super.identifierIsDelimited(identifier);
        }
    }

    private static class Sybase
    extends Vendor {
        static final Vendor ASA = new Sybase("Sybase_ASA");
        static final Vendor ASE = new Sybase("Sybase_ASE");
        private final String name;
        private static final String DEFAULT_SCHEMA_NAME = "dbo";
        private static final char[] NORMAL_NAME_START_CHARACTERS = new char[]{'_', '@'};
        private static final char[] NORMAL_NAME_PART_CHARACTERS = new char[]{'$', '\u00a5', '\u00a3', '#'};

        private Sybase(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        boolean supportsCatalogs() {
            return true;
        }

        String getDefaultSchemaIdentifier(DTPSchemaContainerWrapper sc) {
            return DEFAULT_SCHEMA_NAME;
        }

        Vendor.Folder getFolder() {
            return Vendor.Folder.NONE;
        }

        char[] getNormalNameStartCharacters() {
            return NORMAL_NAME_START_CHARACTERS;
        }

        char[] getNormalNamePartCharacters() {
            return NORMAL_NAME_PART_CHARACTERS;
        }

        boolean identifierIsDelimited(String identifier) {
            return StringTools.stringIsBracketed((String)identifier) || super.identifierIsDelimited(identifier);
        }
    }

    private static abstract class Vendor {
        Vendor() {
        }

        abstract String getName();

        Folder getFolder() {
            return Folder.UPPER;
        }

        abstract boolean supportsCatalogs();

        DTPCatalogWrapper getDefaultCatalog(DTPDatabaseWrapper database) {
            if (!this.supportsCatalogs()) {
                throw new UnsupportedOperationException();
            }
            return database.getCatalogForIdentifier(this.getDefaultCatalogIdentifier(database));
        }

        String getDefaultCatalogIdentifier(DTPDatabaseWrapper database) {
            if (!this.supportsCatalogs()) {
                throw new UnsupportedOperationException();
            }
            return database.getConnectionProfile().getUserName();
        }

        DTPSchemaWrapper getDefaultSchema(DTPSchemaContainerWrapper sc) {
            return sc.getSchemaForIdentifier(this.getDefaultSchemaIdentifier(sc));
        }

        String getDefaultSchemaIdentifier(DTPSchemaContainerWrapper sc) {
            return sc.getDatabase().getConnectionProfile().getUserName();
        }

        final String convertNameToIdentifier(String name, String defaultName) {
            return this.nameRequiresDelimiters(name) ? this.delimitName(name) : (this.normalNamesMatch(name, defaultName) ? null : name);
        }

        final String convertNameToIdentifier(String name) {
            return this.nameRequiresDelimiters(name) ? this.delimitName(name) : name;
        }

        final boolean nameRequiresDelimiters(String name) {
            return name.length() == 0 || this.nameContainsAnySpecialCharacters(name) || this.nameIsNotFolded(name);
        }

        final boolean nameContainsAnySpecialCharacters(String name) {
            char[] string = name.toCharArray();
            if (this.characterIsSpecialNameStart(string[0])) {
                return true;
            }
            int i = string.length;
            while (i-- > 1) {
                if (!this.characterIsSpecialNamePart(string[i])) continue;
                return true;
            }
            return false;
        }

        final boolean characterIsSpecialNameStart(char c) {
            return !this.characterIsNormalNameStart(c);
        }

        boolean characterIsNormalNameStart(char c) {
            return Character.isLetter(c) || this.characterIsNormalNameStart_(c);
        }

        private boolean characterIsNormalNameStart_(char c) {
            return Vendor.arrayContains(this.getNormalNameStartCharacters(), c);
        }

        char[] getNormalNameStartCharacters() {
            return null;
        }

        final boolean characterIsSpecialNamePart(char c) {
            return !this.characterIsNormalNamePart(c);
        }

        boolean characterIsNormalNamePart(char c) {
            return Character.isLetterOrDigit(c) || this.characterIsNormalNameStart_(c) || this.characterIsNormalNamePart_(c);
        }

        private boolean characterIsNormalNamePart_(char c) {
            return Vendor.arrayContains(this.getNormalNamePartCharacters(), c);
        }

        char[] getNormalNamePartCharacters() {
            return null;
        }

        final boolean nameIsNotFolded(String name) {
            return !this.getFolder().stringIsFolded(name);
        }

        final boolean normalNamesMatch(String name1, String name2) {
            return this.normalIdentifiersAreCaseSensitive() ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
        }

        final boolean normalIdentifiersAreCaseSensitive() {
            return this.getFolder().isCaseSensitive();
        }

        String delimitName(String name) {
            return StringTools.quote((String)name);
        }

        final String convertIdentifierToName(String identifier) {
            return identifier == null ? null : (this.identifierIsDelimited(identifier) ? StringTools.undelimit((String)identifier) : this.getFolder().fold(identifier));
        }

        boolean identifierIsDelimited(String identifier) {
            return StringTools.stringIsQuoted((String)identifier);
        }

        public String toString() {
            return this.getName();
        }

        static boolean arrayContains(char[] array, char c) {
            return array != null && CollectionTools.contains((char[])array, (char)c);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Folder {
            UPPER{

                String fold(String string) {
                    return string.toUpperCase();
                }

                boolean stringIsFolded(String string) {
                    return StringTools.stringIsUppercase((String)string);
                }

                boolean isCaseSensitive() {
                    return false;
                }
            }
            ,
            LOWER{

                String fold(String string) {
                    return string.toLowerCase();
                }

                boolean stringIsFolded(String string) {
                    return StringTools.stringIsLowercase((String)string);
                }

                boolean isCaseSensitive() {
                    return false;
                }
            }
            ,
            NONE{

                String fold(String string) {
                    return string;
                }

                boolean stringIsFolded(String string) {
                    return true;
                }

                boolean isCaseSensitive() {
                    return true;
                }
            };


            abstract String fold(String var1);

            abstract boolean stringIsFolded(String var1);

            abstract boolean isCaseSensitive();
        }
    }
}

