/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkBasicMapping;
import org.eclipse.jpt.eclipselink.core.context.Mutable;
import org.eclipse.jpt.eclipselink.core.resource.java.ConvertAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.MutableAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.java.EclipseLinkJavaContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaBasicMappingTests
extends EclipseLinkJavaContextModelTestCase {
    private void createConvertAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "Convert", "String value() default \"none\";");
    }

    private void createMutableAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "Mutable", "boolean value() default true");
    }

    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        this.createConvertAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvert() throws Exception {
        this.createConvertAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"class-instance\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableBasic() throws Exception {
        this.createMutableAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Mutable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("@Mutable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableBasicDate() throws Exception {
        this.createMutableAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public EclipseLinkJavaBasicMappingTests(String name) {
        super(name);
    }

    public void testGetConvert() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJavaBasicMappingTests.assertEquals((String)"eclipseLinkConverter", (String)basicMapping.getConverter().getType());
    }

    public void testGetConvert2() throws Exception {
        this.createTestEntityWithConvert();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkJavaBasicMappingTests.assertEquals((String)"eclipseLinkConverter", (String)basicMapping.getConverter().getType());
        EclipseLinkJavaBasicMappingTests.assertEquals((String)"class-instance", (String)((Convert)basicMapping.getConverter()).getConverterName());
    }

    public void testSetConvert() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJavaBasicMappingTests.assertEquals((String)"noConverter", (String)basicMapping.getConverter().getType());
        basicMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)basicMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.Temporal");
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        basicMapping.setSpecifiedConverter(null);
        EclipseLinkJavaBasicMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testGetConvertUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJavaBasicMappingTests.assertEquals((String)"noConverter", (String)basicMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ConvertAnnotation convert = (ConvertAnnotation)attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        convert.setValue("foo");
        EclipseLinkJavaBasicMappingTests.assertEquals((String)"eclipseLinkConverter", (String)basicMapping.getConverter().getType());
        EclipseLinkJavaBasicMappingTests.assertEquals((String)"foo", (String)((Convert)basicMapping.getConverter()).getConverterName());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        EclipseLinkJavaBasicMappingTests.assertEquals((String)"noConverter", (String)basicMapping.getConverter().getType());
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        EclipseLinkJavaBasicMappingTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableBasic();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MutableAnnotation mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        mutableAnnotation.setValue(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(null);
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(Boolean.FALSE);
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutable.getSpecifiedMutable());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertEquals(null, (Object)mutable.getSpecifiedMutable());
        attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
    }

    public void testSetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableBasic();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MutableAnnotation mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(null);
        mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertEquals(null, (Object)mutableAnnotation);
        mutable.setSpecifiedMutable(Boolean.FALSE);
        mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
    }

    public void testIsDefaultMutable() throws Exception {
        this.createTestEntityWithMutableBasic();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.persistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
    }

    public void testIsDefaultMutableForDate() throws Exception {
        this.createTestEntityWithMutableBasicDate();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.persistenceUnit().getOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.persistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.persistenceUnit().getOptions().setTemporalMutable(null);
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
    }

    public void testIsMutable() throws Exception {
        this.createTestEntityWithMutableBasic();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isMutable());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isMutable());
    }
}

