/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.resource.java.ConvertAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.java.EclipseLinkJavaContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaConvertTests
extends EclipseLinkJavaContextModelTestCase {
    private void createConvertAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "Convert", "String value() default \"none\";");
    }

    private void createTypeConverterAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "TypeConverter", "String name(); Class dataType() default void.class; Class objectType default void.class;");
    }

    private void createStructConverterAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "StructConverter", "String name(); String converter();");
    }

    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        this.createConvertAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvert() throws Exception {
        this.createConvertAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"class-instance\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndTypeConverter() throws Exception {
        this.createConvertAnnotation();
        this.createTypeConverterAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"class-instance\")").append(CR);
                sb.append("    @TypeConverter");
            }
        });
    }

    public EclipseLinkJavaConvertTests(String name) {
        super(name);
    }

    public void testGetConverterName() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        EclipseLinkJavaConvertTests.assertEquals((String)"none", (String)eclipseLinkConvert.getConverterName());
        EclipseLinkJavaConvertTests.assertEquals((String)"none", (String)eclipseLinkConvert.getDefaultConverterName());
        EclipseLinkJavaConvertTests.assertEquals(null, (String)eclipseLinkConvert.getSpecifiedConverterName());
    }

    public void testGetConvertName2() throws Exception {
        this.createTestEntityWithConvert();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        EclipseLinkJavaConvertTests.assertEquals((String)"class-instance", (String)eclipseLinkConvert.getConverterName());
    }

    public void testSetSpecifiedConverterName() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        basicMapping.setSpecifiedConverter("eclipseLinkConverter");
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        EclipseLinkJavaConvertTests.assertEquals(null, (String)eclipseLinkConvert.getSpecifiedConverterName());
        eclipseLinkConvert.setSpecifiedConverterName("foo");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ConvertAnnotation convertAnnotation = (ConvertAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        EclipseLinkJavaConvertTests.assertEquals((String)"foo", (String)convertAnnotation.getValue());
        eclipseLinkConvert.setSpecifiedConverterName(null);
        convertAnnotation = (ConvertAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        EclipseLinkJavaConvertTests.assertNotNull((Object)convertAnnotation);
        EclipseLinkJavaConvertTests.assertEquals(null, (String)convertAnnotation.getValue());
    }

    public void testGetConverterNameUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJavaConvertTests.assertEquals((String)"noConverter", (String)basicMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ConvertAnnotation convert = (ConvertAnnotation)attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        convert.setValue("foo");
        EclipseLinkJavaConvertTests.assertEquals((String)"eclipseLinkConverter", (String)basicMapping.getConverter().getType());
        EclipseLinkJavaConvertTests.assertEquals((String)"foo", (String)((Convert)basicMapping.getConverter()).getConverterName());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        EclipseLinkJavaConvertTests.assertEquals((String)"noConverter", (String)basicMapping.getConverter().getType());
        EclipseLinkJavaConvertTests.assertFalse((boolean)basicMapping.isDefault());
        EclipseLinkJavaConvertTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetConverter() throws Exception {
        this.createTestEntityWithConvertAndTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        EclipseLinkJavaConvertTests.assertEquals((String)"typeConverter", (String)eclipseLinkConvert.getConverter().getType());
    }

    public void testSetConverter() throws Exception {
        this.createTestEntityWithConvert();
        this.createStructConverterAnnotation();
        this.createTypeConverterAnnotation();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        EclipseLinkJavaConvertTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        eclipseLinkConvert.setConverter("typeConverter");
        EclipseLinkJavaConvertTests.assertEquals((String)"typeConverter", (String)eclipseLinkConvert.getConverter().getType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaConvertTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter"));
        eclipseLinkConvert.setConverter("structConverter");
        EclipseLinkJavaConvertTests.assertEquals((String)"structConverter", (String)eclipseLinkConvert.getConverter().getType());
        EclipseLinkJavaConvertTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter"));
        EclipseLinkJavaConvertTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter"));
        eclipseLinkConvert.setConverter("noConverter");
        EclipseLinkJavaConvertTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        EclipseLinkJavaConvertTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter"));
        EclipseLinkJavaConvertTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.TypeConverter"));
        eclipseLinkConvert.setConverter("structConverter");
        EclipseLinkJavaConvertTests.assertEquals((String)"structConverter", (String)eclipseLinkConvert.getConverter().getType());
        EclipseLinkJavaConvertTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter"));
        basicMapping.setSpecifiedConverter(null);
        EclipseLinkJavaConvertTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter"));
        EclipseLinkJavaConvertTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Convert"));
    }
}

