/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.eclipselink.core.context.JoinFetch;
import org.eclipse.jpt.eclipselink.core.context.JoinFetchType;
import org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.java.EclipseLinkJavaContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaManyToManyMappingTests
extends EclipseLinkJavaContextModelTestCase {
    private void createJoinFetchAnnotation() throws Exception {
        this.createJoinFetchTypeEnum();
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "JoinFetch", "JoinFetchType value() default JoinFetchType.INNER");
    }

    private void createJoinFetchTypeEnum() throws Exception {
        this.createEnumAndMembers("org.eclipse.persistence.annotations", "JoinFetchType", "INNER, OUTER;");
    }

    private ICompilationUnit createTestEntityWithJoinFetchManyToMany() throws Exception {
        this.createJoinFetchAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "org.eclipse.persistence.annotations.JoinFetch"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
                sb.append("@JoinFetch").append(CR);
            }
        });
    }

    public EclipseLinkJavaManyToManyMappingTests(String name) {
        super(name);
    }

    public void testGetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getSpecifiedMapping();
        JoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinFetchAnnotation joinFetchAnnotation = (JoinFetchAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaManyToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaManyToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchType.INNER);
        EclipseLinkJavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaManyToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchType.OUTER);
        EclipseLinkJavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaManyToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(null);
        EclipseLinkJavaManyToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaManyToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaManyToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaManyToManyMappingTests.assertNull((Object)contextJoinFetch.getValue());
    }

    public void testSetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getSpecifiedMapping();
        JoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinFetchAnnotation joinFetchAnnotation = (JoinFetchAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaManyToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaManyToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(JoinFetchType.INNER);
        EclipseLinkJavaManyToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaManyToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(JoinFetchType.OUTER);
        EclipseLinkJavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaManyToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(null);
        EclipseLinkJavaManyToManyMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch"));
        EclipseLinkJavaManyToManyMappingTests.assertNull((Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(JoinFetchType.INNER);
        joinFetchAnnotation = (JoinFetchAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaManyToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
    }
}

