/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.ChangeTracking;
import org.eclipse.jpt.eclipselink.core.context.Customizer;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkMappedSuperclass;
import org.eclipse.jpt.eclipselink.core.context.ReadOnly;
import org.eclipse.jpt.eclipselink.core.resource.java.ChangeTrackingAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ChangeTrackingType;
import org.eclipse.jpt.eclipselink.core.resource.java.CustomizerAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.java.EclipseLinkJavaContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaMappedSuperclassTests
extends EclipseLinkJavaContextModelTestCase {
    private void createReadOnlyAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "ReadOnly", "");
    }

    private void createCustomizerAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "Customizer", "Class value();");
    }

    private void createChangeTrackingAnnotation() throws Exception {
        this.createChangeTrackingTypeEnum();
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "ChangeTracking", "ChangeTrackingType value() default ChangeTrackingType.AUTO");
    }

    private void createChangeTrackingTypeEnum() throws Exception {
        this.createEnumAndMembers("org.eclipse.persistence.annotations", "ChangeTrackingType", "ATTRIBUTE, OBJECT, DEFERRED, AUTO;");
    }

    private ICompilationUnit createTestMappedSuperclassWithReadOnly() throws Exception {
        this.createReadOnlyAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "org.eclipse.persistence.annotations.ReadOnly"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("@ReadOnly").append(CR);
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassWithConvertAndCustomizerClass() throws Exception {
        this.createCustomizerAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "org.eclipse.persistence.annotations.Customizer"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("    @Customizer(Foo.class");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassWithChangeTracking() throws Exception {
        this.createChangeTrackingAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "org.eclipse.persistence.annotations.ChangeTracking"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("    @ChangeTracking").append(CR);
            }
        });
    }

    public EclipseLinkJavaMappedSuperclassTests(String name) {
        super(name);
    }

    public void testGetReadOnly() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.javaPersistentType().getMapping();
        ReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)readOnly.isReadOnly());
    }

    public void testGetSpecifiedReadOnly() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.javaPersistentType().getMapping();
        ReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
    }

    public void testGetDefaultReadOnly() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.javaPersistentType().getMapping();
        ReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)readOnly.isDefaultReadOnly());
    }

    public void testSetSpecifiedReadOnly() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.javaPersistentType().getMapping();
        ReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)readOnly.isReadOnly());
        readOnly.setSpecifiedReadOnly(Boolean.FALSE);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLinkJavaMappedSuperclassTests.assertEquals(null, (Object)readOnly.getSpecifiedReadOnly());
        readOnly.setSpecifiedReadOnly(Boolean.TRUE);
        EclipseLinkJavaMappedSuperclassTests.assertNotNull((Object)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
        readOnly.setSpecifiedReadOnly(null);
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLinkJavaMappedSuperclassTests.assertEquals(null, (Object)readOnly.getSpecifiedReadOnly());
    }

    public void testSpecifiedReadOnlyUpdatesFromResourceModelChange() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.javaPersistentType().getMapping();
        ReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        typeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.ReadOnly");
        EclipseLinkJavaMappedSuperclassTests.assertEquals(null, (Object)readOnly.getSpecifiedReadOnly());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)readOnly.isDefaultReadOnly());
        typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.ReadOnly");
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
    }

    public void testGetCustomizerClass() throws Exception {
        this.createTestMappedSuperclassWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        Customizer customizer = ((EclipseLinkMappedSuperclass)this.javaPersistentType().getMapping()).getCustomizer();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testSetCustomizerClass() throws Exception {
        this.createTestMappedSuperclassWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        Customizer customizer = ((EclipseLinkMappedSuperclass)this.javaPersistentType().getMapping()).getCustomizer();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CustomizerAnnotation customizerAnnotation = (CustomizerAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
        customizer.setSpecifiedCustomizerClass(null);
        EclipseLinkJavaMappedSuperclassTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaMappedSuperclassTests.assertEquals(null, (Object)customizerAnnotation);
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
    }

    public void testGetCustomizerClassUpdatesFromResourceModelChange() throws Exception {
        this.createTestMappedSuperclassWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.javaPersistentType().getMapping();
        Customizer customizer = mappedSuperclass.getCustomizer();
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        CustomizerAnnotation customizerAnnotation = (CustomizerAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        customizerAnnotation.setValue("Bar");
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        typeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaMappedSuperclassTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)typeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaMappedSuperclassTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation.setValue("FooBar");
        EclipseLinkJavaMappedSuperclassTests.assertEquals((String)"FooBar", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testGetChangeTracking() throws Exception {
        this.createTestMappedSuperclassWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.javaPersistentType().getMapping();
        ChangeTracking contextChangeTracking = mappedSuperclass.getChangeTracking();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ChangeTrackingAnnotation resourceChangeTracking = (ChangeTrackingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.ATTRIBUTE);
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.OBJECT);
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.OBJECT, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.DEFERRED);
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.AUTO);
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(null);
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        typeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
    }

    public void testSetChangeTracking() throws Exception {
        this.createTestMappedSuperclassWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.javaPersistentType().getMapping();
        ChangeTracking contextChangeTracking = mappedSuperclass.getChangeTracking();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        ChangeTrackingAnnotation resourceChangeTracking = (ChangeTrackingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO);
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.ATTRIBUTE);
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.OBJECT);
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.DEFERRED);
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(null);
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking"));
        EclipseLinkJavaMappedSuperclassTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO);
        resourceChangeTracking = (ChangeTrackingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaMappedSuperclassTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.ChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
    }
}

