/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.ConversionValue;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.java.ConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ObjectTypeConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.java.EclipseLinkJavaContextModelTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaObjectTypeConverterTests
extends EclipseLinkJavaContextModelTestCase {
    private void createConvertAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "Convert", "String value() default \"none\";");
    }

    private void createObjectTypeConverterAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "ObjectTypeConverter", "String name(); Class dataType() default void.class;  Class objectType() default void.class;");
    }

    private void createConversionValueAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "ConversionValue", "String dataValue(); String objectValue();");
    }

    private ICompilationUnit createTestEntityWithConvertAndObjectTypeConverter() throws Exception {
        this.createConvertAnnotation();
        this.createObjectTypeConverterAnnotation();
        this.createConversionValueAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.ObjectTypeConverter", "org.eclipse.persistence.annotations.ConversionValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @ObjectTypeConverter(name=\"foo\", defaultObjectValue=\"bar\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndDataType() throws Exception {
        this.createConvertAnnotation();
        this.createObjectTypeConverterAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.ObjectTypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @ObjectTypeConverter(dataType=Foo.class)");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndObjectType() throws Exception {
        this.createConvertAnnotation();
        this.createObjectTypeConverterAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.ObjectTypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @ObjectTypeConverter(objectType=Foo.class)");
            }
        });
    }

    public EclipseLinkJavaObjectTypeConverterTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"foo", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"foo", (String)converter.getName());
        converter.setName("bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
        converter.setName(null);
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converter.getName());
        converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converterAnnotation.getName());
        converter.setName("bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getName());
        converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
    }

    public void testGetNameUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"foo", (String)converter.getName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        converterAnnotation.setName("bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getName());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setName("FOO");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"FOO", (String)eclipseLinkConvert.getConverter().getName());
    }

    public void testGetDataType() throws Exception {
        this.createTestEntityWithConvertAndDataType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Foo", (String)converter.getDataType());
    }

    public void testSetDataType() throws Exception {
        this.createTestEntityWithConvertAndDataType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Foo", (String)converter.getDataType());
        converter.setDataType("Bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converter.getDataType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getDataType());
        converter.setDataType(null);
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converter.getDataType());
        converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converterAnnotation.getDataType());
        converter.setDataType("Bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converter.getDataType());
        converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getDataType());
    }

    public void testGetDataTypeUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndDataType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Foo", (String)converter.getDataType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        converterAnnotation.setDataType("Bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converter.getDataType());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setDataType("FooBar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"FooBar", (String)((ObjectTypeConverter)eclipseLinkConvert.getConverter()).getDataType());
    }

    public void testGetObjectType() throws Exception {
        this.createTestEntityWithConvertAndObjectType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Foo", (String)converter.getObjectType());
    }

    public void testSetObjectType() throws Exception {
        this.createTestEntityWithConvertAndObjectType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Foo", (String)converter.getObjectType());
        converter.setObjectType("Bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getObjectType());
        converter.setObjectType(null);
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converter.getObjectType());
        converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converterAnnotation.getObjectType());
        converter.setObjectType("Bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getObjectType());
    }

    public void testGetObjectTypeUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndObjectType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Foo", (String)converter.getObjectType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        converterAnnotation.setObjectType("Bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setObjectType("FooBar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"FooBar", (String)((ObjectTypeConverter)eclipseLinkConvert.getConverter()).getObjectType());
    }

    public void testAddConversionValue() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        ConversionValue conversionValue = converter.addConversionValue(0);
        conversionValue.setDataValue("F");
        conversionValue.setObjectValue("female");
        ListIterator resourceConversionValues = converterAnnotation.conversionValues();
        ConversionValueAnnotation resourceConversionValue = (ConversionValueAnnotation)resourceConversionValues.next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)resourceConversionValue.getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"female", (String)resourceConversionValue.getObjectValue());
        ConversionValue conversionValue2 = converter.addConversionValue(0);
        conversionValue2.setDataValue("M");
        conversionValue2.setObjectValue("male");
        resourceConversionValues = converterAnnotation.conversionValues();
        resourceConversionValue = (ConversionValueAnnotation)resourceConversionValues.next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)resourceConversionValue.getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"male", (String)resourceConversionValue.getObjectValue());
        resourceConversionValue = (ConversionValueAnnotation)resourceConversionValues.next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)resourceConversionValue.getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"female", (String)resourceConversionValue.getObjectValue());
        ConversionValue conversionValue3 = converter.addConversionValue(1);
        conversionValue3.setDataValue("O");
        conversionValue3.setObjectValue("male");
        resourceConversionValues = converterAnnotation.conversionValues();
        resourceConversionValue = (ConversionValueAnnotation)resourceConversionValues.next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)resourceConversionValue.getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"male", (String)resourceConversionValue.getObjectValue());
        resourceConversionValue = (ConversionValueAnnotation)resourceConversionValues.next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)resourceConversionValue.getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"male", (String)resourceConversionValue.getObjectValue());
        resourceConversionValue = (ConversionValueAnnotation)resourceConversionValues.next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)resourceConversionValue.getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"female", (String)resourceConversionValue.getObjectValue());
        ListIterator conversionValues = converter.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((Object)conversionValue2, conversionValues.next());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((Object)conversionValue3, conversionValues.next());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((Object)conversionValue, conversionValues.next());
        conversionValues = converter.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((ConversionValue)conversionValues.next()).getDataValue());
    }

    public void testRemoveConversionValue() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        converter.addConversionValue(0).setDataValue("F");
        converter.addConversionValue(1).setDataValue("M");
        converter.addConversionValue(2).setDataValue("O");
        ListIterator resourceConversionValues = converterAnnotation.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)resourceConversionValues));
        converter.removeConversionValue(0);
        resourceConversionValues = converterAnnotation.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)resourceConversionValues));
        resourceConversionValues = converterAnnotation.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        converter.removeConversionValue(0);
        resourceConversionValues = converterAnnotation.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)resourceConversionValues));
        resourceConversionValues = converterAnnotation.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        converter.removeConversionValue(0);
        resourceConversionValues = converterAnnotation.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)resourceConversionValues));
    }

    public void testMoveConversionValue() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        converter.addConversionValue(0).setDataValue("F");
        converter.addConversionValue(1).setDataValue("M");
        converter.addConversionValue(2).setDataValue("O");
        ListIterator resourceConversionValues = converterAnnotation.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)resourceConversionValues));
        converter.moveConversionValue(2, 0);
        resourceConversionValues = converterAnnotation.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)resourceConversionValues));
        resourceConversionValues = converterAnnotation.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        converter.moveConversionValue(0, 1);
        resourceConversionValues = converterAnnotation.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)resourceConversionValues));
        resourceConversionValues = converterAnnotation.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
    }

    public void testUpdateConversionValues() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        converterAnnotation.addConversionValue(0).setDataValue("F");
        converterAnnotation.addConversionValue(1).setDataValue("M");
        converterAnnotation.addConversionValue(2).setDataValue("O");
        ListIterator conversionValues = converter.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)conversionValues.hasNext());
        converterAnnotation.moveConversionValue(2, 0);
        conversionValues = converter.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)conversionValues.hasNext());
        converterAnnotation.moveConversionValue(0, 1);
        conversionValues = converter.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)conversionValues.hasNext());
        converterAnnotation.removeConversionValue(1);
        conversionValues = converter.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)conversionValues.hasNext());
        converterAnnotation.removeConversionValue(1);
        conversionValues = converter.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)conversionValues.hasNext());
        converterAnnotation.removeConversionValue(0);
        conversionValues = converter.conversionValues();
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)conversionValues.hasNext());
    }

    public void testConversionValuesSize() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)0, (int)converter.conversionValuesSize());
        converterAnnotation.addConversionValue(0).setDataValue("F");
        converterAnnotation.addConversionValue(1).setDataValue("M");
        converterAnnotation.addConversionValue(2).setDataValue("O");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)3, (int)converter.conversionValuesSize());
    }

    public void testGetDefaultObjectValue() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getDefaultObjectValue());
    }

    public void testSetDefaultObjectValue() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getDefaultObjectValue());
        converter.setDefaultObjectValue("baz");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"baz", (String)converter.getDefaultObjectValue());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"baz", (String)converterAnnotation.getDefaultObjectValue());
        converter.setDefaultObjectValue(null);
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converter.getDefaultObjectValue());
        converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converterAnnotation.getDefaultObjectValue());
        converter.setDefaultObjectValue("bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getDefaultObjectValue());
        converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getDefaultObjectValue());
    }

    public void testGetDefaultObjectValueUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        Convert eclipseLinkConvert = (Convert)basicMapping.getConverter();
        ObjectTypeConverter converter = (ObjectTypeConverter)eclipseLinkConvert.getConverter();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getDefaultObjectValue());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        converterAnnotation.setDefaultObjectValue("baz");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"baz", (String)converter.getDefaultObjectValue());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (Object)eclipseLinkConvert.getConverter());
        converterAnnotation = (ObjectTypeConverterAnnotation)attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertNotNull((Object)eclipseLinkConvert.getConverter());
        converterAnnotation.setDefaultObjectValue("FOO");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"FOO", (String)((ObjectTypeConverter)eclipseLinkConvert.getConverter()).getDefaultObjectValue());
    }
}

