/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkOneToOneMapping;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.eclipselink.core.context.JoinFetch;
import org.eclipse.jpt.eclipselink.core.context.PrivateOwned;
import org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.JoinFetchType;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.java.EclipseLinkJavaContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaOneToOneMappingTests
extends EclipseLinkJavaContextModelTestCase {
    private void createPrivateOwnedAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "PrivateOwned", "");
    }

    private void createJoinFetchAnnotation() throws Exception {
        this.createJoinFetchTypeEnum();
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "JoinFetch", "JoinFetchType value() default JoinFetchType.INNER");
    }

    private void createJoinFetchTypeEnum() throws Exception {
        this.createEnumAndMembers("org.eclipse.persistence.annotations", "JoinFetchType", "INNER, OUTER;");
    }

    private ICompilationUnit createTestEntityWithPrivateOwnedOneToOne() throws Exception {
        this.createPrivateOwnedAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "org.eclipse.persistence.annotations.PrivateOwned"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
                sb.append("@PrivateOwned").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithJoinFetchOneToOne() throws Exception {
        this.createJoinFetchAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "org.eclipse.persistence.annotations.JoinFetch"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
                sb.append("@JoinFetch").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithDefaultOneToOne() throws Exception {
        this.createJoinFetchAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private AnnotationTestType myType;").append(CR);
                sb.append(CR);
            }
        });
    }

    public EclipseLinkJavaOneToOneMappingTests(String name) {
        super(name);
    }

    public void testGetPrivateOwned() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getSpecifiedMapping();
        PrivateOwned privateOwnable = oneToOneMapping.getPrivateOwned();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testSetPrivateOwned() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getSpecifiedMapping();
        PrivateOwned privateOwnable = oneToOneMapping.getPrivateOwned();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
        privateOwnable.setPrivateOwned(false);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.PrivateOwned"));
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)false, (boolean)privateOwnable.isPrivateOwned());
        privateOwnable.setPrivateOwned(true);
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.PrivateOwned"));
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testPrivateOwnedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithPrivateOwnedOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getSpecifiedMapping();
        PrivateOwned privateOwnable = oneToOneMapping.getPrivateOwned();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.PrivateOwned");
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)false, (boolean)privateOwnable.isPrivateOwned());
        attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.PrivateOwned");
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)privateOwnable.isPrivateOwned());
    }

    public void testGetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getSpecifiedMapping();
        JoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinFetchAnnotation joinFetchAnnotation = (JoinFetchAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.INNER);
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.OUTER);
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(null);
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)contextJoinFetch.getValue());
    }

    public void testSetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getSpecifiedMapping();
        JoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinFetchAnnotation joinFetchAnnotation = (JoinFetchAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER);
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(org.eclipse.jpt.eclipselink.core.context.JoinFetchType.OUTER);
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(null);
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch"));
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER);
        joinFetchAnnotation = (JoinFetchAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.eclipselink.core.context.JoinFetchType.INNER, (Object)contextJoinFetch.getValue());
    }

    public void testDefaultOneToOne() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.javaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"basic", (String)((JavaPersistentAttribute)attributes.next()).getDefaultMappingKey());
    }

    public void testDefaultOneToOneSetFetch() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.javaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.LAZY);
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)specifiedOneToOneMapping.getFetch());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToOneAnnotation));
        EclipseLinkJavaOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)((OneToOneAnnotation)attributeResource.getMappingAnnotation()).getFetch());
    }

    public void testDefaultOneToOneSetTargetEntity() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.javaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.setSpecifiedTargetEntity("Foo");
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"Foo", (String)specifiedOneToOneMapping.getSpecifiedTargetEntity());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToOneAnnotation));
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"Foo", (String)((OneToOneAnnotation)attributeResource.getMappingAnnotation()).getTargetEntity());
    }

    public void testDefaultOneToOneSetMappedBy() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.javaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.setMappedBy("Foo");
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"Foo", (String)specifiedOneToOneMapping.getMappedBy());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToOneAnnotation));
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"Foo", (String)((OneToOneAnnotation)attributeResource.getMappingAnnotation()).getMappedBy());
    }

    public void testDefaultOneToOneSetCascadeAll() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.javaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.getCascade().setAll(true);
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToOneMapping.getCascade().isAll());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToOneAnnotation));
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)((OneToOneAnnotation)attributeResource.getMappingAnnotation()).isCascadeAll());
    }

    public void testDefaultOneToOneSetCascadeMerge() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.javaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.getCascade().setMerge(true);
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToOneMapping.getCascade().isMerge());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToOneAnnotation));
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)((OneToOneAnnotation)attributeResource.getMappingAnnotation()).isCascadeMerge());
    }

    public void testDefaultOneToOneSetCascadePersist() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.javaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.getCascade().setPersist(true);
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToOneMapping.getCascade().isPersist());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToOneAnnotation));
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)((OneToOneAnnotation)attributeResource.getMappingAnnotation()).isCascadePersist());
    }

    public void testDefaultOneToOneSetCascadeRefresh() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.javaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.getCascade().setRefresh(true);
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToOneMapping.getCascade().isRefresh());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToOneAnnotation));
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)((OneToOneAnnotation)attributeResource.getMappingAnnotation()).isCascadeRefresh());
    }

    public void testDefaultOneToOneSetCascadeRemove() throws Exception {
        this.createTestEntityWithDefaultOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.javaPersistentType().attributes();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)attributes.next();
        EclipseLinkJavaOneToOneMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        EclipseLinkJavaOneToOneMappingTests.assertEquals((String)"oneToOne", (String)persistentAttribute.getDefaultMappingKey());
        EclipseLinkOneToOneMapping oneToOneMapping = (EclipseLinkOneToOneMapping)persistentAttribute.getMapping();
        oneToOneMapping.getCascade().setRemove(true);
        EclipseLinkOneToOneMapping specifiedOneToOneMapping = (EclipseLinkOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getSpecifiedMapping();
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)specifiedOneToOneMapping.getCascade().isRemove());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkJavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation());
        EclipseLinkJavaOneToOneMappingTests.assertTrue((boolean)(attributeResource.getMappingAnnotation() instanceof OneToOneAnnotation));
        EclipseLinkJavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)((OneToOneAnnotation)attributeResource.getMappingAnnotation()).isCascadeRemove());
    }
}

