/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkVersionMapping;
import org.eclipse.jpt.eclipselink.core.context.Mutable;
import org.eclipse.jpt.eclipselink.core.resource.java.ConvertAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.MutableAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.java.EclipseLinkJavaContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkJavaVersionMappingTests
extends EclipseLinkJavaContextModelTestCase {
    private void createConvertAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "Convert", "String value() default \"none\";");
    }

    private void createMutableAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "Mutable", "boolean value() default true");
    }

    private ICompilationUnit createTestEntityWithVersionMapping() throws Exception {
        this.createConvertAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvert() throws Exception {
        this.createConvertAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "org.eclipse.persistence.annotations.Convert"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("@Convert(\"class-instance\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableVersion() throws Exception {
        this.createMutableAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "org.eclipse.persistence.annotations.Mutable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("@Mutable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableVersionDate() throws Exception {
        this.createMutableAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "org.eclipse.persistence.annotations.Mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public EclipseLinkJavaVersionMappingTests(String name) {
        super(name);
    }

    public void testGetConvert() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"eclipseLinkConverter", (String)versionMapping.getConverter().getType());
    }

    public void testGetConvert2() throws Exception {
        this.createTestEntityWithConvert();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getMapping();
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"eclipseLinkConverter", (String)versionMapping.getConverter().getType());
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"class-instance", (String)((Convert)versionMapping.getConverter()).getConverterName());
    }

    public void testSetConvert() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"noConverter", (String)versionMapping.getConverter().getType());
        versionMapping.setSpecifiedConverter("temporalConverter");
        ((TemporalConverter)versionMapping.getSpecifiedConverter()).setTemporalType(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.Temporal");
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        versionMapping.setSpecifiedConverter(null);
        EclipseLinkJavaVersionMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Temporal"));
    }

    public void testGetConvertUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithVersionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        VersionMapping versionMapping = (VersionMapping)persistentAttribute.getSpecifiedMapping();
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"noConverter", (String)versionMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ConvertAnnotation convert = (ConvertAnnotation)attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        convert.setValue("foo");
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"eclipseLinkConverter", (String)versionMapping.getConverter().getType());
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"foo", (String)((Convert)versionMapping.getConverter()).getConverterName());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Convert");
        EclipseLinkJavaVersionMappingTests.assertEquals((String)"noConverter", (String)versionMapping.getConverter().getType());
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        EclipseLinkJavaVersionMappingTests.assertSame((Object)versionMapping, (Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableVersion();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MutableAnnotation mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        mutableAnnotation.setValue(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(null);
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(Boolean.FALSE);
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutable.getSpecifiedMutable());
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutable.getSpecifiedMutable());
        attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
    }

    public void testSetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableVersion();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MutableAnnotation mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(null);
        mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutableAnnotation);
        mutable.setSpecifiedMutable(Boolean.FALSE);
        mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
    }

    public void testIsDefaultMutable() throws Exception {
        this.createTestEntityWithMutableVersion();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.persistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
    }

    public void testIsDefaultMutableForDate() throws Exception {
        this.createTestEntityWithMutableVersionDate();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.persistenceUnit().getOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.persistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.persistenceUnit().getOptions().setTemporalMutable(null);
        EclipseLinkJavaVersionMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
    }

    public void testIsMutable() throws Exception {
        this.createTestEntityWithMutableVersion();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        EclipseLinkVersionMapping versionMapping = (EclipseLinkVersionMapping)persistentAttribute.getSpecifiedMapping();
        Mutable mutable = versionMapping.getMutable();
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isMutable());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaVersionMappingTests.assertTrue((boolean)mutable.isMutable());
    }
}

