/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.eclipselink.core.context.JoinFetchType;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlJoinFetchType;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;

public class EclipseLinkOrmManyToOneMappingTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmManyToOneMappingTests(String name) {
        super(name);
    }

    public void testUpdateJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "manyToOne");
        EclipseLinkRelationshipMapping contextManyToOne = (EclipseLinkRelationshipMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
        resourceManyToOne.setJoinFetch(XmlJoinFetchType.INNER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextManyToOne.getJoinFetch().getValue());
        resourceManyToOne.setJoinFetch(XmlJoinFetchType.OUTER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)contextManyToOne.getJoinFetch().getValue());
        resourceManyToOne.setJoinFetch(null);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
    }

    public void testModifyJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "manyToOne");
        EclipseLinkRelationshipMapping contextManyToOne = (EclipseLinkRelationshipMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
        contextManyToOne.getJoinFetch().setValue(JoinFetchType.INNER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextManyToOne.getJoinFetch().getValue());
        contextManyToOne.getJoinFetch().setValue(JoinFetchType.OUTER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)contextManyToOne.getJoinFetch().getValue());
        contextManyToOne.getJoinFetch().setValue(null);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
    }
}

