/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkOneToOneMapping;
import org.eclipse.jpt.eclipselink.core.context.JoinFetchType;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlJoinFetchType;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;

public class EclipseLinkOrmOneToOneMappingTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmOneToOneMappingTests(String name) {
        super(name);
    }

    public void testUpdatePrivateOwned() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        EclipseLinkOneToOneMapping contextOneToOne = (EclipseLinkOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
        resourceOneToOne.setPrivateOwned(true);
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
        resourceOneToOne.setPrivateOwned(false);
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
    }

    public void testModifyPrivateOwned() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        EclipseLinkOneToOneMapping contextOneToOne = (EclipseLinkOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
        contextOneToOne.getPrivateOwned().setPrivateOwned(true);
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
        contextOneToOne.getPrivateOwned().setPrivateOwned(false);
    }

    public void testUpdateJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        EclipseLinkOneToOneMapping contextOneToOne = (EclipseLinkOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)contextOneToOne.getJoinFetch().getValue());
        resourceOneToOne.setJoinFetch(XmlJoinFetchType.INNER);
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextOneToOne.getJoinFetch().getValue());
        resourceOneToOne.setJoinFetch(XmlJoinFetchType.OUTER);
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)contextOneToOne.getJoinFetch().getValue());
        resourceOneToOne.setJoinFetch(null);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)contextOneToOne.getJoinFetch().getValue());
    }

    public void testModifyJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOne");
        EclipseLinkOneToOneMapping contextOneToOne = (EclipseLinkOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)contextOneToOne.getJoinFetch().getValue());
        contextOneToOne.getJoinFetch().setValue(JoinFetchType.INNER);
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextOneToOne.getJoinFetch().getValue());
        contextOneToOne.getJoinFetch().setValue(JoinFetchType.OUTER);
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)contextOneToOne.getJoinFetch().getValue());
        contextOneToOne.getJoinFetch().setValue(null);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)contextOneToOne.getJoinFetch().getValue());
    }
}

