/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.context.TypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlTypeConverter;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkOrmTypeConverterTests
extends EclipseLinkOrmContextModelTestCase {
    private void createConvertAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "Convert", "String value() default \"none\";");
    }

    private void createTypeConverterAnnotation() throws Exception {
        this.createAnnotationAndMembers("org.eclipse.persistence.annotations", "TypeConverter", "String name(); String converterClass();");
    }

    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        this.createConvertAnnotation();
        this.createTypeConverterAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Convert(name=\"foo\")").append(CR);
                sb.append("    @TypeConverter");
            }
        });
    }

    public EclipseLinkOrmTypeConverterTests(String name) {
        super(name);
    }

    public void testUpdateDataType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("typeConverter");
        TypeConverter ormConverter = (TypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
        converterResource.setDataType("myConvert");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getDataType());
        converterResource.setDataType(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormConverter = (TypeConverter)((Convert)ormBasicMapping.getSpecifiedConverter()).getConverter();
        TypeConverter javaConverter = (TypeConverter)((Convert)javaBasicMapping.getSpecifiedConverter()).getConverter();
        javaConverter.setDataType("bar");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getDataType());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getDataType());
    }

    public void testModifyDataType() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("typeConverter");
        TypeConverter ormConverter = (TypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverter();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
        ormConverter.setDataType("foo");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getDataType());
        ormConverter.setDataType(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
    }

    public void testUpdateObjectType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("typeConverter");
        TypeConverter ormConverter = (TypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
        converterResource.setObjectType("myConvert");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getObjectType());
        converterResource.setObjectType(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormConverter = (TypeConverter)((Convert)ormBasicMapping.getSpecifiedConverter()).getConverter();
        TypeConverter javaConverter = (TypeConverter)((Convert)javaBasicMapping.getSpecifiedConverter()).getConverter();
        javaConverter.setObjectType("bar");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getObjectType());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getObjectType());
    }

    public void testModifyObjectType() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("typeConverter");
        TypeConverter ormConverter = (TypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverter();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
        ormConverter.setObjectType("foo");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getObjectType());
        ormConverter.setObjectType(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("typeConverter");
        EclipseLinkOrmTypeConverter ormConverter = (EclipseLinkOrmTypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getName());
        converterResource.setName("myConvert");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getName());
        converterResource.setName(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getName());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormConverter = (EclipseLinkOrmTypeConverter)((Convert)ormBasicMapping.getSpecifiedConverter()).getConverter();
        TypeConverter javaConverter = (TypeConverter)((Convert)javaBasicMapping.getSpecifiedConverter()).getConverter();
        javaConverter.setName("bar");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"noConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"bar", (String)javaConverter.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)ormBasicMapping.getConverter()).setConverter("typeConverter");
        EclipseLinkOrmTypeConverter ormConverter = (EclipseLinkOrmTypeConverter)((Convert)ormBasicMapping.getConverter()).getConverter();
        XmlTypeConverter converterResource = ((XmlBasic)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverter();
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getName());
        ormConverter.setName("foo");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getName());
        ormConverter.setName(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getName());
    }
}

