/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.caching;

import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.core.internal.context.persistence.GenericProperty;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitPropertyListListener;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.CacheProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.CacheType;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Caching;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.EclipseLinkCaching;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;

public class CachingAdapterTests
extends PersistenceUnitTestCase {
    private Caching caching;
    private ListChangeEvent entitiesEvent;
    public static final String ENTITY_TEST = "Employee";
    public static final String ENTITY_TEST_2 = "Address";
    public static final String CACHE_TYPE_DEFAULT_KEY = "eclipselink.cache.type.default";
    public static final CacheType CACHE_TYPE_DEFAULT_TEST_VALUE = CacheType.soft_weak;
    public static final CacheType CACHE_TYPE_DEFAULT_TEST_VALUE_2 = CacheType.full;
    public static final String CACHE_SIZE_DEFAULT_KEY = "eclipselink.cache.size.default";
    public static final Integer CACHE_SIZE_DEFAULT_TEST_VALUE = 12345;
    public static final Integer CACHE_SIZE_DEFAULT_TEST_VALUE_2 = 67890;
    public static final String SHARED_CACHE_DEFAULT_KEY = "eclipselink.cache.shared.default";
    public static final Boolean SHARED_CACHE_DEFAULT_TEST_VALUE = false;
    public static final Boolean SHARED_CACHE_DEFAULT_TEST_VALUE_2 = true;
    public static final String CACHE_TYPE_KEY = "eclipselink.cache.type.Employee";
    public static final CacheType CACHE_TYPE_TEST_VALUE = CacheType.soft_weak;
    public static final CacheType CACHE_TYPE_TEST_VALUE_2 = CacheType.full;
    public static final String SHARED_CACHE_KEY = "eclipselink.cache.shared.Employee";
    public static final Boolean SHARED_CACHE_TEST_VALUE = false;
    public static final Boolean SHARED_CACHE_TEST_VALUE_2 = true;
    public static final String CACHE_SIZE_KEY = "eclipselink.cache.size.Employee";
    public static final Integer CACHE_SIZE_TEST_VALUE = 12345;
    public static final Integer CACHE_SIZE_TEST_VALUE_2 = 67890;

    public CachingAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.caching = this.persistenceUnit().getCaching();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.caching.addPropertyChangeListener("cacheTypeDefaultProperty", propertyChangeListener);
        this.caching.addPropertyChangeListener("cacheSizeDefaultProperty", propertyChangeListener);
        this.caching.addPropertyChangeListener("sharedCacheDefaultProperty", propertyChangeListener);
        this.caching.addPropertyChangeListener("cacheTypeProperty", propertyChangeListener);
        this.caching.addPropertyChangeListener("cacheSizeProperty", propertyChangeListener);
        this.caching.addPropertyChangeListener("sharedCacheProperty", propertyChangeListener);
        ListChangeListener entitiesChangeListener = this.buildEntitiesChangeListener();
        this.caching.addListChangeListener("entitiesListProperty", entitiesChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.modelPropertiesSizeOriginal = 6;
        this.propertiesTotal = this.modelPropertiesSizeOriginal + 4;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal;
        this.persistenceUnitPut("misc.property.1", "value.1");
        this.persistenceUnitPut(CACHE_TYPE_DEFAULT_KEY, CACHE_TYPE_DEFAULT_TEST_VALUE);
        this.persistenceUnitPut("misc.property.2", "value.2");
        this.persistenceUnitPut(CACHE_SIZE_DEFAULT_KEY, CACHE_SIZE_DEFAULT_TEST_VALUE);
        this.persistenceUnitPut(SHARED_CACHE_DEFAULT_KEY, SHARED_CACHE_DEFAULT_TEST_VALUE);
        this.persistenceUnitPut("misc.property.3", "value.3");
        this.persistenceUnitPut("misc.property.4", "value.4");
        this.persistenceUnitPut(CACHE_SIZE_KEY, CACHE_SIZE_TEST_VALUE);
        this.persistenceUnitPut(CACHE_TYPE_KEY, CACHE_TYPE_TEST_VALUE);
        this.persistenceUnitPut(SHARED_CACHE_KEY, SHARED_CACHE_TEST_VALUE);
    }

    private ListChangeListener buildEntitiesChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                CachingAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                CachingAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                CachingAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void itemsMoved(ListChangeEvent e) {
                CachingAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void listCleared(ListChangeEvent e) {
                CachingAdapterTests.this.throwUnsupportedOperationException(e);
            }

            public void listChanged(ListChangeEvent e) {
                CachingAdapterTests.this.entityChanged(e);
            }
        };
    }

    protected void clearEvent() {
        super.clearEvent();
        this.entitiesEvent = null;
    }

    void entityChanged(ListChangeEvent e) {
        this.entitiesEvent = e;
    }

    public void testEntitiesList() throws Exception {
        this.clearEvent();
        this.caching.addEntity(ENTITY_TEST_2);
        CachingAdapterTests.assertNotNull((String)"No Event Fired.", (Object)this.entitiesEvent);
        CachingAdapterTests.assertEquals((String)"Wrong Event.", (String)this.entitiesEvent.getAspectName(), (String)"entitiesListProperty");
        this.clearEvent();
        this.caching.removeEntity(ENTITY_TEST_2);
        CachingAdapterTests.assertNotNull((String)"No Event Fired.", (Object)this.entitiesEvent);
        CachingAdapterTests.assertEquals((String)"Wrong Event.", (String)this.entitiesEvent.getAspectName(), (String)"entitiesListProperty");
    }

    public void testHasListeners() throws Exception {
        ListAspectAdapter propertiesAdapter = (ListAspectAdapter)this.subject.getPropertiesAdapter();
        GenericProperty ctdProperty = (GenericProperty)this.persistenceUnit().getProperty(CACHE_TYPE_DEFAULT_KEY);
        ListValueModel propertyListAdapter = this.subject.getPropertyListAdapter();
        CachingAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        CachingAdapterTests.assertTrue((boolean)ctdProperty.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners((PersistenceUnitProperties)this.caching, "cacheTypeDefaultProperty");
        this.verifyHasListeners(propertyListAdapter);
        EclipseLinkCaching elCaching = (EclipseLinkCaching)this.caching;
        PersistenceUnitPropertyListListener propertyListListener = elCaching.propertyListListener();
        propertyListAdapter.removeListChangeListener("list values", (ListChangeListener)propertyListListener);
        CachingAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        this.verifyHasListeners((PersistenceUnitProperties)this.caching, "cacheTypeDefaultProperty");
    }

    public void testSetCacheTypeDefault() throws Exception {
        this.verifyModelInitialized(CACHE_TYPE_DEFAULT_KEY, CACHE_TYPE_DEFAULT_TEST_VALUE);
        this.verifySetProperty(CACHE_TYPE_DEFAULT_KEY, CACHE_TYPE_DEFAULT_TEST_VALUE, CACHE_TYPE_DEFAULT_TEST_VALUE_2);
    }

    public void testAddRemoveCacheTypeDefault() throws Exception {
        this.verifyAddRemoveProperty(CACHE_TYPE_DEFAULT_KEY, CACHE_TYPE_DEFAULT_TEST_VALUE, CACHE_TYPE_DEFAULT_TEST_VALUE_2);
    }

    public void testSetCacheSizeDefault() throws Exception {
        this.verifyModelInitialized(CACHE_SIZE_DEFAULT_KEY, CACHE_SIZE_DEFAULT_TEST_VALUE);
        this.verifySetProperty(CACHE_SIZE_DEFAULT_KEY, CACHE_SIZE_DEFAULT_TEST_VALUE, CACHE_SIZE_DEFAULT_TEST_VALUE_2);
    }

    public void testAddRemoveCacheSizeDefault() throws Exception {
        this.verifyAddRemoveProperty(CACHE_SIZE_DEFAULT_KEY, CACHE_SIZE_DEFAULT_TEST_VALUE, CACHE_SIZE_DEFAULT_TEST_VALUE_2);
    }

    public void testSetSharedCacheDefault() throws Exception {
        this.verifyModelInitialized(SHARED_CACHE_DEFAULT_KEY, SHARED_CACHE_DEFAULT_TEST_VALUE);
        this.verifySetProperty(SHARED_CACHE_DEFAULT_KEY, SHARED_CACHE_DEFAULT_TEST_VALUE, SHARED_CACHE_DEFAULT_TEST_VALUE_2);
    }

    public void testAddRemoveSharedCacheDefault() throws Exception {
        this.verifyAddRemoveProperty(SHARED_CACHE_DEFAULT_KEY, SHARED_CACHE_DEFAULT_TEST_VALUE, SHARED_CACHE_DEFAULT_TEST_VALUE_2);
    }

    public void testSetCacheType() throws Exception {
        this.verifyModelInitialized(CACHE_TYPE_KEY, CACHE_TYPE_TEST_VALUE);
        this.verifySetCachingProperty("cacheTypeProperty", CACHE_TYPE_KEY, CACHE_TYPE_TEST_VALUE, CACHE_TYPE_TEST_VALUE_2);
    }

    public void testAddRemoveCacheType() throws Exception {
        this.verifyAddRemoveCachingProperty("cacheTypeProperty", CACHE_TYPE_KEY, CACHE_TYPE_TEST_VALUE, CACHE_TYPE_TEST_VALUE_2);
    }

    public void testSetCacheSize() throws Exception {
        this.verifyModelInitialized(CACHE_SIZE_KEY, CACHE_SIZE_TEST_VALUE);
        this.verifySetCachingProperty("cacheSizeProperty", CACHE_SIZE_KEY, CACHE_SIZE_TEST_VALUE, CACHE_SIZE_TEST_VALUE_2);
    }

    public void testAddRemoveCacheSize() throws Exception {
        this.verifyAddRemoveCachingProperty("cacheSizeProperty", CACHE_SIZE_KEY, CACHE_SIZE_TEST_VALUE, CACHE_SIZE_TEST_VALUE_2);
    }

    public void testSetSharedCache() throws Exception {
        this.verifyModelInitialized(SHARED_CACHE_KEY, SHARED_CACHE_TEST_VALUE);
        this.verifySetCachingProperty("sharedCacheProperty", SHARED_CACHE_KEY, SHARED_CACHE_TEST_VALUE, SHARED_CACHE_TEST_VALUE_2);
    }

    public void testAddRemoveSharedCache() throws Exception {
        this.verifyAddRemoveCachingProperty("sharedCacheProperty", SHARED_CACHE_KEY, SHARED_CACHE_TEST_VALUE, SHARED_CACHE_TEST_VALUE_2);
    }

    protected PersistenceUnitProperties model() {
        return this.caching;
    }

    protected void verifySetCachingProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        ListValueModel propertyListAdapter = this.subject.getPropertyListAdapter();
        this.verifyInitialState(propertyName, key, (ListValueModel<Property>)propertyListAdapter);
        this.persistenceUnitPut(key, testValue2);
        CachingAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        this.verifyPutCachingProperty(propertyName, ENTITY_TEST, testValue2);
        this.clearEvent();
        this.setCachingProperty(propertyName, ENTITY_TEST, testValue1);
        CachingAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        this.verifyPutCachingProperty(propertyName, ENTITY_TEST, testValue1);
    }

    protected void verifyAddRemoveCachingProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        ListValueModel propertyListAdapter = this.subject.getPropertyListAdapter();
        this.clearEvent();
        --this.propertiesTotal;
        --this.modelPropertiesSize;
        this.persistenceUnit().removeProperty(key);
        CachingAdapterTests.assertFalse((boolean)this.persistenceUnit().containsProperty(key));
        CachingAdapterTests.assertEquals((int)this.modelPropertiesSize, (int)(this.modelPropertiesSizeOriginal - 1));
        this.verifyPutCachingProperty(propertyName, ENTITY_TEST, null);
        CachingAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        ++this.propertiesTotal;
        ++this.modelPropertiesSize;
        this.persistenceUnitPut(key, testValue1);
        this.verifyPutCachingProperty(propertyName, ENTITY_TEST, testValue1);
        CachingAdapterTests.assertEquals((int)this.propertiesTotal, (int)propertyListAdapter.size());
        this.persistenceUnitPut(key, testValue2);
        this.verifyPutCachingProperty(propertyName, ENTITY_TEST, testValue2);
    }

    protected void verifyPutCachingProperty(String propertyName, String entityName, Object expectedValue) throws Exception {
        this.verifyEvent(propertyName);
        this.verifyCachingEvent(propertyName, entityName, expectedValue);
    }

    protected void verifyCachingEvent(String propertyName, String entityName, Object expectedValue) throws Exception {
        CacheProperties cache = (CacheProperties)this.propertyChangedEvent.getNewValue();
        if (propertyName.equals("cacheTypeProperty")) {
            CachingAdapterTests.assertEquals((Object)expectedValue, (Object)cache.getType());
            CachingAdapterTests.assertEquals((Object)expectedValue, (Object)this.caching.getCacheType(entityName));
        } else if (propertyName.equals("cacheSizeProperty")) {
            CachingAdapterTests.assertEquals((Object)expectedValue, (Object)cache.getSize());
            CachingAdapterTests.assertEquals((Object)expectedValue, (Object)this.caching.getCacheSize(entityName));
        } else if (propertyName.equals("sharedCacheProperty")) {
            CachingAdapterTests.assertEquals((Object)expectedValue, (Object)cache.isShared());
            CachingAdapterTests.assertEquals((Object)expectedValue, (Object)this.caching.getSharedCache(entityName));
        } else {
            this.throwMissingDefinition("verifyCachingEvent", propertyName);
        }
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        if (propertyName.equals("cacheTypeDefaultProperty")) {
            this.caching.setCacheTypeDefault((CacheType)newValue);
        } else if (propertyName.equals("cacheSizeDefaultProperty")) {
            this.caching.setCacheSizeDefault((Integer)newValue);
        } else if (propertyName.equals("sharedCacheDefaultProperty")) {
            this.caching.setSharedCacheDefault((Boolean)newValue);
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    protected void setCachingProperty(String propertyName, String entityName, Object newValue) throws NoSuchFieldException {
        if (propertyName.equals("cacheTypeProperty")) {
            this.caching.setCacheType((CacheType)newValue, entityName);
        } else if (propertyName.equals("cacheSizeProperty")) {
            this.caching.setCacheSize((Integer)newValue, entityName);
        } else if (propertyName.equals("sharedCacheProperty")) {
            this.caching.setSharedCache((Boolean)newValue, entityName);
        } else {
            this.throwMissingDefinition("setCachingProperty", propertyName);
        }
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Object modelValue = null;
        if (propertyName.equals("cacheTypeDefaultProperty")) {
            modelValue = this.caching.getCacheTypeDefault();
        } else if (propertyName.equals("cacheSizeDefaultProperty")) {
            modelValue = this.caching.getCacheSizeDefault();
        } else if (propertyName.equals("sharedCacheDefaultProperty")) {
            modelValue = this.caching.getSharedCacheDefault();
        } else if (propertyName.equals("cacheSizeProperty")) {
            modelValue = this.caching.getCacheSize(ENTITY_TEST);
        } else if (propertyName.equals("cacheTypeProperty")) {
            modelValue = this.caching.getCacheType(ENTITY_TEST);
        } else if (propertyName.equals("sharedCacheProperty")) {
            modelValue = this.caching.getSharedCache(ENTITY_TEST);
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }
}

