/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.general;

import org.eclipse.jpt.core.internal.context.persistence.GenericProperty;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitPropertyListListener;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.general.EclipseLinkGeneralProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.general.GeneralProperties;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;

public class GeneralPropertiesAdapterTests
extends PersistenceUnitTestCase {
    private GeneralProperties generalProperties;
    public static final String EXCLUDE_ECLIPSELINK_ORM_KEY = "eclipselink.exclude-eclipselink-orm";
    public static final Boolean EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE = false;
    public static final Boolean EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE_2 = EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE == false;

    public GeneralPropertiesAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.generalProperties = this.subject.getGeneralProperties();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.generalProperties.addPropertyChangeListener("excludeEclipselinkOrmProperty", propertyChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.modelPropertiesSizeOriginal = 1;
        this.propertiesTotal = this.modelPropertiesSizeOriginal + 2;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal;
        this.persistenceUnitPut("misc.property.1", "value.1");
        this.persistenceUnitPut(EXCLUDE_ECLIPSELINK_ORM_KEY, EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE.toString());
        this.persistenceUnitPut("misc.property.2", "value.2");
    }

    public void testHasListeners() throws Exception {
        ListAspectAdapter propertiesAdapter = (ListAspectAdapter)this.subject.getPropertiesAdapter();
        GenericProperty ctdProperty = (GenericProperty)this.persistenceUnit().getProperty(EXCLUDE_ECLIPSELINK_ORM_KEY);
        ListValueModel propertyListAdapter = this.subject.getPropertyListAdapter();
        GeneralPropertiesAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        GeneralPropertiesAdapterTests.assertTrue((boolean)ctdProperty.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners((PersistenceUnitProperties)this.generalProperties, "excludeEclipselinkOrmProperty");
        this.verifyHasListeners(propertyListAdapter);
        EclipseLinkGeneralProperties elGeneralProperties = (EclipseLinkGeneralProperties)this.generalProperties;
        PersistenceUnitPropertyListListener propertyListListener = elGeneralProperties.propertyListListener();
        propertyListAdapter.removeListChangeListener("list values", (ListChangeListener)propertyListListener);
        GeneralPropertiesAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        this.verifyHasListeners((PersistenceUnitProperties)this.generalProperties, "excludeEclipselinkOrmProperty");
    }

    public void testSetExcludeEclipselinkOrm() throws Exception {
        this.verifyModelInitialized(EXCLUDE_ECLIPSELINK_ORM_KEY, EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE);
        this.verifySetProperty(EXCLUDE_ECLIPSELINK_ORM_KEY, EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE, EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE_2);
    }

    public void testAddRemoveExcludeEclipselinkOrm() throws Exception {
        this.verifyAddRemoveProperty(EXCLUDE_ECLIPSELINK_ORM_KEY, EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE, EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE_2);
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Boolean modelValue = null;
        if (propertyName.equals("excludeEclipselinkOrmProperty")) {
            modelValue = this.generalProperties.getExcludeEclipselinkOrm();
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        if (propertyName.equals("excludeEclipselinkOrmProperty")) {
            this.generalProperties.setExcludeEclipselinkOrm((Boolean)newValue);
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    protected PersistenceUnitProperties model() {
        return this.generalProperties;
    }
}

