/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.general;

import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.general.GeneralProperties;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralPropertiesValueModelTests
extends PersistenceUnitTestCase {
    private GeneralProperties generalProperty;
    private WritablePropertyValueModel<Boolean> excludeEclipselinkOrmHolder;
    private PropertyChangeListener excludeEclipselinkOrmListener;
    private PropertyChangeEvent excludeEclipselinkOrmEvent;
    public static final Boolean EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE = Boolean.FALSE;

    public GeneralPropertiesValueModelTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.generalProperty = this.subject.getGeneralProperties();
        SimplePropertyValueModel generalPropertyHolder = new SimplePropertyValueModel((Object)this.generalProperty);
        this.excludeEclipselinkOrmHolder = this.buildExcludeEclipselinkOrmAA((PropertyValueModel<GeneralProperties>)generalPropertyHolder);
        this.excludeEclipselinkOrmListener = this.buildExcludeEclipselinkOrmChangeListener();
        this.excludeEclipselinkOrmHolder.addPropertyChangeListener("value", this.excludeEclipselinkOrmListener);
        this.excludeEclipselinkOrmEvent = null;
    }

    public void testHasListeners() {
        AbstractModel subjectGeneralProperty = (AbstractModel)this.generalProperty;
        PropertyAspectAdapter excludeEclipselinkOrmAA = (PropertyAspectAdapter)this.excludeEclipselinkOrmHolder;
        GeneralPropertiesValueModelTests.assertTrue((boolean)excludeEclipselinkOrmAA.hasAnyPropertyChangeListeners("value"));
        GeneralPropertiesValueModelTests.assertTrue((boolean)subjectGeneralProperty.hasAnyPropertyChangeListeners("excludeEclipselinkOrmProperty"));
        excludeEclipselinkOrmAA.removePropertyChangeListener("value", this.excludeEclipselinkOrmListener);
        GeneralPropertiesValueModelTests.assertFalse((boolean)subjectGeneralProperty.hasAnyPropertyChangeListeners("excludeEclipselinkOrmProperty"));
        GeneralPropertiesValueModelTests.assertFalse((boolean)excludeEclipselinkOrmAA.hasAnyPropertyChangeListeners("value"));
    }

    @Override
    protected void populatePu() {
        this.persistenceUnitPut("eclipselink.exclude-eclipselink-orm", EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE);
    }

    @Override
    protected PersistenceUnitProperties model() {
        return this.generalProperty;
    }

    private WritablePropertyValueModel<Boolean> buildExcludeEclipselinkOrmAA(PropertyValueModel<GeneralProperties> subjectHolder) {
        return new PropertyAspectAdapter<GeneralProperties, Boolean>(subjectHolder, new String[]{"excludeEclipselinkOrmProperty"}){

            protected Boolean buildValue_() {
                return ((GeneralProperties)this.subject).getExcludeEclipselinkOrm();
            }

            protected void setValue_(Boolean enumValue) {
                ((GeneralProperties)this.subject).setExcludeEclipselinkOrm(enumValue);
            }
        };
    }

    private PropertyChangeListener buildExcludeEclipselinkOrmChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                GeneralPropertiesValueModelTests.this.excludeEclipselinkOrmEvent = e;
            }
        };
    }

    public void testValue() {
        this.verifyExcludeEclipselinkOrmAAValue(EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE);
        GeneralPropertiesValueModelTests.assertEquals((Object)GeneralProperties.DEFAULT_EXCLUDE_ECLIPSELINK_ORM, (Object)this.generalProperty.getDefaultExcludeEclipselinkOrm());
    }

    public void testSetValue() throws Exception {
        this.excludeEclipselinkOrmEvent = null;
        this.verifyHasListeners((PropertyValueModel)this.excludeEclipselinkOrmHolder, "value");
        Boolean newExcludeEclipselinkOrm = EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE == false;
        this.excludeEclipselinkOrmHolder.setValue((Object)newExcludeEclipselinkOrm);
        this.verifyExcludeEclipselinkOrmAAValue(newExcludeEclipselinkOrm);
        GeneralPropertiesValueModelTests.assertNotNull((Object)this.excludeEclipselinkOrmEvent);
    }

    public void testSetNullValue() {
        String notDeleted = "Property not deleted";
        this.excludeEclipselinkOrmEvent = null;
        this.excludeEclipselinkOrmHolder.setValue(null);
        this.verifyExcludeEclipselinkOrmAAValue(null);
        GeneralPropertiesValueModelTests.assertNotNull((Object)this.excludeEclipselinkOrmEvent);
        this.verifyPuHasNotProperty("eclipselink.exclude-eclipselink-orm", notDeleted);
    }

    protected void verifyExcludeEclipselinkOrmAAValue(Boolean testValue) {
        this.verifyAAValue(testValue, this.generalProperty.getExcludeEclipselinkOrm(), this.excludeEclipselinkOrmHolder, "eclipselink.exclude-eclipselink-orm");
    }

    @Override
    protected void setProperty(String propertyName, Object newValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        throw new UnsupportedOperationException();
    }
}

