/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.schema.generation;

import org.eclipse.jpt.core.internal.context.persistence.GenericProperty;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.PersistenceUnitPropertyListListener;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.DdlGenerationType;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.EclipseLinkSchemaGeneration;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.OutputMode;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.SchemaGeneration;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.persistence.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;

public class SchemaGenerationAdapterTests
extends PersistenceUnitTestCase {
    private SchemaGeneration schemaGeneration;
    public static final String DDL_GENERATION_TYPE_KEY = "eclipselink.ddl-generation";
    public static final DdlGenerationType DDL_GENERATION_TYPE_TEST_VALUE = DdlGenerationType.drop_and_create_tables;
    public static final DdlGenerationType DDL_GENERATION_TYPE_TEST_VALUE_2 = DdlGenerationType.none;
    public static final String OUTPUT_MODE_KEY = "eclipselink.ddl-generation.output-mode";
    public static final OutputMode OUTPUT_MODE_TEST_VALUE = OutputMode.sql_script;
    public static final OutputMode OUTPUT_MODE_TEST_VALUE_2 = OutputMode.database;
    private static final String CREATE_FILE_NAME_KEY = "eclipselink.create-ddl-jdbc-file-name";
    private static final String CREATE_FILE_NAME_TEST_VALUE = "create-file-name.test";
    private static final String CREATE_FILE_NAME_TEST_VALUE_2 = "create-file-name-2.test";
    private static final String DROP_FILE_NAME_KEY = "eclipselink.drop-ddl-jdbc-file-name";
    private static final String DROP_FILE_NAME_TEST_VALUE = "drop-file-name.test";
    private static final String DROP_FILE_NAME_TEST_VALUE_2 = "drop-file-name-2.test";
    private static final String APPLICATION_LOCATION_KEY = "eclipselink.application-location";
    private static final String APPLICATION_LOCATION_TEST_VALUE = "C:/temp";
    private static final String APPLICATION_LOCATION_TEST_VALUE_2 = "C:/tmp";

    public SchemaGenerationAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.schemaGeneration = this.subject.getSchemaGeneration();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.schemaGeneration.addPropertyChangeListener("outputModeProperty", propertyChangeListener);
        this.schemaGeneration.addPropertyChangeListener("ddlGenerationTypeProperty", propertyChangeListener);
        this.schemaGeneration.addPropertyChangeListener("createFileNameProperty", propertyChangeListener);
        this.schemaGeneration.addPropertyChangeListener("dropFileNameProperty", propertyChangeListener);
        this.schemaGeneration.addPropertyChangeListener("applicationLocationProperty", propertyChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.propertiesTotal = 9;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal = 5;
        this.persistenceUnitPut("property.0", "value.0");
        this.persistenceUnitPut(OUTPUT_MODE_KEY, this.getEclipseLinkStringValueOf(OUTPUT_MODE_TEST_VALUE));
        this.persistenceUnitPut("property.2", "value.2");
        this.persistenceUnitPut("property.3", "value.3");
        this.persistenceUnitPut("property.4", "value.4");
        this.persistenceUnitPut(DDL_GENERATION_TYPE_KEY, this.getEclipseLinkStringValueOf(DDL_GENERATION_TYPE_TEST_VALUE));
        this.persistenceUnitPut(CREATE_FILE_NAME_KEY, CREATE_FILE_NAME_TEST_VALUE);
        this.persistenceUnitPut(DROP_FILE_NAME_KEY, DROP_FILE_NAME_TEST_VALUE);
        this.persistenceUnitPut(APPLICATION_LOCATION_KEY, APPLICATION_LOCATION_TEST_VALUE);
    }

    public void testHasListeners() throws Exception {
        ListAspectAdapter propertiesAdapter = (ListAspectAdapter)this.subject.getPropertiesAdapter();
        GenericProperty outputModeProperty = (GenericProperty)this.persistenceUnit().getProperty(OUTPUT_MODE_KEY);
        GenericProperty ddlGenTypeProperty = (GenericProperty)this.persistenceUnit().getProperty(DDL_GENERATION_TYPE_KEY);
        ListValueModel propertyListAdapter = this.subject.getPropertyListAdapter();
        SchemaGenerationAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        SchemaGenerationAdapterTests.assertTrue((boolean)outputModeProperty.hasAnyPropertyChangeListeners("value"));
        SchemaGenerationAdapterTests.assertTrue((boolean)ddlGenTypeProperty.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners((PersistenceUnitProperties)this.schemaGeneration, "outputModeProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.schemaGeneration, "ddlGenerationTypeProperty");
        this.verifyHasListeners(propertyListAdapter);
        EclipseLinkSchemaGeneration schemaGen = (EclipseLinkSchemaGeneration)this.schemaGeneration;
        PersistenceUnitPropertyListListener propertyListListener = schemaGen.propertyListListener();
        propertyListAdapter.removeListChangeListener("list values", (ListChangeListener)propertyListListener);
        this.verifyHasListeners((PersistenceUnitProperties)this.schemaGeneration, "outputModeProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.schemaGeneration, "ddlGenerationTypeProperty");
    }

    public void testSetCreateFileName() throws Exception {
        this.verifyModelInitialized(CREATE_FILE_NAME_KEY, CREATE_FILE_NAME_TEST_VALUE);
        this.verifySetProperty(CREATE_FILE_NAME_KEY, CREATE_FILE_NAME_TEST_VALUE, CREATE_FILE_NAME_TEST_VALUE_2);
    }

    public void testAddRemoveCreateFileName() throws Exception {
        this.verifyAddRemoveProperty(CREATE_FILE_NAME_KEY, CREATE_FILE_NAME_TEST_VALUE, CREATE_FILE_NAME_TEST_VALUE_2);
    }

    public void testSetDropFileName() throws Exception {
        this.verifyModelInitialized(DROP_FILE_NAME_KEY, DROP_FILE_NAME_TEST_VALUE);
        this.verifySetProperty(DROP_FILE_NAME_KEY, DROP_FILE_NAME_TEST_VALUE, DROP_FILE_NAME_TEST_VALUE_2);
    }

    public void testAddRemoveDropFileName() throws Exception {
        this.verifyAddRemoveProperty(DROP_FILE_NAME_KEY, DROP_FILE_NAME_TEST_VALUE, DROP_FILE_NAME_TEST_VALUE_2);
    }

    public void testSetApplicationLocation() throws Exception {
        this.verifyModelInitialized(APPLICATION_LOCATION_KEY, APPLICATION_LOCATION_TEST_VALUE);
        this.verifySetProperty(APPLICATION_LOCATION_KEY, APPLICATION_LOCATION_TEST_VALUE, APPLICATION_LOCATION_TEST_VALUE_2);
    }

    public void testAddRemoveApplicationLocation() throws Exception {
        this.verifyAddRemoveProperty(APPLICATION_LOCATION_KEY, APPLICATION_LOCATION_TEST_VALUE, APPLICATION_LOCATION_TEST_VALUE_2);
    }

    public void testSetOutputMode() throws Exception {
        this.verifyModelInitialized(OUTPUT_MODE_KEY, OUTPUT_MODE_TEST_VALUE);
        this.verifySetProperty(OUTPUT_MODE_KEY, OUTPUT_MODE_TEST_VALUE, OUTPUT_MODE_TEST_VALUE_2);
    }

    public void testAddRemoveOutputMode() throws Exception {
        this.verifyAddRemoveProperty(OUTPUT_MODE_KEY, OUTPUT_MODE_TEST_VALUE, OUTPUT_MODE_TEST_VALUE_2);
    }

    public void testSetDdlGenerationType() throws Exception {
        this.verifyModelInitialized(DDL_GENERATION_TYPE_KEY, DDL_GENERATION_TYPE_TEST_VALUE);
        this.verifySetProperty(DDL_GENERATION_TYPE_KEY, DDL_GENERATION_TYPE_TEST_VALUE, DDL_GENERATION_TYPE_TEST_VALUE_2);
    }

    public void testAddRemoveDdlGenerationType() throws Exception {
        this.verifyAddRemoveProperty(DDL_GENERATION_TYPE_KEY, DDL_GENERATION_TYPE_TEST_VALUE, DDL_GENERATION_TYPE_TEST_VALUE_2);
    }

    protected void setProperty(String propertyName, Object newValue) throws NoSuchFieldException {
        if (propertyName.equals("outputModeProperty")) {
            this.schemaGeneration.setOutputMode((OutputMode)newValue);
        } else if (propertyName.equals("ddlGenerationTypeProperty")) {
            this.schemaGeneration.setDdlGenerationType((DdlGenerationType)newValue);
        } else if (propertyName.equals("applicationLocationProperty")) {
            this.schemaGeneration.setApplicationLocation((String)newValue);
        } else if (propertyName.equals("createFileNameProperty")) {
            this.schemaGeneration.setCreateFileName((String)newValue);
        } else if (propertyName.equals("dropFileNameProperty")) {
            this.schemaGeneration.setDropFileName((String)newValue);
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Object modelValue = null;
        if (propertyName.equals("outputModeProperty")) {
            modelValue = this.schemaGeneration.getOutputMode();
        } else if (propertyName.equals("ddlGenerationTypeProperty")) {
            modelValue = this.schemaGeneration.getDdlGenerationType();
        } else if (propertyName.equals("applicationLocationProperty")) {
            modelValue = this.schemaGeneration.getApplicationLocation();
        } else if (propertyName.equals("createFileNameProperty")) {
            modelValue = this.schemaGeneration.getCreateFileName();
        } else if (propertyName.equals("dropFileNameProperty")) {
            modelValue = this.schemaGeneration.getDropFileName();
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }

    protected PersistenceUnitProperties model() {
        return this.schemaGeneration;
    }
}

