/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.resource.java.ChangeTrackingAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ChangeTrackingType;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class ChangeTrackingTests
extends EclipseLinkJavaResourceModelTestCase {
    public ChangeTrackingTests(String name) {
        super(name);
    }

    private void createChangeTrackingTypeEnum() throws Exception {
        this.createEnumAndMembers("ChangeTrackingType", "ATTRIBUTE, OBJECT, DEFERRED, AUTO;");
    }

    private void createChangeTrackingAnnotation() throws Exception {
        this.createAnnotationAndMembers("ChangeTracking", "ChangeTrackingType value() default AUTO;");
        this.createChangeTrackingTypeEnum();
    }

    private ICompilationUnit createTestChangeTracking() throws Exception {
        this.createChangeTrackingAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.ChangeTracking", "org.eclipse.persistence.annotations.ChangeTrackingType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@ChangeTracking");
            }
        });
    }

    private ICompilationUnit createTestChangeTrackingWithValue() throws Exception {
        this.createChangeTrackingAnnotation();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.ChangeTracking", "org.eclipse.persistence.annotations.ChangeTrackingType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@ChangeTracking(ChangeTrackingType.DEFERRED)");
            }
        });
    }

    public void testChangeTracking() throws Exception {
        ICompilationUnit cu = this.createTestChangeTracking();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        ChangeTrackingAnnotation existenceChecking = (ChangeTrackingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        ChangeTrackingTests.assertNotNull((Object)existenceChecking);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestChangeTrackingWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        ChangeTrackingAnnotation existenceChecking = (ChangeTrackingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        ChangeTrackingTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)existenceChecking.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestChangeTrackingWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        ChangeTrackingAnnotation existenceChecking = (ChangeTrackingAnnotation)typeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        ChangeTrackingTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)existenceChecking.getValue());
        existenceChecking.setValue(ChangeTrackingType.ATTRIBUTE);
        ChangeTrackingTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)existenceChecking.getValue());
        this.assertSourceContains("@ChangeTracking(ATTRIBUTE)", cu);
        existenceChecking.setValue(null);
        ChangeTrackingTests.assertNull((Object)existenceChecking.getValue());
        this.assertSourceDoesNotContain("(ATTRIBUTE)", cu);
        this.assertSourceContains("@ChangeTracking", cu);
        this.assertSourceDoesNotContain("@ChangeTracking(", cu);
    }
}

