/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.resource.java.MutableAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class MutableAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public MutableAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMutable() throws Exception {
        this.createAnnotationAndMembers("Mutable", "boolean value() default true;");
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Mutable"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Mutable");
            }
        });
    }

    private ICompilationUnit createTestMutableWithValue() throws Exception {
        this.createAnnotationAndMembers("Mutable", "boolean value() default true;");
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Mutable"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Mutable(value=true)");
            }
        });
    }

    public void testMutableAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestMutable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MutableAnnotationTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable"));
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        MutableAnnotationTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable"));
        attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        MutableAnnotationTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable"));
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestMutableWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MutableAnnotation mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        MutableAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)mutableAnnotation.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestMutableWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MutableAnnotation mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        MutableAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)mutableAnnotation.getValue());
        mutableAnnotation.setValue(Boolean.FALSE);
        MutableAnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)mutableAnnotation.getValue());
        this.assertSourceContains("@Mutable(value=false)", cu);
        mutableAnnotation.setValue(null);
        mutableAnnotation.setValue(Boolean.FALSE);
        this.assertSourceContains("@Mutable(false)", cu);
    }

    public void testSetValueNull() throws Exception {
        ICompilationUnit cu = this.createTestMutableWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MutableAnnotation mutableAnnotation = (MutableAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.Mutable");
        MutableAnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)mutableAnnotation.getValue());
        mutableAnnotation.setValue(null);
        MutableAnnotationTests.assertNull((Object)mutableAnnotation.getValue());
        this.assertSourceContains("@Mutable", cu);
        this.assertSourceDoesNotContain("value", cu);
    }
}

