/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.resource.java.StructConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class StructConverterAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public StructConverterAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestStructConverter() throws Exception {
        this.createAnnotationAndMembers("StructConverter", "String name(); String converter()");
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@StructConverter");
            }
        });
    }

    private ICompilationUnit createTestStructConverterWithConverter() throws Exception {
        this.createAnnotationAndMembers("StructConverter", "String name(); String converter()");
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@StructConverter(converter=\"Foo\")");
            }
        });
    }

    private ICompilationUnit createTestStructConverterWithName() throws Exception {
        this.createAnnotationAndMembers("StructConverter", "String name(); String converter()");
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@StructConverter(name=\"bar\")");
            }
        });
    }

    public void testStructConverterAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestStructConverter();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        StructConverterAnnotationTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter"));
        attributeResource.removeSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter"));
        attributeResource.addSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter"));
    }

    public void testGetConverter() throws Exception {
        ICompilationUnit cu = this.createTestStructConverterWithConverter();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        StructConverterAnnotation converter = (StructConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getConverter());
    }

    public void testSetConverter() throws Exception {
        ICompilationUnit cu = this.createTestStructConverterWithConverter();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        StructConverterAnnotation converter = (StructConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getConverter());
        converter.setConverter("Bar");
        StructConverterAnnotationTests.assertEquals((String)"Bar", (String)converter.getConverter());
        this.assertSourceContains("@StructConverter(converter=\"Bar\")", cu);
    }

    public void testSetConverterNull() throws Exception {
        ICompilationUnit cu = this.createTestStructConverterWithConverter();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        StructConverterAnnotation converter = (StructConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getConverter());
        converter.setConverter(null);
        StructConverterAnnotationTests.assertNull((Object)converter.getConverter());
        this.assertSourceContains("@StructConverter", cu);
        this.assertSourceDoesNotContain("converter", cu);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestStructConverterWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        StructConverterAnnotation converter = (StructConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestStructConverterWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        StructConverterAnnotation converter = (StructConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
        converter.setName("foo");
        StructConverterAnnotationTests.assertEquals((String)"foo", (String)converter.getName());
        this.assertSourceContains("@StructConverter(name=\"foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestStructConverterWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        StructConverterAnnotation converter = (StructConverterAnnotation)attributeResource.getSupportingAnnotation("org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
        converter.setName(null);
        StructConverterAnnotationTests.assertNull((Object)converter.getName());
        this.assertSourceContains("@StructConverter", cu);
        this.assertSourceDoesNotContain("name=", cu);
    }
}

