/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.resource.java.NamedConverterAnnotation;
import org.eclipse.jpt.utility.internal.StringTools;

public abstract class EclipseLinkJavaConverter
extends AbstractJavaJpaContextNode
implements EclipseLinkConverter {
    private JavaResourcePersistentMember resourcePersistentMember;
    private String name;

    protected EclipseLinkJavaConverter(JavaJpaContextNode parent, JavaResourcePersistentMember jrpm) {
        super((JpaContextNode)parent);
        this.initialize(jrpm);
    }

    protected NamedConverterAnnotation getAnnotation() {
        return (NamedConverterAnnotation)this.resourcePersistentMember.getSupportingAnnotation(this.getAnnotationName());
    }

    protected abstract String getAnnotationName();

    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.getAnnotation().setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    protected void setName_(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    protected void initialize(JavaResourcePersistentMember jrpm) {
        this.resourcePersistentMember = jrpm;
        this.name = this.name(this.getAnnotation());
        this.getPersistenceUnit().addConverter(this);
    }

    protected void update(JavaResourcePersistentMember jrpm) {
        this.resourcePersistentMember = jrpm;
        this.setName_(this.name(this.getAnnotation()));
        this.getPersistenceUnit().addConverter(this);
    }

    protected String name(NamedConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getName();
    }

    public boolean overrides(EclipseLinkConverter converter) {
        return false;
    }

    public boolean duplicates(EclipseLinkConverter converter) {
        return this != converter && !StringTools.stringIsEmpty((String)this.name) && this.name.equals(converter.getName()) && !this.overrides(converter) && !converter.overrides(this);
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getAnnotation().getTextRange(astRoot);
    }
}

