/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.CacheProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.CacheType;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Caching;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkCaching
extends EclipseLinkPersistenceUnitProperties
implements Caching {
    private CacheType cacheTypeDefault;
    private Integer cacheSizeDefault;
    private Boolean sharedCacheDefault;
    private Map<String, CacheProperties> entitiesCacheProperties;
    private static final long serialVersionUID = 1L;

    public EclipseLinkCaching(PersistenceUnit parent, ListValueModel<Property> propertyListAdapter) {
        super(parent, propertyListAdapter);
    }

    @Override
    protected void initializeProperties() {
        this.entitiesCacheProperties = new HashMap<String, CacheProperties>();
        this.cacheTypeDefault = (CacheType)this.getEnumValue("eclipselink.cache.type.default", CacheType.values());
        this.cacheSizeDefault = this.getIntegerValue("eclipselink.cache.size.default");
        this.sharedCacheDefault = this.getBooleanValue("eclipselink.cache.shared.default");
        Set<Property> cacheTypeProperties = this.getPropertiesSetWithPrefix("eclipselink.cache.type.");
        Set<Property> cacheSizeProperties = this.getPropertiesSetWithPrefix("eclipselink.cache.size.");
        Set<Property> sharedCacheProperties = this.getPropertiesSetWithPrefix("eclipselink.cache.shared.");
        this.initializeEntitiesCacheType(cacheTypeProperties);
        this.initializeEntitiesCacheSize(cacheSizeProperties);
        this.initializeEntitiesSharedCache(sharedCacheProperties);
    }

    private void initializeEntitiesCacheType(Set<Property> properties) {
        for (Property property : properties) {
            String entityName = this.getEntityName(property);
            CacheType cacheType = (CacheType)EclipseLinkCaching.getEnumValueOf((String)property.getValue(), (Enum[])CacheType.values());
            this.setCacheType_(cacheType, entityName);
        }
    }

    private void initializeEntitiesCacheSize(Set<Property> properties) {
        for (Property property : properties) {
            String entityName = this.getEntityName(property);
            this.setCacheSize_(property, entityName);
        }
    }

    private void initializeEntitiesSharedCache(Set<Property> properties) {
        for (Property property : properties) {
            String entityName = this.getEntityName(property);
            this.setSharedCache_(property, entityName);
        }
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.cache.type.default", "cacheTypeDefaultProperty");
        propertyNames.put("eclipselink.cache.size.default", "cacheSizeDefaultProperty");
        propertyNames.put("eclipselink.cache.shared.default", "sharedCacheDefaultProperty");
    }

    @Override
    public boolean itemIsProperty(Property item) {
        boolean isProperty = super.itemIsProperty(item);
        if (!isProperty && item.getName() != null && (item.getName().startsWith("eclipselink.cache.type.") || item.getName().startsWith("eclipselink.cache.size.") || item.getName().startsWith("eclipselink.cache.shared."))) {
            return true;
        }
        return isProperty;
    }

    @Override
    public String propertyIdFor(Property property) {
        try {
            return super.propertyIdFor(property);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (property.getName().startsWith("eclipselink.cache.type.")) {
                return "cacheTypeProperty";
            }
            if (property.getName().startsWith("eclipselink.cache.size.")) {
                return "cacheSizeProperty";
            }
            if (property.getName().startsWith("eclipselink.cache.shared.")) {
                return "sharedCacheProperty";
            }
            throw new IllegalArgumentException("Illegal property: " + property.toString());
        }
    }

    public void propertyChanged(PropertyChangeEvent event) {
        String aspectName = event.getAspectName();
        if (aspectName.equals("cacheTypeDefaultProperty")) {
            this.cacheTypeDefaultChanged(event);
        } else if (aspectName.equals("cacheSizeDefaultProperty")) {
            this.cacheSizeDefaultChanged(event);
        } else if (aspectName.equals("sharedCacheDefaultProperty")) {
            this.sharedCacheDefaultChanged(event);
        } else if (aspectName.equals("cacheTypeProperty")) {
            this.cacheTypeChanged(event);
        } else if (aspectName.equals("cacheSizeProperty")) {
            this.cacheSizeChanged(event);
        } else if (aspectName.equals("sharedCacheProperty")) {
            this.sharedCacheChanged(event);
        } else {
            throw new IllegalArgumentException("Illegal event received - property not applicable: " + aspectName);
        }
    }

    @Override
    public CacheType getCacheType(String entityName) {
        CacheProperties cache = this.cachePropertiesOf(entityName);
        return cache == null ? null : cache.getType();
    }

    @Override
    public void setCacheType(CacheType newCacheType, String entityName) {
        CacheProperties old = this.setCacheType_(newCacheType, entityName);
        this.putEnumValue("eclipselink.cache.type.", entityName, newCacheType, false);
        this.firePropertyChanged("cacheTypeProperty", old, this.cachePropertiesOf(entityName));
    }

    private void cacheTypeChanged(PropertyChangeEvent event) {
        Property property = (Property)event.getNewValue();
        String entityName = property == null ? this.getEntityName((Property)event.getOldValue()) : this.getEntityName(property);
        CacheProperties old = this.setCacheType_(property, entityName);
        this.firePropertyChanged(event.getAspectName(), old, this.cachePropertiesOf(entityName));
    }

    @Override
    public CacheType getDefaultCacheType() {
        return this.cacheTypeDefault == null ? DEFAULT_CACHE_TYPE : this.cacheTypeDefault;
    }

    @Override
    public Integer getCacheSize(String entityName) {
        CacheProperties cache = this.cachePropertiesOf(entityName);
        return cache == null ? null : cache.getSize();
    }

    @Override
    public void setCacheSize(Integer newCacheSize, String entityName) {
        CacheProperties old = this.setCacheSize_(newCacheSize, entityName);
        this.putIntegerValue("eclipselink.cache.size." + entityName, newCacheSize);
        this.firePropertyChanged("cacheSizeProperty", old, this.cachePropertiesOf(entityName));
    }

    private void cacheSizeChanged(PropertyChangeEvent event) {
        Property property = (Property)event.getNewValue();
        String entityName = property == null ? this.getEntityName((Property)event.getOldValue()) : this.getEntityName(property);
        CacheProperties old = this.setCacheSize_(property, entityName);
        this.firePropertyChanged(event.getAspectName(), old, this.cachePropertiesOf(entityName));
    }

    @Override
    public Integer getDefaultCacheSize() {
        return this.cacheSizeDefault == null ? DEFAULT_CACHE_SIZE : this.cacheSizeDefault;
    }

    @Override
    public Boolean getSharedCache(String entityName) {
        CacheProperties cache = this.cachePropertiesOf(entityName);
        return cache == null ? null : cache.isShared();
    }

    @Override
    public void setSharedCache(Boolean newSharedCache, String entityName) {
        CacheProperties old = this.setSharedCache_(newSharedCache, entityName);
        this.putBooleanValue("eclipselink.cache.shared.", entityName, newSharedCache, false);
        this.firePropertyChanged("sharedCacheProperty", old, this.cachePropertiesOf(entityName));
    }

    private void sharedCacheChanged(PropertyChangeEvent event) {
        Property newProperty = (Property)event.getNewValue();
        String entityName = newProperty == null ? this.getEntityName((Property)event.getOldValue()) : this.getEntityName(newProperty);
        CacheProperties old = this.setSharedCache_(newProperty, entityName);
        this.firePropertyChanged(event.getAspectName(), old, this.cachePropertiesOf(entityName));
    }

    @Override
    public Boolean getDefaultSharedCache() {
        return this.sharedCacheDefault == null ? DEFAULT_SHARED_CACHE : this.sharedCacheDefault;
    }

    @Override
    public CacheType getCacheTypeDefault() {
        return this.cacheTypeDefault;
    }

    @Override
    public void setCacheTypeDefault(CacheType newCacheTypeDefault) {
        CacheType old = this.cacheTypeDefault;
        this.cacheTypeDefault = newCacheTypeDefault;
        this.putProperty("cacheTypeDefaultProperty", (Object)newCacheTypeDefault);
        this.firePropertyChanged("cacheTypeDefaultProperty", (Object)old, (Object)newCacheTypeDefault);
    }

    private void cacheTypeDefaultChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        CacheType newValue = (CacheType)EclipseLinkCaching.getEnumValueOf((String)stringValue, (Enum[])CacheType.values());
        CacheType old = this.cacheTypeDefault;
        this.cacheTypeDefault = newValue;
        this.firePropertyChanged(event.getAspectName(), (Object)old, (Object)newValue);
    }

    @Override
    public CacheType getDefaultCacheTypeDefault() {
        return DEFAULT_CACHE_TYPE_DEFAULT;
    }

    @Override
    public Integer getCacheSizeDefault() {
        return this.cacheSizeDefault;
    }

    @Override
    public void setCacheSizeDefault(Integer newCacheSizeDefault) {
        Integer old = this.cacheSizeDefault;
        this.cacheSizeDefault = newCacheSizeDefault;
        this.putProperty("cacheSizeDefaultProperty", newCacheSizeDefault);
        this.firePropertyChanged("cacheSizeDefaultProperty", old, newCacheSizeDefault);
    }

    private void cacheSizeDefaultChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Integer newValue = EclipseLinkCaching.getIntegerValueOf(stringValue);
        Integer old = this.cacheSizeDefault;
        this.cacheSizeDefault = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Integer getDefaultCacheSizeDefault() {
        return DEFAULT_CACHE_SIZE_DEFAULT;
    }

    @Override
    public Boolean getSharedCacheDefault() {
        return this.sharedCacheDefault;
    }

    @Override
    public void setSharedCacheDefault(Boolean newSharedCacheDefault) {
        Boolean old = this.sharedCacheDefault;
        this.sharedCacheDefault = newSharedCacheDefault;
        this.putProperty("sharedCacheDefaultProperty", newSharedCacheDefault);
        this.firePropertyChanged("sharedCacheDefaultProperty", old, newSharedCacheDefault);
    }

    private void sharedCacheDefaultChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkCaching.getBooleanValueOf(stringValue);
        Boolean old = this.sharedCacheDefault;
        this.sharedCacheDefault = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultSharedCacheDefault() {
        return DEFAULT_SHARED_CACHE_DEFAULT;
    }

    private CacheProperties setCacheType_(Property newProperty, String entityName) {
        String stringValue = newProperty == null ? null : newProperty.getValue();
        CacheType newValue = (CacheType)EclipseLinkCaching.getEnumValueOf((String)stringValue, (Enum[])CacheType.values());
        return this.setCacheType_(newValue, entityName);
    }

    private CacheProperties setCacheType_(CacheType newValue, String entityName) {
        CacheProperties properties = this.cachePropertiesOf(entityName);
        CacheProperties old = properties.clone();
        properties.setType(newValue);
        this.putEntityCacheProperties(entityName, properties);
        return old;
    }

    private CacheProperties setCacheSize_(Property newProperty, String entityName) {
        String stringValue = newProperty == null ? null : newProperty.getValue();
        Integer newValue = EclipseLinkCaching.getIntegerValueOf(stringValue);
        return this.setCacheSize_(newValue, entityName);
    }

    private CacheProperties setCacheSize_(Integer newValue, String entityName) {
        CacheProperties properties = this.cachePropertiesOf(entityName);
        CacheProperties old = properties.clone();
        properties.setSize(newValue);
        this.putEntityCacheProperties(entityName, properties);
        return old;
    }

    private CacheProperties setSharedCache_(Property newProperty, String entityName) {
        String newValue = newProperty == null ? null : newProperty.getValue();
        return this.setSharedCache_(newValue, entityName);
    }

    private CacheProperties setSharedCache_(String newString, String entityName) {
        Boolean newValue = EclipseLinkCaching.getBooleanValueOf(newString);
        return this.setSharedCache_(newValue, entityName);
    }

    private CacheProperties setSharedCache_(Boolean newValue, String entityName) {
        CacheProperties properties = this.cachePropertiesOf(entityName);
        CacheProperties old = properties.clone();
        properties.setShared(newValue);
        this.putEntityCacheProperties(entityName, properties);
        return old;
    }

    private CacheProperties cachePropertiesOf(String entityName) {
        CacheProperties properties = this.entitiesCacheProperties.get(entityName);
        if (properties == null) {
            properties = new CacheProperties(entityName);
        }
        return properties;
    }

    private void clearCacheProperties(String entityName) {
        this.setCacheType(null, entityName);
        this.setCacheSize(null, entityName);
        this.setSharedCache(null, entityName);
    }

    private void putEntityCacheProperties(String entityName, CacheProperties properties) {
        this.addOrReplacePropertiesForEntity(entityName, properties);
    }

    @Override
    public ListIterator<String> entities() {
        return CollectionTools.list(this.entitiesCacheProperties.keySet()).listIterator();
    }

    @Override
    public int entitiesSize() {
        return this.entitiesCacheProperties.size();
    }

    @Override
    public boolean entityExists(String entity) {
        return this.entitiesCacheProperties.containsKey(entity);
    }

    @Override
    public String addEntity(String entity) {
        if (this.entityExists(entity)) {
            throw new IllegalStateException("Entity " + entity + " already exist.");
        }
        return this.addOrReplacePropertiesForEntity(entity, new CacheProperties(entity));
    }

    private String addOrReplacePropertiesForEntity(String entity, CacheProperties properties) {
        if (this.entityExists(entity)) {
            this.replaceEntity_(entity, properties);
            return null;
        }
        this.entitiesCacheProperties.put(entity, properties);
        this.fireListChanged("entitiesListProperty");
        return entity;
    }

    private CacheProperties replaceEntity_(String entity, CacheProperties properties) {
        CacheProperties old = this.entitiesCacheProperties.get(entity);
        if (properties.isEmpty()) {
            this.entitiesCacheProperties.remove(entity);
            this.fireListChanged("entitiesListProperty");
        } else {
            this.entitiesCacheProperties.put(entity, properties);
        }
        return old;
    }

    @Override
    public void removeEntity(String entity) {
        if (!this.entityExists(entity)) {
            return;
        }
        this.clearCacheProperties(entity);
        this.entitiesCacheProperties.remove(entity);
        this.fireListChanged("entitiesListProperty");
    }
}

