/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.eclipselink.core.resource.java.ChangeTrackingAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ChangeTrackingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeTrackingImpl
extends AbstractResourceAnnotation<Type>
implements ChangeTrackingAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.ChangeTracking");
    private final AnnotationElementAdapter<String> valueAdapter;
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = ChangeTrackingImpl.buildValueAdapter();
    private ChangeTrackingType value;

    protected ChangeTrackingImpl(JavaResourcePersistentType parent, Type type) {
        super((JavaResourceNode)parent, (Member)type, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, VALUE_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ChangeTracking";
    }

    @Override
    public ChangeTrackingType getValue() {
        return this.value;
    }

    @Override
    public void setValue(ChangeTrackingType newValue) {
        if (this.attributeValueHasNotChanged((Object)this.value, (Object)newValue)) {
            return;
        }
        ChangeTrackingType oldValue = this.value;
        this.value = newValue;
        this.valueAdapter.setValue((Object)ChangeTrackingType.toJavaAnnotationValue(newValue));
        this.firePropertyChanged("valueProperty", (Object)oldValue, (Object)newValue);
    }

    public void initialize(CompilationUnit astRoot) {
        this.value = this.value(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setValue(this.value(astRoot));
    }

    protected ChangeTrackingType value(CompilationUnit astRoot) {
        return ChangeTrackingType.fromJavaAnnotationValue(this.valueAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value", false);
    }

    public static class ChangeTrackingAnnotationDefinition
    implements AnnotationDefinition {
        private static final ChangeTrackingAnnotationDefinition INSTANCE = new ChangeTrackingAnnotationDefinition();

        public static ChangeTrackingAnnotationDefinition instance() {
            return INSTANCE;
        }

        private ChangeTrackingAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new ChangeTrackingImpl((JavaResourcePersistentType)parent, (Type)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "org.eclipse.persistence.annotations.ChangeTracking";
        }
    }
}

