/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import org.eclipse.jpt.core.context.DiscriminatorColumn;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.db.ColumnCombo;
import org.eclipse.jpt.ui.internal.util.LabeledControlUpdater;
import org.eclipse.jpt.ui.internal.util.LabeledLabel;
import org.eclipse.jpt.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInheritanceComposite<T extends Entity>
extends Pane<T> {
    protected static String DEFAULT_KEY = "?!#!?#?#?default?#?!#?!#?";

    public AbstractInheritanceComposite(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    private WritablePropertyValueModel<String> buildColumnDefinitionHolder(PropertyValueModel<DiscriminatorColumn> discriminatorColumnHolder) {
        return new PropertyAspectAdapter<DiscriminatorColumn, String>(discriminatorColumnHolder, new String[]{"columnDefinition"}){

            protected String buildValue_() {
                return ((DiscriminatorColumn)this.subject).getColumnDefinition();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((DiscriminatorColumn)this.subject).setColumnDefinition(value);
            }
        };
    }

    private ListValueModel<String> buildDefaultDiscriminatorListValueHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultDiscriminatorValueHolder());
    }

    private WritablePropertyValueModel<String> buildDefaultDiscriminatorValueHolder() {
        return new PropertyAspectAdapter<Entity, String>(this.getSubjectHolder(), new String[]{"defaultDiscriminatorValue"}){

            protected String buildValue_() {
                String name = ((Entity)this.subject).getDefaultDiscriminatorValue();
                name = name == null ? DEFAULT_KEY : String.valueOf(DEFAULT_KEY) + name;
                return name;
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildDefaultLengthHolder() {
        return new PropertyAspectAdapter<DiscriminatorColumn, Integer>(this.buildDiscriminatorColumnHolder(), new String[]{"defaultLength"}){

            protected Integer buildValue_() {
                return ((DiscriminatorColumn)this.subject).getDefaultLength();
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Integer.MIN_VALUE, newValue);
                }
            }
        };
    }

    private Control addDefaultLengthLabel(Composite container) {
        Label label = this.addLabel(container, JptUiMappingsMessages.DefaultWithoutValue);
        new LabeledControlUpdater(new LabeledLabel(label), this.buildDefaultLengthLabelHolder());
        return label;
    }

    private PropertyValueModel<String> buildDefaultLengthLabelHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultLengthHolder()){

            protected String transform(Integer value) {
                Integer defaultValue = AbstractInheritanceComposite.this.getSubject() != null ? ((Entity)AbstractInheritanceComposite.this.getSubject()).getDiscriminatorColumn().getDefaultLength() : DiscriminatorColumn.DEFAULT_LENGTH;
                return NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)defaultValue);
            }
        };
    }

    private ColumnCombo<DiscriminatorColumn> addDiscriminatorColumnCombo(Composite container, PropertyValueModel<DiscriminatorColumn> discriminatorColumnHolder) {
        return new ColumnCombo<DiscriminatorColumn>((Pane)this, discriminatorColumnHolder, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("specifiedName");
                propertyNames.add("defaultName");
            }

            @Override
            protected String getDefaultValue() {
                return ((DiscriminatorColumn)this.getSubject()).getDefaultName();
            }

            @Override
            protected void setValue(String value) {
                ((DiscriminatorColumn)this.getSubject()).setSpecifiedName(value);
            }

            @Override
            protected Table getDbTable_() {
                return ((DiscriminatorColumn)this.getSubject()).getDbTable();
            }

            @Override
            protected String getValue() {
                return ((DiscriminatorColumn)this.getSubject()).getSpecifiedName();
            }
        };
    }

    private PropertyValueModel<DiscriminatorColumn> buildDiscriminatorColumnHolder() {
        return new TransformationPropertyValueModel<Entity, DiscriminatorColumn>(this.getSubjectHolder()){

            protected DiscriminatorColumn transform_(Entity value) {
                return value.getDiscriminatorColumn();
            }
        };
    }

    private EnumFormComboViewer<DiscriminatorColumn, DiscriminatorType> addDiscriminatorTypeCombo(Composite container, PropertyValueModel<DiscriminatorColumn> discriminatorColumnHolder) {
        return new EnumFormComboViewer<DiscriminatorColumn, DiscriminatorType>((Pane)this, discriminatorColumnHolder, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultDiscriminatorType");
                propertyNames.add("specifiedDiscriminatorType");
            }

            protected DiscriminatorType[] getChoices() {
                return DiscriminatorType.values();
            }

            @Override
            protected DiscriminatorType getDefaultValue() {
                return ((DiscriminatorColumn)this.getSubject()).getDefaultDiscriminatorType();
            }

            @Override
            protected String displayString(DiscriminatorType value) {
                return this.buildDisplayString(JptUiMappingsMessages.class, AbstractInheritanceComposite.class, (Object)value);
            }

            @Override
            protected DiscriminatorType getValue() {
                return ((DiscriminatorColumn)this.getSubject()).getSpecifiedDiscriminatorType();
            }

            @Override
            protected void setValue(DiscriminatorType value) {
                ((DiscriminatorColumn)this.getSubject()).setSpecifiedDiscriminatorType(value);
            }
        };
    }

    private StringConverter<String> buildDiscriminatorValueConverter() {
        return new StringConverter<String>(){

            public String convertToString(String value) {
                if (AbstractInheritanceComposite.this.getSubject() == null) {
                    return null;
                }
                if (value == null) {
                    value = ((Entity)AbstractInheritanceComposite.this.getSubject()).getDefaultDiscriminatorValue();
                    value = value != null ? String.valueOf(DEFAULT_KEY) + value : DEFAULT_KEY;
                }
                if (value.startsWith(DEFAULT_KEY)) {
                    String defaultName = value.substring(DEFAULT_KEY.length());
                    value = defaultName.length() > 0 ? NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)defaultName) : JptUiMappingsMessages.DefaultWithoutValue;
                }
                return value;
            }
        };
    }

    private WritablePropertyValueModel<String> buildDiscriminatorValueHolder() {
        return new PropertyAspectAdapter<Entity, String>(this.getSubjectHolder(), new String[]{"specifiedDiscriminatorValue"}){

            protected String buildValue_() {
                return ((Entity)this.subject).getSpecifiedDiscriminatorValue();
            }

            protected void setValue_(String value) {
                if (value != null && (value.length() == 0 || value.startsWith(DEFAULT_KEY))) {
                    value = null;
                }
                ((Entity)this.subject).setSpecifiedDiscriminatorValue(value);
            }
        };
    }

    private ListValueModel<String> buildDiscriminatorValueListHolder() {
        return this.buildDefaultDiscriminatorListValueHolder();
    }

    private WritablePropertyValueModel<Integer> buildLengthHolder(PropertyValueModel<DiscriminatorColumn> discriminatorColumnHolder) {
        return new PropertyAspectAdapter<DiscriminatorColumn, Integer>(discriminatorColumnHolder, new String[]{"spcifiedLength"}){

            protected Integer buildValue_() {
                return ((DiscriminatorColumn)this.subject).getSpecifiedLength();
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((DiscriminatorColumn)this.subject).setSpecifiedLength(value);
            }
        };
    }

    private EnumFormComboViewer<Entity, InheritanceType> addStrategyCombo(Composite container) {
        return new EnumFormComboViewer<Entity, InheritanceType>((Pane)this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultInheritanceStrategy");
                propertyNames.add("specifiedInheritanceStrategy");
            }

            protected InheritanceType[] getChoices() {
                return InheritanceType.values();
            }

            @Override
            protected InheritanceType getDefaultValue() {
                return ((Entity)this.getSubject()).getDefaultInheritanceStrategy();
            }

            @Override
            protected String displayString(InheritanceType value) {
                return this.buildDisplayString(JptUiMappingsMessages.class, AbstractInheritanceComposite.class, (Object)value);
            }

            @Override
            protected InheritanceType getValue() {
                return ((Entity)this.getSubject()).getSpecifiedInheritanceStrategy();
            }

            @Override
            protected void setValue(InheritanceType value) {
                ((Entity)this.getSubject()).setSpecifiedInheritanceStrategy(value);
            }
        };
    }

    private void initializeDiscriminatorColumnPane(Composite container) {
        PropertyValueModel<DiscriminatorColumn> discriminatorColumnHolder = this.buildDiscriminatorColumnHolder();
        this.addLabeledComposite(container, JptUiMappingsMessages.DiscriminatorColumnComposite_name, this.addDiscriminatorColumnCombo(container, discriminatorColumnHolder), "org.eclipse.jpt.ui.entity_inheritanceDiscriminatorColumn");
        this.addLabeledComposite(container, JptUiMappingsMessages.DiscriminatorColumnComposite_discriminatorType, this.addDiscriminatorTypeCombo(container, discriminatorColumnHolder), "org.eclipse.jpt.ui.entity_inheritanceDiscriminatorType");
        container = this.addCollapsableSubSection(this.addSubPane(container, 10), JptUiMappingsMessages.InheritanceComposite_detailsGroupBox, (PropertyValueModel<Boolean>)new SimplePropertyValueModel((Object)Boolean.FALSE));
        Spinner lengthSpinner = this.addLabeledSpinner(container, JptUiMappingsMessages.ColumnComposite_length, this.buildLengthHolder(discriminatorColumnHolder), -1, -1, Integer.MAX_VALUE, this.addDefaultLengthLabel(container), "org.eclipse.jpt.ui.mapping_columnLength");
        this.updateGridData(container, lengthSpinner);
        this.addLabeledText(container, JptUiMappingsMessages.ColumnComposite_columnDefinition, this.buildColumnDefinitionHolder(discriminatorColumnHolder));
    }

    @Override
    protected void initializeLayout(Composite container) {
        int groupBoxMargin = this.getGroupBoxMargin();
        Composite subPane = this.addSubPane(container, 0, groupBoxMargin, 0, groupBoxMargin);
        this.addLabeledComposite(subPane, JptUiMappingsMessages.InheritanceComposite_strategy, this.addStrategyCombo(subPane), "org.eclipse.jpt.ui.entity_inheritanceStrategy");
        this.addLabeledEditableCCombo(subPane, JptUiMappingsMessages.InheritanceComposite_discriminatorValue, this.buildDiscriminatorValueListHolder(), this.buildDiscriminatorValueHolder(), this.buildDiscriminatorValueConverter(), "org.eclipse.jpt.ui.entity_inheritanceDiscriminatorValue");
        Group discriminatorColumnContainer = this.addTitledGroup(this.addSubPane(container, 10), JptUiMappingsMessages.InheritanceComposite_discriminatorColumnGroupBox);
        this.initializeDiscriminatorColumnPane((Composite)discriminatorColumnContainer);
        this.addPrimaryKeyJoinColumnsComposite(this.addSubPane(container, 5));
    }

    protected abstract void addPrimaryKeyJoinColumnsComposite(Composite var1);

    private void updateGridData(Composite container, Spinner spinner) {
        Composite paneContainer = spinner.getParent();
        while (container != paneContainer.getParent()) {
            paneContainer = paneContainer.getParent();
        }
        Control[] controls = paneContainer.getChildren();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        controls[1].setLayoutData((Object)gridData);
        controls[2].setLayoutData((Object)new GridData(768));
        this.removeAlignRight(controls[2]);
    }
}

