/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.SingleRelationshipMapping;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInRelationshipMappingDialog;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInRelationshipMappingStateObject;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinColumnComposite
extends FormPane<SingleRelationshipMapping> {
    private WritablePropertyValueModel<JoinColumn> joinColumnHolder;
    private WritablePropertyValueModel<Boolean> joinColumnPaneEnablerHolder;

    public JoinColumnComposite(FormPane<? extends SingleRelationshipMapping> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    public JoinColumnComposite(PropertyValueModel<? extends SingleRelationshipMapping> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    private void addJoinColumn() {
        JoinColumnInRelationshipMappingDialog dialog = new JoinColumnInRelationshipMappingDialog(this.getShell(), (RelationshipMapping)this.getSubject(), null);
        dialog.openDialog(this.buildAddJoinColumnPostExecution());
    }

    private void addJoinColumn(JoinColumnInRelationshipMappingStateObject stateObject) {
        SingleRelationshipMapping subject = (SingleRelationshipMapping)this.getSubject();
        int index = subject.specifiedJoinColumnsSize();
        JoinColumn joinColumn = subject.addSpecifiedJoinColumn(index);
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
    }

    private PostExecution<JoinColumnInRelationshipMappingDialog> buildAddJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInRelationshipMappingDialog>(){

            @Override
            public void execute(JoinColumnInRelationshipMappingDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoinColumnComposite.this.addJoinColumn((JoinColumnInRelationshipMappingStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    private PropertyValueModel<JoinColumn> buildDefaultJoinColumnHolder() {
        return new PropertyAspectAdapter<SingleRelationshipMapping, JoinColumn>(this.getSubjectHolder(), new String[]{"defaultJoinColumn"}){

            protected JoinColumn buildValue_() {
                return ((SingleRelationshipMapping)this.subject).getDefaultJoinColumn();
            }
        };
    }

    private ListValueModel<JoinColumn> buildDefaultJoinColumnListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultJoinColumnHolder());
    }

    private PostExecution<JoinColumnInRelationshipMappingDialog> buildEditJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInRelationshipMappingDialog>(){

            @Override
            public void execute(JoinColumnInRelationshipMappingDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoinColumnComposite.this.updateJoinColumn((JoinColumnInRelationshipMappingStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    private WritablePropertyValueModel<JoinColumn> buildJoinColumnHolder() {
        return new SimplePropertyValueModel();
    }

    private String buildJoinColumnLabel(JoinColumn joinColumn) {
        if (joinColumn.isVirtual()) {
            return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private WritablePropertyValueModel<Boolean> buildJoinColumnPaneEnablerHolder() {
        return new OverrideDefaultJoinColumnHolder();
    }

    private AddRemovePane.Adapter buildJoinColumnsAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                JoinColumnComposite.this.addJoinColumn();
            }

            @Override
            public boolean hasOptionalButton() {
                return true;
            }

            @Override
            public String optionalButtonText() {
                return JptUiMappingsMessages.JoinColumnComposite_edit;
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                JoinColumnComposite.this.editJoinColumn(listSelectionModel);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                JoinColumnComposite.this.removeJoinColumn(listSelectionModel);
            }
        };
    }

    private ListValueModel<JoinColumn> buildJoinColumnsListHolder() {
        ArrayList<ListValueModel<JoinColumn>> list = new ArrayList<ListValueModel<JoinColumn>>();
        list.add(this.buildSpecifiedJoinColumnsListHolder());
        list.add(this.buildDefaultJoinColumnListHolder());
        return new CompositeListValueModel(list);
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                JoinColumn joinColumn = (JoinColumn)element;
                return JoinColumnComposite.this.buildJoinColumnLabel(joinColumn);
            }
        };
    }

    private ListValueModel<JoinColumn> buildJoinColumnsListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildJoinColumnsListHolder(), new String[]{"specifiedName", "defaultName", "specifiedReferencedColumnName", "defaultReferencedColumnName"});
    }

    private WritablePropertyValueModel<Boolean> buildOverrideDefaultJoinColumnHolder() {
        return new OverrideDefaultJoinColumnHolder();
    }

    private ListValueModel<JoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<SingleRelationshipMapping, JoinColumn>(this.getSubjectHolder(), new String[]{"specifiedJoinColumnsList"}){

            protected ListIterator<JoinColumn> listIterator_() {
                return ((SingleRelationshipMapping)this.subject).specifiedJoinColumns();
            }

            protected int size_() {
                return ((SingleRelationshipMapping)this.subject).specifiedJoinColumnsSize();
            }
        };
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.updateJoinColumnPaneEnablement(true);
    }

    private void editJoinColumn(ObjectListSelectionModel listSelectionModel) {
        JoinColumn joinColumn = (JoinColumn)listSelectionModel.selectedValue();
        JoinColumnInRelationshipMappingDialog dialog = new JoinColumnInRelationshipMappingDialog(this.getShell(), (RelationshipMapping)this.getSubject(), joinColumn);
        dialog.openDialog(this.buildEditJoinColumnPostExecution());
    }

    @Override
    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        this.updateJoinColumnPaneEnablement(enabled);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.joinColumnHolder = this.buildJoinColumnHolder();
        this.joinColumnPaneEnablerHolder = this.buildJoinColumnPaneEnablerHolder();
    }

    @Override
    protected void initializeLayout(Composite container) {
        Group groupPane = this.addTitledGroup(container, JptUiMappingsMessages.JoinColumnComposite_joinColumn);
        this.addCheckBox(this.addSubPane((Composite)groupPane, 8), JptUiMappingsMessages.JoinColumnComposite_overrideDefaultJoinColumns, this.buildOverrideDefaultJoinColumnHolder(), null);
        AddRemoveListPane<SingleRelationshipMapping> joinColumnsListPane = new AddRemoveListPane<SingleRelationshipMapping>(this, (Composite)groupPane, this.buildJoinColumnsAdapter(), this.buildJoinColumnsListModel(), this.joinColumnHolder, this.buildJoinColumnsListLabelProvider(), "org.eclipse.jpt.ui.mapping_joinTableJoinColumns", false);
        this.installJoinColumnsListPaneEnabler(joinColumnsListPane);
    }

    private void installJoinColumnsListPaneEnabler(AddRemoveListPane<SingleRelationshipMapping> pane) {
        new PaneEnabler((PropertyValueModel<Boolean>)this.joinColumnPaneEnablerHolder, (Pane<?>)pane);
    }

    private void removeJoinColumn(ObjectListSelectionModel listSelectionModel) {
        int[] selectedIndices = listSelectionModel.selectedIndices();
        int index = selectedIndices.length;
        while (--index >= 0) {
            ((SingleRelationshipMapping)this.getSubject()).removeSpecifiedJoinColumn(selectedIndices[index]);
        }
    }

    private void updateJoinColumn(JoinColumnInRelationshipMappingStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    private void updateJoinColumnPaneEnablement(boolean enabled) {
        SingleRelationshipMapping subject = (SingleRelationshipMapping)this.getSubject();
        this.joinColumnPaneEnablerHolder.setValue((Object)(enabled &= subject != null && subject.containsSpecifiedJoinColumns()));
    }

    private void updateJoinColumns(boolean selected) {
        if (this.isPopulating()) {
            return;
        }
        this.setPopulating(true);
        try {
            SingleRelationshipMapping subject = (SingleRelationshipMapping)this.getSubject();
            if (selected) {
                JoinColumn defaultJoinColumn = subject.getDefaultJoinColumn();
                if (defaultJoinColumn != null) {
                    String columnName = defaultJoinColumn.getDefaultName();
                    String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
                    JoinColumn joinColumn = subject.addSpecifiedJoinColumn(0);
                    joinColumn.setSpecifiedName(columnName);
                    joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
                    this.joinColumnHolder.setValue((Object)joinColumn);
                }
            } else {
                int index = subject.specifiedJoinColumnsSize();
                while (--index >= 0) {
                    subject.removeSpecifiedJoinColumn(index);
                }
            }
            this.updateJoinColumnPaneEnablement(selected);
        }
        finally {
            this.setPopulating(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrideDefaultJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements WritablePropertyValueModel<Boolean> {
        public OverrideDefaultJoinColumnHolder() {
            super(JoinColumnComposite.this.buildSpecifiedJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            if (this.listHolder.size() > 0) {
                return true;
            }
            return false;
        }

        public void setValue(Boolean value) {
            JoinColumnComposite.this.updateJoinColumns(value);
        }
    }
}

