/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.db.TableCombo;
import org.eclipse.jpt.ui.internal.mappings.details.InverseJoinColumnInJoinTableDialog;
import org.eclipse.jpt.ui.internal.mappings.details.InverseJoinColumnInJoinTableStateObject;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInJoinTableDialog;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInJoinTableStateObject;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnsComposite;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTableComposite
extends FormPane<JoinTable> {
    private WritablePropertyValueModel<Boolean> inverseJoinColumnsPaneEnablerHolder;
    private WritablePropertyValueModel<Boolean> joinColumnsPaneEnablerHolder;
    private Button overrideDefaultInverseJoinColumnsCheckBox;
    private Button overrideDefaultJoinColumnsCheckBox;

    public JoinTableComposite(FormPane<?> parentPane, PropertyValueModel<? extends JoinTable> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent, false);
    }

    public JoinTableComposite(PropertyValueModel<? extends JoinTable> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.joinColumnsPaneEnablerHolder = this.buildJoinColumnsPaneEnablerHolder();
        this.inverseJoinColumnsPaneEnablerHolder = this.buildInverseJoinColumnsPaneEnablerHolder();
    }

    private WritablePropertyValueModel<Boolean> buildInverseJoinColumnsPaneEnablerHolder() {
        return new OverrideDefaultInverseJoinColumnHolder();
    }

    private WritablePropertyValueModel<Boolean> buildJoinColumnsPaneEnablerHolder() {
        return new OverrideDefaultJoinColumnHolder();
    }

    @Override
    protected void initializeLayout(Composite container) {
        int groupBoxMargin = this.getGroupBoxMargin();
        TableCombo<JoinTable> tableCombo = this.addTableCombo(container);
        this.addLabeledComposite(this.addPane(container, groupBoxMargin), JptUiMappingsMessages.JoinTableComposite_name, (Control)tableCombo.getControl(), "org.eclipse.jpt.ui.mapping_joinTableName");
        Group joinColumnGroupPane = this.addTitledGroup(container, JptUiMappingsMessages.JoinTableComposite_joinColumn);
        this.overrideDefaultJoinColumnsCheckBox = this.addCheckBox(this.addSubPane((Composite)joinColumnGroupPane, 8), JptUiMappingsMessages.JoinTableComposite_overrideDefaultJoinColumns, this.buildOverrideDefaultJoinColumnHolder(), null);
        this.overrideDefaultJoinColumnsCheckBox.addSelectionListener(this.buildOverrideDefaultSelectionListener());
        JoinColumnsComposite<JoinTable> joinColumnsComposite = new JoinColumnsComposite<JoinTable>(this, (Composite)joinColumnGroupPane, this.buildJoinColumnsEditor());
        this.installJoinColumnsPaneEnabler(joinColumnsComposite);
        Group inverseJoinColumnGroupPane = this.addTitledGroup(container, JptUiMappingsMessages.JoinTableComposite_inverseJoinColumn);
        this.overrideDefaultInverseJoinColumnsCheckBox = this.addCheckBox(this.addSubPane((Composite)inverseJoinColumnGroupPane, 8), JptUiMappingsMessages.JoinTableComposite_overrideDefaultInverseJoinColumns, this.buildOverrideDefaultInverseJoinColumnHolder(), null);
        this.overrideDefaultInverseJoinColumnsCheckBox.addSelectionListener(this.buildOverrideDefaultInverseSelectionListener());
        JoinColumnsComposite<JoinTable> inverseJoinColumnsComposite = new JoinColumnsComposite<JoinTable>(this, (Composite)inverseJoinColumnGroupPane, this.buildInverseJoinColumnsEditor());
        this.installInverseJoinColumnsPaneEnabler(inverseJoinColumnsComposite);
    }

    private void installInverseJoinColumnsPaneEnabler(JoinColumnsComposite<JoinTable> pane) {
        pane.installJoinColumnsPaneEnabler(this.inverseJoinColumnsPaneEnablerHolder);
    }

    private void installJoinColumnsPaneEnabler(JoinColumnsComposite<JoinTable> pane) {
        pane.installJoinColumnsPaneEnabler(this.joinColumnsPaneEnablerHolder);
    }

    private void addInverseJoinColumn(JoinTable joinTable) {
        InverseJoinColumnInJoinTableDialog dialog = new InverseJoinColumnInJoinTableDialog(this.getShell(), joinTable, null);
        dialog.openDialog(this.buildAddInverseJoinColumnPostExecution());
    }

    private void addInverseJoinColumnFromDialog(InverseJoinColumnInJoinTableStateObject stateObject) {
        JoinTable subject = (JoinTable)this.getSubject();
        int index = subject.specifiedInverseJoinColumnsSize();
        JoinColumn joinColumn = subject.addSpecifiedInverseJoinColumn(index);
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
    }

    private void addJoinColumn(JoinTable joinTable) {
        JoinColumnInJoinTableDialog dialog = new JoinColumnInJoinTableDialog(this.getShell(), joinTable, null);
        dialog.openDialog(this.buildAddJoinColumnPostExecution());
    }

    private void addJoinColumnFromDialog(JoinColumnInJoinTableStateObject stateObject) {
        JoinTable subject = (JoinTable)this.getSubject();
        int index = subject.specifiedJoinColumnsSize();
        JoinColumn joinColumn = ((JoinTable)this.getSubject()).addSpecifiedJoinColumn(index);
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
    }

    private PostExecution<InverseJoinColumnInJoinTableDialog> buildAddInverseJoinColumnPostExecution() {
        return new PostExecution<InverseJoinColumnInJoinTableDialog>(){

            @Override
            public void execute(InverseJoinColumnInJoinTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoinTableComposite.this.addInverseJoinColumnFromDialog((InverseJoinColumnInJoinTableStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    private PostExecution<JoinColumnInJoinTableDialog> buildAddJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInJoinTableDialog>(){

            @Override
            public void execute(JoinColumnInJoinTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoinTableComposite.this.addJoinColumnFromDialog((JoinColumnInJoinTableStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    private PostExecution<InverseJoinColumnInJoinTableDialog> buildEditInverseJoinColumnPostExecution() {
        return new PostExecution<InverseJoinColumnInJoinTableDialog>(){

            @Override
            public void execute(InverseJoinColumnInJoinTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoinTableComposite.this.editInverseJoinColumn((InverseJoinColumnInJoinTableStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    private PostExecution<JoinColumnInJoinTableDialog> buildEditJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInJoinTableDialog>(){

            @Override
            public void execute(JoinColumnInJoinTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoinTableComposite.this.editJoinColumn((JoinColumnInJoinTableStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    private InverseJoinColumnsProvider buildInverseJoinColumnsEditor() {
        return new InverseJoinColumnsProvider();
    }

    private JoinColumnsProvider buildJoinColumnsEditor() {
        return new JoinColumnsProvider();
    }

    private WritablePropertyValueModel<Boolean> buildOverrideDefaultJoinColumnHolder() {
        return new OverrideDefaultJoinColumnHolder();
    }

    private WritablePropertyValueModel<Boolean> buildOverrideDefaultInverseJoinColumnHolder() {
        return new OverrideDefaultInverseJoinColumnHolder();
    }

    private ListValueModel<JoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<JoinTable, JoinColumn>(this.getSubjectHolder(), new String[]{"specifiedJoinColumnsList"}){

            protected ListIterator<JoinColumn> listIterator_() {
                return ((JoinTable)this.subject).specifiedJoinColumns();
            }

            protected int size_() {
                return ((JoinTable)this.subject).specifiedJoinColumnsSize();
            }
        };
    }

    private ListValueModel<JoinColumn> buildSpecifiedInverseJoinColumnsListHolder() {
        return new ListAspectAdapter<JoinTable, JoinColumn>(this.getSubjectHolder(), new String[]{"specifiedInverseJoinColumnsList"}){

            protected ListIterator<JoinColumn> listIterator_() {
                return ((JoinTable)this.subject).specifiedInverseJoinColumns();
            }

            protected int size_() {
                return ((JoinTable)this.subject).specifiedInverseJoinColumnsSize();
            }
        };
    }

    private SelectionListener buildOverrideDefaultInverseSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.updateInverseJoinColumns();
            }
        };
    }

    private SelectionListener buildOverrideDefaultSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JoinTableComposite.this.updateJoinColumns();
            }
        };
    }

    private Composite addPane(Composite container, int groupBoxMargin) {
        return this.addSubPane(container, 0, groupBoxMargin, 10, groupBoxMargin);
    }

    private TableCombo<JoinTable> addTableCombo(Composite container) {
        return new TableCombo<JoinTable>((Pane)this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultName");
                propertyNames.add("specifiedName");
                propertyNames.add("defaultSchema");
                propertyNames.add("specifiedSchema");
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            @Override
            protected void propertyChanged(String propertyName) {
                super.propertyChanged(propertyName);
                if (propertyName == "defaultSchema" || propertyName == "specifiedSchema" || propertyName == "defaultCatalog" || propertyName == "specifiedCatalog") {
                    this.repopulate();
                }
            }

            @Override
            protected String getDefaultValue() {
                return ((JoinTable)this.getSubject()).getDefaultName();
            }

            @Override
            protected void setValue(String value) {
                ((JoinTable)this.getSubject()).setSpecifiedName(value);
            }

            @Override
            protected String getValue() {
                return ((JoinTable)this.getSubject()).getSpecifiedName();
            }

            @Override
            protected Schema getDbSchema_() {
                return ((JoinTable)this.getSubject()).getDbSchema();
            }
        };
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.updateJoinColumnPanesEnablement(true);
    }

    private void editInverseJoinColumn(InverseJoinColumnInJoinTableStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    private void editInverseJoinColumn(JoinColumn joinColumn) {
        InverseJoinColumnInJoinTableDialog dialog = new InverseJoinColumnInJoinTableDialog(this.getShell(), (JoinTable)this.getSubject(), joinColumn);
        dialog.openDialog(this.buildEditInverseJoinColumnPostExecution());
    }

    private void editJoinColumn(JoinColumn joinColumn) {
        JoinColumnInJoinTableDialog dialog = new JoinColumnInJoinTableDialog(this.getShell(), (JoinTable)this.getSubject(), joinColumn);
        dialog.openDialog(this.buildEditJoinColumnPostExecution());
    }

    private void editJoinColumn(JoinColumnInJoinTableStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    @Override
    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        this.updateJoinColumnPanesEnablement(enabled);
    }

    private void updateInverseJoinColumns() {
        if (this.isPopulating()) {
            return;
        }
        JoinTable joinTable = (JoinTable)this.getSubject();
        boolean selected = this.overrideDefaultInverseJoinColumnsCheckBox.getSelection();
        this.setPopulating(true);
        try {
            if (selected) {
                JoinColumn defaultJoinColumn = joinTable.getDefaultInverseJoinColumn();
                if (defaultJoinColumn != null) {
                    String columnName = defaultJoinColumn.getDefaultName();
                    String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
                    JoinColumn joinColumn = joinTable.addSpecifiedInverseJoinColumn(0);
                    joinColumn.setSpecifiedName(columnName);
                    joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
                }
            } else {
                int index = joinTable.specifiedInverseJoinColumnsSize();
                while (--index >= 0) {
                    joinTable.removeSpecifiedInverseJoinColumn(index);
                }
            }
            this.inverseJoinColumnsPaneEnablerHolder.setValue((Object)selected);
        }
        finally {
            this.setPopulating(false);
        }
    }

    private void updateJoinColumnPanesEnablement(boolean globalEnablement) {
        JoinTable subject = (JoinTable)this.getSubject();
        boolean enabled = globalEnablement && subject != null && subject.containsSpecifiedJoinColumns();
        boolean inverseEnabled = globalEnablement && subject != null && subject.containsSpecifiedInverseJoinColumns();
        this.overrideDefaultJoinColumnsCheckBox.setSelection(enabled);
        this.overrideDefaultInverseJoinColumnsCheckBox.setSelection(inverseEnabled);
        this.joinColumnsPaneEnablerHolder.setValue((Object)enabled);
        this.inverseJoinColumnsPaneEnablerHolder.setValue((Object)inverseEnabled);
    }

    private void updateJoinColumns() {
        if (this.isPopulating()) {
            return;
        }
        JoinTable joinTable = (JoinTable)this.getSubject();
        boolean selected = this.overrideDefaultJoinColumnsCheckBox.getSelection();
        this.setPopulating(true);
        try {
            if (selected) {
                JoinColumn defaultJoinColumn = joinTable.getDefaultJoinColumn();
                if (defaultJoinColumn != null) {
                    String columnName = defaultJoinColumn.getDefaultName();
                    String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
                    JoinColumn joinColumn = joinTable.addSpecifiedJoinColumn(0);
                    joinColumn.setSpecifiedName(columnName);
                    joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
                }
            } else {
                int index = joinTable.specifiedJoinColumnsSize();
                while (--index >= 0) {
                    joinTable.removeSpecifiedJoinColumn(index);
                }
            }
            this.joinColumnsPaneEnablerHolder.setValue((Object)selected);
        }
        finally {
            this.setPopulating(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InverseJoinColumnsProvider
    implements JoinColumnsComposite.IJoinColumnsEditor<JoinTable> {
        private InverseJoinColumnsProvider() {
        }

        @Override
        public void addJoinColumn(JoinTable subject) {
            JoinTableComposite.this.addInverseJoinColumn(subject);
        }

        @Override
        public JoinColumn defaultJoinColumn(JoinTable subject) {
            return subject.getDefaultInverseJoinColumn();
        }

        @Override
        public String defaultPropertyName() {
            return "defaultInverseJoinColumn";
        }

        @Override
        public void editJoinColumn(JoinTable subject, JoinColumn joinColumn) {
            JoinTableComposite.this.editInverseJoinColumn(joinColumn);
        }

        @Override
        public boolean hasSpecifiedJoinColumns(JoinTable subject) {
            return subject.containsSpecifiedInverseJoinColumns();
        }

        @Override
        public void removeJoinColumns(JoinTable subject, int[] selectedIndices) {
            int index = selectedIndices.length;
            while (--index >= 0) {
                subject.removeSpecifiedInverseJoinColumn(selectedIndices[index]);
            }
        }

        @Override
        public ListIterator<JoinColumn> specifiedJoinColumns(JoinTable subject) {
            return subject.specifiedInverseJoinColumns();
        }

        @Override
        public int specifiedJoinColumnsSize(JoinTable subject) {
            return subject.specifiedInverseJoinColumnsSize();
        }

        @Override
        public String specifiedListPropertyName() {
            return "specifiedInverseJoinColumnsList";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinColumnsProvider
    implements JoinColumnsComposite.IJoinColumnsEditor<JoinTable> {
        private JoinColumnsProvider() {
        }

        @Override
        public void addJoinColumn(JoinTable subject) {
            JoinTableComposite.this.addJoinColumn(subject);
        }

        @Override
        public JoinColumn defaultJoinColumn(JoinTable subject) {
            return subject.getDefaultJoinColumn();
        }

        @Override
        public String defaultPropertyName() {
            return "defaultJoinColumn";
        }

        @Override
        public void editJoinColumn(JoinTable subject, JoinColumn joinColumn) {
            JoinTableComposite.this.editJoinColumn(joinColumn);
        }

        @Override
        public boolean hasSpecifiedJoinColumns(JoinTable subject) {
            return subject.containsSpecifiedJoinColumns();
        }

        @Override
        public void removeJoinColumns(JoinTable subject, int[] selectedIndices) {
            int index = selectedIndices.length;
            while (--index >= 0) {
                subject.removeSpecifiedJoinColumn(selectedIndices[index]);
            }
        }

        @Override
        public ListIterator<JoinColumn> specifiedJoinColumns(JoinTable subject) {
            return subject.specifiedJoinColumns();
        }

        @Override
        public int specifiedJoinColumnsSize(JoinTable subject) {
            return subject.specifiedJoinColumnsSize();
        }

        @Override
        public String specifiedListPropertyName() {
            return "specifiedJoinColumnsList";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrideDefaultInverseJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements WritablePropertyValueModel<Boolean> {
        public OverrideDefaultInverseJoinColumnHolder() {
            super(JoinTableComposite.this.buildSpecifiedInverseJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            if (this.listHolder.size() > 0) {
                return true;
            }
            return false;
        }

        public void setValue(Boolean value) {
            JoinTableComposite.this.updateInverseJoinColumns();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrideDefaultJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements WritablePropertyValueModel<Boolean> {
        public OverrideDefaultJoinColumnHolder() {
            super(JoinTableComposite.this.buildSpecifiedJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            if (this.listHolder.size() > 0) {
                return true;
            }
            return false;
        }

        public void setValue(Boolean value) {
            JoinTableComposite.this.updateJoinColumns();
        }
    }
}

