/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.ColumnComposite;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInAssociationOverrideDialog;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInAssociationOverrideStateObject;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnsComposite;
import org.eclipse.jpt.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.model.value.CachingTransformationWritablePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationWritablePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverridesComposite
extends FormPane<Entity> {
    private Composite columnPane;
    private Composite joinColumnsPane;
    private WritablePropertyValueModel<BaseOverride> selectedOverrideHolder;
    private WritablePropertyValueModel<Boolean> overrideVirtualAttributeOverrideHolder;
    private WritablePropertyValueModel<Boolean> overrideVirtualAssociationOverrideHolder;

    public OverridesComposite(FormPane<? extends Entity> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    public OverridesComposite(PropertyValueModel<? extends Entity> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.selectedOverrideHolder = this.buildSelectedOverrideHolder();
    }

    private WritablePropertyValueModel<BaseOverride> buildSelectedOverrideHolder() {
        return new SimplePropertyValueModel();
    }

    @Override
    protected void initializeLayout(Composite container) {
        container = this.addTitledGroup(container, JptUiMappingsMessages.AttributeOverridesComposite_attributeOverridesGroup);
        this.initializeOverridesList(container);
        PageBook pageBook = this.addPageBook(container);
        this.initializeJoinColumnsPane(pageBook);
        this.initializeColumnPane(pageBook);
        this.installOverrideControlSwitcher((PropertyValueModel<BaseOverride>)this.selectedOverrideHolder, pageBook);
    }

    private AddRemoveListPane<Entity> initializeOverridesList(Composite container) {
        return new AddRemoveListPane<Entity>((Pane)this, this.addSubPane(container, 8), this.buildOverridesAdapter(), this.buildOverridesListModel(), this.selectedOverrideHolder, this.buildOverrideLabelProvider(), "org.eclipse.jpt.ui.entity_attributeOverrides"){

            @Override
            protected void initializeButtonPane(Composite container, String helpId) {
            }

            @Override
            protected void updateButtons() {
            }
        };
    }

    private void initializeColumnPane(PageBook pageBook) {
        int groupBoxMargin = this.getGroupBoxMargin();
        this.columnPane = this.addSubPane((Composite)pageBook, 5);
        this.addCheckBox(this.addSubPane(this.columnPane, 0, groupBoxMargin, 0, groupBoxMargin), JptUiMappingsMessages.AttributeOverridesComposite_overrideDefault, this.getOverrideVirtualAttributeOverrideHolder(), null);
        ColumnComposite columnComposite = new ColumnComposite((FormPane<?>)this, (PropertyValueModel<? extends Column>)this.buildColumnHolder((PropertyValueModel<AttributeOverride>)this.buildAttributeOverrideHolder()), this.columnPane, false);
        this.columnPane.setVisible(false);
        this.installColumnsPaneEnabler(columnComposite);
    }

    private void installColumnsPaneEnabler(ColumnComposite pane) {
        new PaneEnabler((PropertyValueModel<Boolean>)this.getOverrideVirtualAttributeOverrideHolder(), (Pane<?>)pane);
    }

    private void initializeJoinColumnsPane(PageBook pageBook) {
        this.joinColumnsPane = this.addSubPane((Composite)pageBook);
        this.addCheckBox(this.addSubPane(this.joinColumnsPane, 5, this.getGroupBoxMargin()), JptUiMappingsMessages.AttributeOverridesComposite_overrideDefault, this.getOverrideVirtualAssociationOverrideHolder(), null);
        Group joinColumnsGroupPane = this.addTitledGroup(this.joinColumnsPane, JptUiMappingsMessages.OverridesComposite_joinColumn);
        JoinColumnsComposite<AssociationOverride> joinColumnsComposite = new JoinColumnsComposite<AssociationOverride>((FormPane<?>)this, (PropertyValueModel<AssociationOverride>)this.buildAssociationOverrideHolder(), (Composite)joinColumnsGroupPane, this.buildJoinColumnsEditor(), false);
        this.joinColumnsPane.setVisible(false);
        this.installJoinColumnsPaneEnabler(joinColumnsComposite);
    }

    private void installJoinColumnsPaneEnabler(JoinColumnsComposite<AssociationOverride> pane) {
        new PaneEnabler((PropertyValueModel<Boolean>)this.getOverrideVirtualAssociationOverrideHolder(), (Pane<?>)pane);
    }

    private void installOverrideControlSwitcher(PropertyValueModel<BaseOverride> overrideHolder, PageBook pageBook) {
        new ControlSwitcher(overrideHolder, this.buildPaneTransformer(), pageBook);
    }

    private void addJoinColumn(AssociationOverride subject) {
        JoinColumnInAssociationOverrideDialog dialog = new JoinColumnInAssociationOverrideDialog(this.getShell(), subject, null);
        dialog.openDialog(this.buildAddJoinColumnPostExecution());
    }

    private PostExecution<JoinColumnInAssociationOverrideDialog> buildAddJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInAssociationOverrideDialog>(){

            @Override
            public void execute(JoinColumnInAssociationOverrideDialog dialog) {
                if (dialog.wasConfirmed()) {
                    OverridesComposite.this.addJoinColumn((JoinColumnInAssociationOverrideStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    private void addJoinColumn(JoinColumnInAssociationOverrideStateObject stateObject) {
        AssociationOverride associationOverride = stateObject.getOwner();
        int index = associationOverride.specifiedJoinColumnsSize();
        JoinColumn joinColumn = associationOverride.addSpecifiedJoinColumn(index);
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
    }

    private WritablePropertyValueModel<AssociationOverride> buildAssociationOverrideHolder() {
        return new TransformationWritablePropertyValueModel<BaseOverride, AssociationOverride>(this.selectedOverrideHolder){

            protected AssociationOverride transform_(BaseOverride value) {
                return value instanceof AssociationOverride ? (AssociationOverride)value : null;
            }
        };
    }

    private WritablePropertyValueModel<AttributeOverride> buildAttributeOverrideHolder() {
        return new TransformationWritablePropertyValueModel<BaseOverride, AttributeOverride>(this.selectedOverrideHolder){

            protected AttributeOverride transform_(BaseOverride value) {
                return value instanceof AttributeOverride ? (AttributeOverride)value : null;
            }
        };
    }

    private PropertyValueModel<Column> buildColumnHolder(PropertyValueModel<AttributeOverride> attributeOverrideHolder) {
        return new TransformationPropertyValueModel<AttributeOverride, Column>(attributeOverrideHolder){

            protected Column transform_(AttributeOverride value) {
                return value.getColumn();
            }
        };
    }

    private ListValueModel<AssociationOverride> buildDefaultAssociationOverridesListHolder() {
        return new ListAspectAdapter<Entity, AssociationOverride>(this.getSubjectHolder(), new String[]{"virtualAssociationOverrides"}){

            protected ListIterator<AssociationOverride> listIterator_() {
                return ((Entity)this.subject).virtualAssociationOverrides();
            }

            protected int size_() {
                return ((Entity)this.subject).virtualAssociationOverridesSize();
            }
        };
    }

    private ListValueModel<AttributeOverride> buildDefaultAttributeOverridesListHolder() {
        return new ListAspectAdapter<Entity, AttributeOverride>(this.getSubjectHolder(), new String[]{"virtualAttributeOverrides"}){

            protected ListIterator<AttributeOverride> listIterator_() {
                return ((Entity)this.subject).virtualAttributeOverrides();
            }

            protected int size_() {
                return ((Entity)this.subject).virtualAttributeOverridesSize();
            }
        };
    }

    private PostExecution<JoinColumnInAssociationOverrideDialog> buildEditJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInAssociationOverrideDialog>(){

            @Override
            public void execute(JoinColumnInAssociationOverrideDialog dialog) {
                if (dialog.wasConfirmed()) {
                    OverridesComposite.this.editJoinColumn((JoinColumnInAssociationOverrideStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    private JoinColumnsProvider buildJoinColumnsEditor() {
        return new JoinColumnsProvider();
    }

    protected WritablePropertyValueModel<Boolean> getOverrideVirtualAssociationOverrideHolder() {
        if (this.overrideVirtualAssociationOverrideHolder == null) {
            this.overrideVirtualAssociationOverrideHolder = this.buildOverrideVirtualAssociationOverrideHolder();
        }
        return this.overrideVirtualAssociationOverrideHolder;
    }

    private WritablePropertyValueModel<Boolean> buildOverrideVirtualAssociationOverrideHolder() {
        return new CachingTransformationWritablePropertyValueModel<AssociationOverride, Boolean>(this.buildAssociationOverrideHolder()){

            public void setValue(Boolean value) {
                OverridesComposite.this.updateOverride(value);
            }

            protected Boolean transform_(AssociationOverride value) {
                return !value.isVirtual();
            }
        };
    }

    protected WritablePropertyValueModel<Boolean> getOverrideVirtualAttributeOverrideHolder() {
        if (this.overrideVirtualAttributeOverrideHolder == null) {
            this.overrideVirtualAttributeOverrideHolder = this.buildOverrideVirtualAttributeOverrideHolder();
        }
        return this.overrideVirtualAttributeOverrideHolder;
    }

    private WritablePropertyValueModel<Boolean> buildOverrideVirtualAttributeOverrideHolder() {
        return new CachingTransformationWritablePropertyValueModel<AttributeOverride, Boolean>(this.buildAttributeOverrideHolder()){

            public void setValue(Boolean value) {
                OverridesComposite.this.updateOverride(value);
            }

            protected Boolean transform_(AttributeOverride value) {
                return !value.isVirtual();
            }
        };
    }

    private String buildOverrideDisplayString(BaseOverride override) {
        String overrideType = override instanceof AssociationOverride ? JptUiMappingsMessages.OverridesComposite_association : JptUiMappingsMessages.OverridesComposite_attribute;
        String name = override.getName();
        if (StringTools.stringIsEmpty((String)name)) {
            name = JptUiMappingsMessages.OverridesComposite_noName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(" (");
        sb.append(overrideType);
        sb.append(") ");
        return sb.toString();
    }

    private ILabelProvider buildOverrideLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return OverridesComposite.this.buildOverrideDisplayString((BaseOverride)element);
            }
        };
    }

    private AddRemovePane.Adapter buildOverridesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
            }
        };
    }

    private ListValueModel<BaseOverride> buildOverridesListHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildSpecifiedAttributeOverridesListHolder());
        list.add(this.buildDefaultAttributeOverridesListHolder());
        list.add(this.buildSpecifiedAssociationOverridesListHolder());
        list.add(this.buildDefaultAssociationOverridesListHolder());
        return new CompositeListValueModel(list);
    }

    private ListValueModel<BaseOverride> buildOverridesListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildOverridesListHolder(), new String[]{"nameProperty"});
    }

    private Transformer<BaseOverride, Control> buildPaneTransformer() {
        return new Transformer<BaseOverride, Control>(){

            public Control transform(BaseOverride override) {
                if (override instanceof AttributeOverride) {
                    return OverridesComposite.this.columnPane;
                }
                if (override instanceof AssociationOverride) {
                    return OverridesComposite.this.joinColumnsPane;
                }
                return null;
            }
        };
    }

    private ListValueModel<AssociationOverride> buildSpecifiedAssociationOverridesListHolder() {
        return new ListAspectAdapter<Entity, AssociationOverride>(this.getSubjectHolder(), new String[]{"specifiedAssociationOverrides"}){

            protected ListIterator<AssociationOverride> listIterator_() {
                return ((Entity)this.subject).specifiedAssociationOverrides();
            }

            protected int size_() {
                return ((Entity)this.subject).specifiedAssociationOverridesSize();
            }
        };
    }

    private ListValueModel<AttributeOverride> buildSpecifiedAttributeOverridesListHolder() {
        return new ListAspectAdapter<Entity, AttributeOverride>(this.getSubjectHolder(), new String[]{"specifiedAttributeOverrides"}){

            protected ListIterator<AttributeOverride> listIterator_() {
                return ((Entity)this.subject).specifiedAttributeOverrides();
            }

            protected int size_() {
                return ((Entity)this.subject).specifiedAttributeOverridesSize();
            }
        };
    }

    private void editJoinColumn(JoinColumn joinColumn) {
        JoinColumnInAssociationOverrideDialog dialog = new JoinColumnInAssociationOverrideDialog(this.getShell(), (AssociationOverride)this.selectedOverrideHolder.getValue(), joinColumn);
        dialog.openDialog(this.buildEditJoinColumnPostExecution());
    }

    private void editJoinColumn(JoinColumnInAssociationOverrideStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    private void updateOverride(boolean selected) {
        if (this.isPopulating()) {
            return;
        }
        this.setPopulating(true);
        try {
            BaseOverride override = (BaseOverride)this.selectedOverrideHolder.getValue();
            BaseOverride newOverride = override.setVirtual(!selected);
            this.selectedOverrideHolder.setValue((Object)newOverride);
        }
        finally {
            this.setPopulating(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinColumnsProvider
    implements JoinColumnsComposite.IJoinColumnsEditor<AssociationOverride> {
        private JoinColumnsProvider() {
        }

        @Override
        public void addJoinColumn(AssociationOverride subject) {
            OverridesComposite.this.addJoinColumn(subject);
        }

        @Override
        public JoinColumn defaultJoinColumn(AssociationOverride subject) {
            return null;
        }

        @Override
        public String defaultPropertyName() {
            return "defaultJoinColumnsList";
        }

        @Override
        public void editJoinColumn(AssociationOverride subject, JoinColumn joinColumn) {
            OverridesComposite.this.editJoinColumn(joinColumn);
        }

        @Override
        public boolean hasSpecifiedJoinColumns(AssociationOverride subject) {
            return subject.containsSpecifiedJoinColumns();
        }

        @Override
        public void removeJoinColumns(AssociationOverride subject, int[] selectedIndices) {
            int index = selectedIndices.length;
            while (--index >= 0) {
                subject.removeSpecifiedJoinColumn(selectedIndices[index]);
            }
        }

        @Override
        public ListIterator<JoinColumn> specifiedJoinColumns(AssociationOverride subject) {
            return subject.specifiedJoinColumns();
        }

        @Override
        public int specifiedJoinColumnsSize(AssociationOverride subject) {
            return subject.specifiedJoinColumnsSize();
        }

        @Override
        public String specifiedListPropertyName() {
            return "specifiedJoinColumnsList";
        }
    }
}

