/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.details.AttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.DefaultAttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.DefaultMappingUiProvider;
import org.eclipse.jpt.ui.details.MappingUiProvider;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.MapAsComposite;
import org.eclipse.jpt.ui.internal.platform.JpaPlatformUiRegistry;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistentAttributeMapAsComposite<T extends PersistentAttribute>
extends MapAsComposite<T> {
    public PersistentAttributeMapAsComposite(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    @Override
    protected void addPropertyNames(Collection<String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.add("defaultMappingProperty");
        propertyNames.add("specifiedMappingProperty");
        propertyNames.add("nameProperty");
    }

    protected abstract Iterator<AttributeMappingUiProvider<? extends AttributeMapping>> attributeMappingUiProviders();

    @Override
    protected DefaultMappingUiProvider<?> getDefaultProvider() {
        String mappingKey = ((PersistentAttribute)this.getSubject()).getDefaultMappingKey();
        if (mappingKey == null) {
            return null;
        }
        return this.getDefaultProvider(mappingKey);
    }

    @Override
    protected MapAsComposite.MappingChangeHandler buildMappingChangeHandler() {
        return new MapAsComposite.MappingChangeHandler(){

            @Override
            public String getLabelText() {
                String mappingKey = ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getMappingKey();
                if (mappingKey != MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
                    return JptUiMappingsMessages.MapAsComposite_mappedAttributeText;
                }
                if (((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).isVirtual()) {
                    return JptUiMappingsMessages.MapAsComposite_virtualAttributeText;
                }
                return JptUiMappingsMessages.MapAsComposite_unmappedAttributeText;
            }

            @Override
            public String getMappingText() {
                String mappingKey = ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getMappingKey();
                if (mappingKey == null) {
                    return JptUiMappingsMessages.MapAsComposite_changeMappingType;
                }
                if (((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getSpecifiedMapping() == null) {
                    return PersistentAttributeMapAsComposite.this.getDefaultProvider(((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getDefaultMappingKey()).getLinkLabel();
                }
                return PersistentAttributeMapAsComposite.this.getProvider(mappingKey).getLinkLabel();
            }

            @Override
            public void morphMapping(MappingUiProvider<?> provider) {
                ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).setSpecifiedMappingKey(provider.getMappingKey());
            }

            @Override
            public String getName() {
                return ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getName();
            }

            @Override
            public Iterator<? extends MappingUiProvider<?>> providers() {
                return PersistentAttributeMapAsComposite.this.attributeMappingUiProviders();
            }

            @Override
            public Iterator<? extends DefaultMappingUiProvider<?>> defaultProviders() {
                return PersistentAttributeMapAsComposite.this.defaultAttributeMappingUiProviders();
            }
        };
    }

    protected abstract Iterator<DefaultAttributeMappingUiProvider<? extends AttributeMapping>> defaultAttributeMappingUiProviders();

    protected JpaPlatformUi getJpaPlatformUi() {
        String platformId = ((PersistentAttribute)this.getSubject()).getJpaProject().getJpaPlatform().getId();
        return JpaPlatformUiRegistry.instance().getJpaPlatformUi(platformId);
    }

    @Override
    protected String getMappingKey() {
        return ((PersistentAttribute)this.getSubject()).getMappingKey();
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        if (propertyName == "specifiedMappingProperty" || propertyName == "defaultMappingProperty" || propertyName == "nameProperty") {
            this.updateDescription();
        }
    }
}

