/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.PrimaryKeyJoinColumnInSecondaryTableDialog;
import org.eclipse.jpt.ui.internal.mappings.details.PrimaryKeyJoinColumnInSecondaryTableStateObject;
import org.eclipse.jpt.ui.internal.util.ControlEnabler;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryKeyJoinColumnsInSecondaryTableComposite
extends FormPane<SecondaryTable> {
    private WritablePropertyValueModel<PrimaryKeyJoinColumn> joinColumnHolder;

    public PrimaryKeyJoinColumnsInSecondaryTableComposite(FormPane<?> parentPane, PropertyValueModel<? extends SecondaryTable> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    public PrimaryKeyJoinColumnsInSecondaryTableComposite(PropertyValueModel<? extends SecondaryTable> subjectHolder, Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(subjectHolder, parent, (FormToolkit)widgetFactory);
    }

    private void addJoinColumn(PrimaryKeyJoinColumnInSecondaryTableStateObject stateObject) {
        SecondaryTable secondaryTable = stateObject.getOwner();
        int index = secondaryTable.specifiedPrimaryKeyJoinColumnsSize();
        PrimaryKeyJoinColumn joinColumn = secondaryTable.addSpecifiedPrimaryKeyJoinColumn(index);
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
    }

    private void addPrimaryKeyJoinColumn() {
        PrimaryKeyJoinColumnInSecondaryTableDialog dialog = new PrimaryKeyJoinColumnInSecondaryTableDialog(this.getShell(), (SecondaryTable)this.getSubject(), null);
        dialog.openDialog(this.buildAddPrimaryKeyJoinColumnPostExecution());
    }

    private PostExecution<PrimaryKeyJoinColumnInSecondaryTableDialog> buildAddPrimaryKeyJoinColumnPostExecution() {
        return new PostExecution<PrimaryKeyJoinColumnInSecondaryTableDialog>(){

            @Override
            public void execute(PrimaryKeyJoinColumnInSecondaryTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    PrimaryKeyJoinColumnsInSecondaryTableComposite.this.addJoinColumn((PrimaryKeyJoinColumnInSecondaryTableStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    private PropertyValueModel<Boolean> buildControlBooleanHolder() {
        return new TransformationPropertyValueModel<SecondaryTable, Boolean>(this.getSubjectHolder()){

            protected Boolean transform(SecondaryTable value) {
                if (value == null) {
                    return Boolean.FALSE;
                }
                return !value.isVirtual();
            }
        };
    }

    private PropertyValueModel<PrimaryKeyJoinColumn> buildDefaultJoinColumnHolder() {
        return new PropertyAspectAdapter<SecondaryTable, PrimaryKeyJoinColumn>(this.getSubjectHolder(), new String[]{"defaultPrimaryKeyJoinColumn"}){

            protected PrimaryKeyJoinColumn buildValue_() {
                return ((SecondaryTable)this.subject).getDefaultPrimaryKeyJoinColumn();
            }
        };
    }

    private ListValueModel<PrimaryKeyJoinColumn> buildDefaultJoinColumnListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultJoinColumnHolder());
    }

    private PostExecution<PrimaryKeyJoinColumnInSecondaryTableDialog> buildEditPrimaryKeyJoinColumnPostExecution() {
        return new PostExecution<PrimaryKeyJoinColumnInSecondaryTableDialog>(){

            @Override
            public void execute(PrimaryKeyJoinColumnInSecondaryTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    PrimaryKeyJoinColumnsInSecondaryTableComposite.this.editPrimaryKeyJoinColumn((PrimaryKeyJoinColumnInSecondaryTableStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    private String buildJoinColumnLabel(PrimaryKeyJoinColumn joinColumn) {
        if (joinColumn.isVirtual()) {
            return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                PrimaryKeyJoinColumn joinColumn = (PrimaryKeyJoinColumn)element;
                return PrimaryKeyJoinColumnsInSecondaryTableComposite.this.buildJoinColumnLabel(joinColumn);
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildOverrideDefaultJoinColumnHolder() {
        return new OverrideDefaultJoinColumnHolder();
    }

    private AddRemovePane.Adapter buildPrimaryKeyJoinColumnAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                PrimaryKeyJoinColumnsInSecondaryTableComposite.this.addPrimaryKeyJoinColumn();
            }

            @Override
            public boolean hasOptionalButton() {
                return true;
            }

            @Override
            public String optionalButtonText() {
                return JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_edit;
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                PrimaryKeyJoinColumnsInSecondaryTableComposite.this.editPrimaryKeyJoinColumn(listSelectionModel);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                PrimaryKeyJoinColumnsInSecondaryTableComposite.this.removePrimaryKeyJoinColumn(listSelectionModel);
            }
        };
    }

    private WritablePropertyValueModel<PrimaryKeyJoinColumn> buildPrimaryKeyJoinColumnHolder() {
        return new SimplePropertyValueModel();
    }

    private ListValueModel<PrimaryKeyJoinColumn> buildPrimaryKeyJoinColumnsListHolder() {
        ArrayList<ListValueModel<PrimaryKeyJoinColumn>> list = new ArrayList<ListValueModel<PrimaryKeyJoinColumn>>();
        list.add(this.buildSpecifiedJoinColumnsListHolder());
        list.add(this.buildDefaultJoinColumnListHolder());
        return new CompositeListValueModel(list);
    }

    private ListValueModel<PrimaryKeyJoinColumn> buildPrimaryKeyJoinColumnsListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildPrimaryKeyJoinColumnsListHolder(), new String[]{"specifiedName", "defaultName", "specifiedReferencedColumnName", "defaultReferencedColumnName"});
    }

    private ListValueModel<PrimaryKeyJoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<SecondaryTable, PrimaryKeyJoinColumn>(this.getSubjectHolder(), new String[]{"specifiedPrimaryKeyJoinColumnsList"}){

            protected ListIterator<PrimaryKeyJoinColumn> listIterator_() {
                return ((SecondaryTable)this.subject).specifiedPrimaryKeyJoinColumns();
            }

            protected int size_() {
                return ((SecondaryTable)this.subject).specifiedPrimaryKeyJoinColumnsSize();
            }
        };
    }

    private void editPrimaryKeyJoinColumn(ObjectListSelectionModel listSelectionModel) {
        PrimaryKeyJoinColumn joinColumn = (PrimaryKeyJoinColumn)listSelectionModel.selectedValue();
        PrimaryKeyJoinColumnInSecondaryTableDialog dialog = new PrimaryKeyJoinColumnInSecondaryTableDialog(this.getShell(), (SecondaryTable)this.getSubject(), joinColumn);
        dialog.openDialog(this.buildEditPrimaryKeyJoinColumnPostExecution());
    }

    private void editPrimaryKeyJoinColumn(PrimaryKeyJoinColumnInSecondaryTableStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.joinColumnHolder = this.buildPrimaryKeyJoinColumnHolder();
    }

    @Override
    protected void initializeLayout(Composite container) {
        Group groupPane = this.addTitledGroup(container, JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_primaryKeyJoinColumn);
        Button button = this.addCheckBox(this.addSubPane((Composite)groupPane, 8), JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_overrideDefaultPrimaryKeyJoinColumns, this.buildOverrideDefaultJoinColumnHolder(), null);
        this.installOverrideDefaultButtonEnabler(button);
        AddRemoveListPane<SecondaryTable> joinColumnsPane = new AddRemoveListPane<SecondaryTable>(this, (Composite)groupPane, this.buildPrimaryKeyJoinColumnAdapter(), this.buildPrimaryKeyJoinColumnsListModel(), this.joinColumnHolder, this.buildJoinColumnsListLabelProvider(), "org.eclipse.jpt.ui.mapping_joinTableJoinColumns");
        this.installPrimaryKeyJoinColumnListPaneEnabler(joinColumnsPane);
    }

    private void installOverrideDefaultButtonEnabler(Button overrideDefaultButton) {
        new ControlEnabler(this.buildControlBooleanHolder(), (Control)overrideDefaultButton);
    }

    private void installPrimaryKeyJoinColumnListPaneEnabler(AddRemoveListPane<SecondaryTable> pkJoinColumnListPane) {
        new PaneEnabler((PropertyValueModel<Boolean>)this.buildOverrideDefaultJoinColumnHolder(), (Pane<?>)pkJoinColumnListPane);
    }

    private void removePrimaryKeyJoinColumn(ObjectListSelectionModel listSelectionModel) {
        int[] selectedIndices = listSelectionModel.selectedIndices();
        int index = selectedIndices.length;
        while (--index >= 0) {
            ((SecondaryTable)this.getSubject()).removeSpecifiedPrimaryKeyJoinColumn(selectedIndices[index]);
        }
    }

    private void updateJoinColumns(boolean selected) {
        if (this.isPopulating()) {
            return;
        }
        this.setPopulating(true);
        try {
            SecondaryTable secondaryTable = (SecondaryTable)this.getSubject();
            if (selected) {
                PrimaryKeyJoinColumn defaultJoinColumn = secondaryTable.getDefaultPrimaryKeyJoinColumn();
                if (defaultJoinColumn != null) {
                    String columnName = defaultJoinColumn.getDefaultName();
                    String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
                    PrimaryKeyJoinColumn pkJoinColumn = secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0);
                    pkJoinColumn.setSpecifiedName(columnName);
                    pkJoinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
                    this.joinColumnHolder.setValue((Object)pkJoinColumn);
                }
            } else {
                int index = secondaryTable.specifiedPrimaryKeyJoinColumnsSize();
                while (--index >= 0) {
                    secondaryTable.removeSpecifiedPrimaryKeyJoinColumn(index);
                }
            }
        }
        finally {
            this.setPopulating(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrideDefaultJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements WritablePropertyValueModel<Boolean> {
        public OverrideDefaultJoinColumnHolder() {
            super(PrimaryKeyJoinColumnsInSecondaryTableComposite.this.buildSpecifiedJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            if (PrimaryKeyJoinColumnsInSecondaryTableComposite.this.getSubject() == null) {
                return Boolean.FALSE;
            }
            if (!((SecondaryTable)PrimaryKeyJoinColumnsInSecondaryTableComposite.this.getSubject()).isVirtual() && this.listHolder.size() > 0) {
                return true;
            }
            return false;
        }

        public void setValue(Boolean value) {
            PrimaryKeyJoinColumnsInSecondaryTableComposite.this.updateJoinColumns(value);
        }
    }
}

