/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.platform;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaPlatformUiRegistry {
    private static final JpaPlatformUiRegistry INSTANCE = new JpaPlatformUiRegistry();
    private static final String EXTENSION_ID = "jpaPlatform";
    private static final String EL_PLATFORM = "jpaPlatform";
    private static final String AT_ID = "id";
    private static final String AT_CLASS = "class";
    private Map<String, IConfigurationElement> jpaPlatforms;

    public static JpaPlatformUiRegistry instance() {
        return INSTANCE;
    }

    private JpaPlatformUiRegistry() {
        this.buildJpaPlatforms();
    }

    private void buildJpaPlatforms() {
        this.jpaPlatforms = new HashMap<String, IConfigurationElement>();
        Iterator<IConfigurationElement> stream = this.allConfigElements();
        while (stream.hasNext()) {
            this.buildJpaPlatform(stream.next());
        }
    }

    private void buildJpaPlatform(IConfigurationElement configElement) {
        if (!configElement.getName().equals("jpaPlatform")) {
            return;
        }
        String platformId = configElement.getAttribute(AT_ID);
        String platformClass = configElement.getAttribute(AT_CLASS);
        if (platformId == null || platformClass == null) {
            if (platformId == null) {
                this.reportMissingAttribute(configElement, AT_ID);
            }
            if (platformClass == null) {
                this.reportMissingAttribute(configElement, AT_CLASS);
            }
            return;
        }
        if (this.jpaPlatforms.containsKey(platformId)) {
            IConfigurationElement otherConfigElement = this.jpaPlatforms.get(platformId);
            this.reportDuplicatePlatform(configElement, otherConfigElement);
        }
        this.jpaPlatforms.put(platformId, configElement);
    }

    public JpaPlatformUi getJpaPlatformUi(String platformId) {
        IConfigurationElement registeredConfigElement = this.jpaPlatforms.get(platformId);
        if (registeredConfigElement == null) {
            return null;
        }
        try {
            return (JpaPlatformUi)registeredConfigElement.createExecutableExtension(AT_CLASS);
        }
        catch (CoreException coreException) {
            this.reportFailedInstantiation(registeredConfigElement);
            return null;
        }
    }

    private Iterator<IConfigurationElement> allConfigElements() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.jpt.ui", "jpaPlatform");
        Object[] extensions = extensionPoint.getExtensions();
        return new CompositeIterator((Iterator)new TransformationIterator<IExtension, Iterator<IConfigurationElement>>(CollectionTools.iterator((Object[])extensions)){

            protected Iterator<IConfigurationElement> transform(IExtension extension) {
                return CollectionTools.iterator((Object[])extension.getConfigurationElements());
            }
        });
    }

    private void reportMissingAttribute(IConfigurationElement configElement, String attributeName) {
        String message = "An extension element \"" + configElement.getName() + "\" in plugin \"" + configElement.getContributor().getName() + "\" is missing a required attribute \"" + attributeName + "\".";
        JptUiPlugin.log(message);
    }

    private void reportDuplicatePlatform(IConfigurationElement oneConfigElement, IConfigurationElement otherConfigElement) {
        String message = "The plugins \"" + oneConfigElement.getContributor().getName() + "\" and \"" + otherConfigElement.getContributor().getName() + "\" have registered a duplicate attribute \"id\" " + "for the extension element \"jpaPlatform\".";
        JptUiPlugin.log(message);
    }

    private void reportFailedInstantiation(IConfigurationElement configElement) {
        String message = "Could not instantiate the class \"" + configElement.getAttribute(AT_CLASS) + "\" for the extension element \"" + configElement.getName() + "\" in the plugin \"" + configElement.getContributor().getName() + "\".";
        JptUiPlugin.log(message);
    }
}

