/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.platform.generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.context.MappingFile;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.ui.internal.jface.AbstractTreeItemContentProvider;
import org.eclipse.jpt.ui.internal.jface.DelegatingTreeContentAndLabelProvider;
import org.eclipse.jpt.ui.internal.platform.generic.JavaPersistentTypeItemContentProvider;
import org.eclipse.jpt.ui.internal.platform.generic.OrmPersistentTypeItemContentProvider;
import org.eclipse.jpt.ui.internal.platform.generic.OrmXmlItemContentProvider;
import org.eclipse.jpt.ui.internal.platform.generic.PersistenceXmlItemContentProvider;
import org.eclipse.jpt.ui.internal.platform.generic.PersistentAttributeItemContentProvider;
import org.eclipse.jpt.ui.internal.platform.generic.RootContextItemContentProvider;
import org.eclipse.jpt.ui.jface.DelegatingContentAndLabelProvider;
import org.eclipse.jpt.ui.jface.TreeItemContentProvider;
import org.eclipse.jpt.ui.jface.TreeItemContentProviderFactory;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.FilteringCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationListValueModelAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

public class GenericNavigatorItemContentProviderFactory
implements TreeItemContentProviderFactory {
    public TreeItemContentProvider buildItemContentProvider(Object item, DelegatingContentAndLabelProvider contentAndLabelProvider) {
        DelegatingTreeContentAndLabelProvider treeContentAndLabelProvider = (DelegatingTreeContentAndLabelProvider)contentAndLabelProvider;
        if (item instanceof JpaRootContextNode) {
            return new RootContextItemContentProvider((JpaRootContextNode)item, treeContentAndLabelProvider);
        }
        if (item instanceof PersistenceXml) {
            return new PersistenceXmlItemContentProvider((PersistenceXml)item, treeContentAndLabelProvider);
        }
        if (item instanceof PersistenceUnit) {
            return new PersistenceUnitItemContentProvider((PersistenceUnit)item, treeContentAndLabelProvider);
        }
        if (item instanceof OrmXml) {
            return new OrmXmlItemContentProvider((OrmXml)item, treeContentAndLabelProvider);
        }
        if (item instanceof OrmPersistentType) {
            return new OrmPersistentTypeItemContentProvider((OrmPersistentType)item, treeContentAndLabelProvider);
        }
        if (item instanceof JavaPersistentType) {
            return new JavaPersistentTypeItemContentProvider((JavaPersistentType)item, treeContentAndLabelProvider);
        }
        if (item instanceof PersistentAttribute) {
            return new PersistentAttributeItemContentProvider((PersistentAttribute)item, treeContentAndLabelProvider);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistenceUnitItemContentProvider
    extends AbstractTreeItemContentProvider<JpaContextNode> {
        public PersistenceUnitItemContentProvider(PersistenceUnit persistenceUnit, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)persistenceUnit, contentProvider);
        }

        public PersistenceUnit getModel() {
            return (PersistenceUnit)super.getModel();
        }

        public PersistenceXml getParent() {
            return this.getModel().getParent().getParent();
        }

        @Override
        protected ListValueModel<JpaContextNode> buildChildrenModel() {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.buildSpecifiedOrmXmlLvm());
            list.add(this.buildImpliedMappingFileLvm());
            list.add(this.buildPersistentTypeLvm());
            return new CompositeListValueModel(list);
        }

        protected ListValueModel<JpaContextNode> buildSpecifiedOrmXmlLvm() {
            return new CollectionListValueModelAdapter((CollectionValueModel)new FilteringCollectionValueModel<MappingFile>((CollectionValueModel)new ListCollectionValueModelAdapter((ListValueModel)new TransformationListValueModelAdapter<MappingFileRef, MappingFile>((ListValueModel)new ItemPropertyListValueModelAdapter((ListValueModel)new ListAspectAdapter<PersistenceUnit, MappingFileRef>("specifiedMappingFileRefs", this.getModel()){

                protected ListIterator<MappingFileRef> listIterator_() {
                    return ((PersistenceUnit)this.subject).specifiedMappingFileRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).specifiedMappingFileRefsSize();
                }
            }, new String[]{"mappingFile"})){

                protected MappingFile transformItem(MappingFileRef item) {
                    return item.getMappingFile();
                }
            })){

                protected Iterator<MappingFile> filter(Iterator<? extends MappingFile> items) {
                    return new FilteringIterator<MappingFile, MappingFile>(items){

                        protected boolean accept(MappingFile o) {
                            return o != null;
                        }
                    };
                }
            });
        }

        protected ListValueModel<MappingFile> buildImpliedMappingFileLvm() {
            return new PropertyListValueModelAdapter((PropertyValueModel)new PropertyAspectAdapter<MappingFileRef, MappingFile>((PropertyValueModel)new PropertyAspectAdapter<PersistenceUnit, MappingFileRef>("impliedMappingFileRef", this.getModel()){

                protected MappingFileRef buildValue_() {
                    return ((PersistenceUnit)this.subject).getImpliedMappingFileRef();
                }
            }, new String[]{"mappingFile"}){

                protected MappingFile buildValue_() {
                    return ((MappingFileRef)this.subject).getMappingFile();
                }
            });
        }

        protected ListValueModel<JpaContextNode> buildPersistentTypeLvm() {
            return new CollectionListValueModelAdapter((CollectionValueModel)new FilteringCollectionValueModel<PersistentType>((CollectionValueModel)new ListCollectionValueModelAdapter((ListValueModel)new TransformationListValueModelAdapter<ClassRef, PersistentType>((ListValueModel)new ItemPropertyListValueModelAdapter(this.buildClassRefLvm(), new String[]{"javaPersistentType"})){

                protected PersistentType transformItem(ClassRef item) {
                    return item.getJavaPersistentType();
                }
            })){

                protected Iterator<PersistentType> filter(Iterator<? extends PersistentType> items) {
                    return new FilteringIterator<PersistentType, PersistentType>(items){

                        protected boolean accept(PersistentType o) {
                            return o != null;
                        }
                    };
                }
            });
        }

        protected ListValueModel<ClassRef> buildClassRefLvm() {
            ArrayList<ListValueModel<ClassRef>> holders = new ArrayList<ListValueModel<ClassRef>>(2);
            holders.add(this.buildSpecifiedClassRefLvm());
            holders.add(this.buildImpliedClassRefLvm());
            return new CompositeListValueModel(holders);
        }

        protected ListValueModel<ClassRef> buildSpecifiedClassRefLvm() {
            return new ListAspectAdapter<PersistenceUnit, ClassRef>("specifiedClassRefs", this.getModel()){

                protected ListIterator<ClassRef> listIterator_() {
                    return ((PersistenceUnit)this.subject).specifiedClassRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).specifiedClassRefsSize();
                }
            };
        }

        protected ListValueModel<ClassRef> buildImpliedClassRefLvm() {
            return new ListAspectAdapter<PersistenceUnit, ClassRef>("impliedClassRefs", this.getModel()){

                protected ListIterator<ClassRef> listIterator_() {
                    return ((PersistenceUnit)this.subject).impliedClassRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).impliedClassRefsSize();
                }
            };
        }
    }
}

