/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.widgets;

import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.widgets.ChooserPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackageChooserPane<T extends Model>
extends ChooserPane<T> {
    private JavaPackageCompletionProcessor javaPackageCompletionProcessor;

    public PackageChooserPane(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    public PackageChooserPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    @Override
    protected final Runnable buildBrowseAction() {
        return new Runnable(){

            public void run() {
                PackageChooserPane.this.promptPackage();
            }
        };
    }

    @Override
    protected Control addMainControl(Composite container) {
        WritablePropertyValueModel<String> textHolder = this.buildTextHolder();
        textHolder.addPropertyChangeListener("value", this.buildTextChangeListener());
        Text text = this.addText(container, textHolder);
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this.javaPackageCompletionProcessor);
        return text;
    }

    private PropertyChangeListener buildTextChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildTextChangeListener_());
    }

    private PropertyChangeListener buildTextChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                IPackageFragmentRoot root;
                if (PackageChooserPane.this.getSubject() != null && (root = PackageChooserPane.this.getPackageFragmentRoot()) != null) {
                    PackageChooserPane.this.javaPackageCompletionProcessor.setPackageFragmentRoot(root);
                }
            }
        };
    }

    protected abstract WritablePropertyValueModel<String> buildTextHolder();

    protected IPackageFragment choosePackage() {
        SelectionDialog selectionDialog;
        try {
            selectionDialog = JavaUI.createPackageDialog((Shell)this.getShell(), (IPackageFragmentRoot)this.getPackageFragmentRoot());
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            return null;
        }
        selectionDialog.setTitle(JptUiMessages.ClassChooserPane_dialogTitle);
        selectionDialog.setMessage(JptUiMessages.ClassChooserPane_dialogMessage);
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            selectionDialog.setInitialSelections(new Object[]{pack});
        }
        if (selectionDialog.open() == 0) {
            return (IPackageFragment)selectionDialog.getResult()[0];
        }
        return null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.javaPackageCompletionProcessor = new JavaPackageCompletionProcessor((ILabelProvider)new JavaElementLabelProvider(64));
    }

    private IPackageFragment getPackageFragment() {
        String packageName = this.getPackageName();
        if (packageName == null) {
            return null;
        }
        return this.getPackageFragmentRoot().getPackageFragment(packageName);
    }

    protected abstract IPackageFragmentRoot getPackageFragmentRoot();

    protected abstract String getPackageName();

    protected abstract void promptPackage();
}

