/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards;

import java.util.EventListener;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.db.ConnectionAdapter;
import org.eclipse.jpt.db.ConnectionListener;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.db.ui.internal.DTPUiTools;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.ListenerList;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;

public class DatabaseConnectionWizardPage
extends WizardPage {
    final JpaProject jpaProject;
    private final ListenerList<Listener> listenerList = new ListenerList(Listener.class);
    private DatabaseGroup databaseGroup;

    public DatabaseConnectionWizardPage(JpaProject jpaProject) {
        super("Database Settings");
        if (jpaProject == null) {
            throw new NullPointerException();
        }
        this.jpaProject = jpaProject;
        this.setTitle(JptUiMessages.DatabaseConnectionWizardPage_databaseConnection);
        this.setMessage(JptUiMessages.DatabaseConnectionWizardPage_connectToDatabase);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        this.setControl(this.buildTopLevelControl(parent));
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.databaseGroup = new DatabaseGroup(composite);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.ui.properties_javaPersistenceConnection");
        return composite;
    }

    public ConnectionProfile getSelectedConnectionProfile() {
        return this.databaseGroup.getSelectedConnectionProfile();
    }

    public Schema getSelectedSchema() {
        return this.databaseGroup.getSelectedSchema();
    }

    public void dispose() {
        this.databaseGroup.dispose();
        super.dispose();
    }

    public void addListener(Listener listener) {
        this.listenerList.add((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.listenerList.remove((EventListener)listener);
    }

    void fireConnectionProfileChanged(ConnectionProfile connectionProfile) {
        Listener[] listenerArray = (Listener[])this.listenerList.getListeners();
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            listener.selectedConnectionProfileChanged(connectionProfile);
            ++n2;
        }
    }

    void fireSchemaChanged(Schema schema) {
        this.setPageComplete(schema != null);
        Listener[] listenerArray = (Listener[])this.listenerList.getListeners();
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            listener.selectedSchemaChanged(schema);
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DatabaseGroup {
        private ConnectionProfile selectedConnectionProfile;
        private Schema selectedSchema;
        private final Combo connectionComboBox;
        private final Combo schemaComboBox;
        private final Link reconnectLink;
        private final ConnectionListener connectionListener;

        DatabaseGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(768));
            group.setText(JptUiMessages.DatabaseConnectionWizardPage_database);
            this.buildLabel((Composite)group, 1, JptUiMessages.DatabaseConnectionWizardPage_connection);
            this.connectionComboBox = this.buildComboBox((Composite)group, this.buildConnectionComboBoxSelectionListener());
            this.buildLabel((Composite)group, 1, JptUiMessages.DatabaseConnectionWizardPage_schema);
            this.schemaComboBox = this.buildComboBox((Composite)group, this.buildSchemaComboBoxSelectionListener());
            this.buildLabel((Composite)group, 2, JptUiMessages.DatabaseConnectionWizardPage_schemaInfo);
            this.buildLink((Composite)group, JptUiMessages.DatabaseConnectionWizardPage_addConnectionLink, this.buildAddConnectionLinkSelectionListener());
            this.reconnectLink = this.buildLink((Composite)group, JptUiMessages.DatabaseConnectionWizardPage_connectLink, this.buildReconnectLinkSelectionListener());
            this.connectionListener = this.buildConnectionListener();
            this.selectedConnectionProfile = this.getJpaProjectConnectionProfile();
            this.selectedSchema = this.getDefaultSchema();
            if (this.selectedSchema != null) {
                DatabaseConnectionWizardPage.this.fireSchemaChanged(this.selectedSchema);
            }
            if (this.selectedConnectionProfile != null) {
                this.selectedConnectionProfile.addConnectionListener(this.connectionListener);
                DatabaseConnectionWizardPage.this.fireConnectionProfileChanged(this.selectedConnectionProfile);
            }
            this.updateConnectionComboBox();
            this.updateSchemaComboBox();
            this.updateReconnectLink();
        }

        ConnectionProfile getSelectedConnectionProfile() {
            return this.selectedConnectionProfile;
        }

        Schema getSelectedSchema() {
            return this.selectedSchema;
        }

        void dispose() {
            if (this.selectedConnectionProfile != null) {
                this.selectedConnectionProfile.removeConnectionListener(this.connectionListener);
            }
        }

        private ConnectionProfile getJpaProjectConnectionProfile() {
            return DatabaseConnectionWizardPage.this.jpaProject.getConnectionProfile();
        }

        private Schema getDefaultSchema() {
            return this.selectedConnectionProfile == this.getJpaProjectConnectionProfile() ? DatabaseConnectionWizardPage.this.jpaProject.getDefaultDbSchema() : null;
        }

        private void updateConnectionComboBox() {
            this.connectionComboBox.removeAll();
            for (String cpName : this.buildSortedConnectionProfileNames()) {
                this.connectionComboBox.add(cpName);
            }
            if (this.selectedConnectionProfile != null) {
                this.connectionComboBox.select(this.connectionComboBox.indexOf(this.selectedConnectionProfile.getName()));
            }
        }

        private SortedSet<String> buildSortedConnectionProfileNames() {
            return CollectionTools.sortedSet((Iterator)JptDbPlugin.instance().getConnectionProfileFactory().connectionProfileNames());
        }

        private void updateReconnectLink() {
            this.reconnectLink.setEnabled(this.reconnectLinkCanBeEnabled());
        }

        private boolean reconnectLinkCanBeEnabled() {
            return this.selectedConnectionProfile != null && this.selectedConnectionProfile.isInactive();
        }

        private void updateSchemaComboBox() {
            this.schemaComboBox.removeAll();
            Iterator<String> stream = this.getSchemata();
            while (stream.hasNext()) {
                this.schemaComboBox.add(stream.next());
            }
            if (this.selectedSchema != null) {
                this.schemaComboBox.select(this.schemaComboBox.indexOf(this.selectedSchema.getIdentifier()));
            }
        }

        private Iterator<String> getSchemata() {
            SchemaContainer sc = DatabaseConnectionWizardPage.this.jpaProject.getDefaultDbSchemaContainer();
            return sc == null ? EmptyIterator.instance() : sc.sortedSchemaIdentifiers();
        }

        private ConnectionProfile checkJpaProjectConnectionProfile(String cpName) {
            ConnectionProfile cp = this.getJpaProjectConnectionProfile();
            if (cp != null && cp.getName().equals(cpName)) {
                return cp;
            }
            return this.buildConnectionProfile(cpName);
        }

        private ConnectionProfile buildConnectionProfile(String name) {
            return JptDbPlugin.instance().getConnectionProfileFactory().buildConnectionProfile(name);
        }

        void selectedConnectionChanged() {
            String text = this.connectionComboBox.getText();
            if (text.length() == 0) {
                if (this.selectedConnectionProfile == null) {
                    return;
                }
                this.selectedConnectionProfile.removeConnectionListener(this.connectionListener);
                this.selectedConnectionProfile = null;
            } else {
                if (this.selectedConnectionProfile == null) {
                    this.selectedConnectionProfile = this.checkJpaProjectConnectionProfile(text);
                } else {
                    if (text.equals(this.selectedConnectionProfile.getName())) {
                        return;
                    }
                    this.selectedConnectionProfile.removeConnectionListener(this.connectionListener);
                    this.selectedConnectionProfile = this.checkJpaProjectConnectionProfile(text);
                }
                this.selectedConnectionProfile.addConnectionListener(this.connectionListener);
            }
            this.connectionChanged();
            DatabaseConnectionWizardPage.this.fireConnectionProfileChanged(this.selectedConnectionProfile);
        }

        void selectedSchemaChanged() {
            Schema old = this.selectedSchema;
            this.selectedSchema = this.selectedConnectionProfile.getDatabase().getSchemaForIdentifier(this.schemaComboBox.getText());
            if (this.selectedSchema != old) {
                DatabaseConnectionWizardPage.this.fireSchemaChanged(this.selectedSchema);
            }
        }

        void addConnection() {
            String addedProfileName = DTPUiTools.createNewConnectionProfile();
            if (addedProfileName == null) {
                return;
            }
            if (this.selectedConnectionProfile != null) {
                this.selectedConnectionProfile.removeConnectionListener(this.connectionListener);
            }
            this.selectedConnectionProfile = this.buildConnectionProfile(addedProfileName);
            this.selectedConnectionProfile.addConnectionListener(this.connectionListener);
            this.updateConnectionComboBox();
            this.selectedConnectionProfile.connect();
            DatabaseConnectionWizardPage.this.fireConnectionProfileChanged(this.selectedConnectionProfile);
        }

        void reconnect() {
            this.selectedConnectionProfile.connect();
        }

        void connectionChanged() {
            Schema old = this.selectedSchema;
            this.selectedSchema = this.getDefaultSchema();
            if (this.selectedSchema != old) {
                DatabaseConnectionWizardPage.this.fireSchemaChanged(this.selectedSchema);
            }
            this.updateSchemaComboBox();
            this.updateReconnectLink();
        }

        private SelectionListener buildConnectionComboBoxSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    DatabaseGroup.this.selectedConnectionChanged();
                }

                public String toString() {
                    return "DatabaseConnectionWizardPage connection combo-box selection listener";
                }
            };
        }

        private SelectionListener buildSchemaComboBoxSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    DatabaseGroup.this.selectedSchemaChanged();
                }

                public String toString() {
                    return "DatabaseConnectionWizardPage schema combo-box selection listener";
                }
            };
        }

        private SelectionListener buildAddConnectionLinkSelectionListener() {
            return new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DatabaseGroup.this.addConnection();
                }

                public String toString() {
                    return "DatabaseConnectionWizardPage add connection link selection listener";
                }
            };
        }

        private SelectionListener buildReconnectLinkSelectionListener() {
            return new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DatabaseGroup.this.reconnect();
                }

                public String toString() {
                    return "DatabaseConnectionWizardPage reconnect link selection listener";
                }
            };
        }

        private ConnectionListener buildConnectionListener() {
            return new ConnectionAdapter(){

                public void opened(ConnectionProfile cp) {
                    this.connectionChanged();
                }

                public void closed(ConnectionProfile cp) {
                    this.connectionChanged();
                }

                private void connectionChanged() {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            DatabaseGroup.this.connectionChanged();
                        }
                    });
                }

                public String toString() {
                    return "DatabaseConnectionWizardPage connection listener";
                }
            };
        }

        private Label buildLabel(Composite parent, int span, String text) {
            Label label = new Label(parent, 0);
            label.setText(text);
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            label.setLayoutData((Object)gd);
            return label;
        }

        private Combo buildComboBox(Composite parent, SelectionListener listener) {
            Combo combo = new Combo(parent, 2056);
            combo.setLayoutData((Object)new GridData(768));
            combo.addSelectionListener(listener);
            return combo;
        }

        private Link buildLink(Composite parent, String text, SelectionListener listener) {
            Link link = new Link(parent, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            link.setLayoutData((Object)data);
            link.setText(text);
            link.addSelectionListener(listener);
            return link;
        }
    }

    public static interface Listener
    extends EventListener {
        public void selectedConnectionProfileChanged(ConnectionProfile var1);

        public void selectedSchemaChanged(Schema var1);
    }
}

