/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.core.EntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.gen.internal.EntityGenerator;
import org.eclipse.jpt.gen.internal.PackageGenerator;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.wizards.DatabaseConnectionWizardPage;
import org.eclipse.jpt.ui.internal.wizards.GenerateEntitiesWizardPage;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateEntitiesWizard
extends Wizard {
    private final JpaProject jpaProject;
    private final IStructuredSelection selection;
    private DatabaseConnectionWizardPage dbSettingsPage;
    private GenerateEntitiesWizardPage generateEntitiesPage;
    private final PackageGenerator.Config packageGeneratorConfig;
    private final EntityGenerator.Config entityGeneratorConfig;
    private boolean synchronizePersistenceXml;

    public GenerateEntitiesWizard(JpaProject jpaProject, IStructuredSelection selection) {
        this.jpaProject = jpaProject;
        this.selection = selection;
        this.packageGeneratorConfig = new PackageGenerator.Config();
        this.entityGeneratorConfig = new EntityGenerator.Config();
        this.setWindowTitle(JptUiMessages.GenerateEntitiesWizard_generateEntities);
    }

    public void addPages() {
        super.addPages();
        this.dbSettingsPage = new DatabaseConnectionWizardPage(this.jpaProject);
        this.dbSettingsPage.addListener(new DatabasePageListener());
        this.addPage((IWizardPage)this.dbSettingsPage);
        this.generateEntitiesPage = new GenerateEntitiesWizardPage();
        this.addPage((IWizardPage)this.generateEntitiesPage);
        this.generateEntitiesPage.init(this.selection);
    }

    public boolean canFinish() {
        return this.generateEntitiesPage.isPageComplete();
    }

    public boolean performFinish() {
        this.packageGeneratorConfig.setPackageFragment(this.buildPackageFragment());
        this.entityGeneratorConfig.setConvertToJavaStyleIdentifiers(this.generateEntitiesPage.convertToJavaStyleIdentifiers());
        this.entityGeneratorConfig.setFieldAccessType(this.generateEntitiesPage.fieldAccessType());
        this.entityGeneratorConfig.setCollectionTypeName(this.generateEntitiesPage.getCollectionTypeName());
        this.entityGeneratorConfig.setCollectionAttributeNameSuffix(this.generateEntitiesPage.getCollectionAttributeNameSuffix());
        this.entityGeneratorConfig.setFieldVisibility(this.generateEntitiesPage.getFieldVisibility());
        this.entityGeneratorConfig.setMethodVisibility(this.generateEntitiesPage.getMethodVisibility());
        this.entityGeneratorConfig.setGenerateGettersAndSetters(this.generateEntitiesPage.generateGettersAndSetters());
        this.entityGeneratorConfig.setGenerateDefaultConstructor(this.generateEntitiesPage.generateDefaultConstructor());
        this.entityGeneratorConfig.setSerializable(this.generateEntitiesPage.serializable());
        this.entityGeneratorConfig.setGenerateSerialVersionUID(this.generateEntitiesPage.generateSerialVersionUID());
        this.entityGeneratorConfig.setGenerateEmbeddedIdForCompoundPK(this.generateEntitiesPage.generateEmbeddedIdForCompoundPK());
        this.entityGeneratorConfig.setEmbeddedIdAttributeName(this.generateEntitiesPage.getEmbeddedIdAttributeName());
        this.entityGeneratorConfig.setPrimaryKeyMemberClassName(this.generateEntitiesPage.getPrimaryKeyMemberClassName());
        for (Map.Entry<Table, String> entry : this.generateEntitiesPage.getSelectedTables().entrySet()) {
            this.entityGeneratorConfig.addTable(entry.getKey(), entry.getValue());
        }
        this.entityGeneratorConfig.setDatabaseAnnotationNameBuilder(this.buildDatabaseAnnotationNameBuilder());
        this.synchronizePersistenceXml = this.generateEntitiesPage.synchronizePersistenceXml();
        return true;
    }

    private EntityGenerator.DatabaseAnnotationNameBuilder buildDatabaseAnnotationNameBuilder() {
        return new LocalDatabaseAnnotationNameBuilder(this.jpaProject.getJpaPlatform().getEntityGeneratorDatabaseAnnotationNameBuilder());
    }

    private IPackageFragment buildPackageFragment() {
        IPackageFragmentRoot packageFragmentRoot = this.generateEntitiesPage.getPackageFragmentRoot();
        IPackageFragment packageFragment = this.generateEntitiesPage.getPackageFragment();
        if (packageFragment == null) {
            packageFragment = packageFragmentRoot.getPackageFragment("");
        }
        if (packageFragment.exists()) {
            return packageFragment;
        }
        try {
            return packageFragmentRoot.createPackageFragment(packageFragment.getElementName(), true, null);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    Collection<Table> getPossibleTables() {
        return this.buildTables(this.dbSettingsPage.getSelectedSchema());
    }

    JpaProject getJpaProject() {
        return this.jpaProject;
    }

    void selectedSchemaChanged(Schema schema) {
        this.generateEntitiesPage.setPossibleTables(this.buildTables(schema));
    }

    private Collection<Table> buildTables(Schema schema) {
        return schema == null ? Collections.emptySet() : CollectionTools.collection((Iterator)schema.tables());
    }

    public PackageGenerator.Config getPackageGeneratorConfig() {
        return this.packageGeneratorConfig;
    }

    public EntityGenerator.Config getEntityGeneratorConfig() {
        return this.entityGeneratorConfig;
    }

    public boolean synchronizePersistenceXml() {
        return this.synchronizePersistenceXml;
    }

    class DatabasePageListener
    implements DatabaseConnectionWizardPage.Listener {
        DatabasePageListener() {
        }

        public void selectedConnectionProfileChanged(ConnectionProfile connectionProfile) {
        }

        public void selectedSchemaChanged(Schema schema) {
            GenerateEntitiesWizard.this.selectedSchemaChanged(schema);
        }
    }

    static class LocalDatabaseAnnotationNameBuilder
    implements EntityGenerator.DatabaseAnnotationNameBuilder {
        private EntityGeneratorDatabaseAnnotationNameBuilder builder;

        LocalDatabaseAnnotationNameBuilder(EntityGeneratorDatabaseAnnotationNameBuilder builder) {
            this.builder = builder;
        }

        public String buildTableAnnotationName(String entityName, Table table) {
            return this.builder.buildTableAnnotationName(entityName, table);
        }

        public String buildColumnAnnotationName(String attributeName, Column column) {
            return this.builder.buildColumnAnnotationName(attributeName, column);
        }

        public String buildJoinColumnAnnotationName(String attributeName, ForeignKey foreignKey) {
            return this.builder.buildJoinColumnAnnotationName(attributeName, foreignKey);
        }

        public String buildJoinColumnAnnotationName(Column column) {
            return this.builder.buildJoinColumnAnnotationName(column);
        }

        public String buildJoinTableAnnotationName(Table table) {
            return this.builder.buildJoinTableAnnotationName(table);
        }
    }
}

