/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.ui.internal.wizards.entity.EntityWizardMsg;
import org.eclipse.jpt.ui.internal.wizards.entity.data.model.EntityRow;
import org.eclipse.jst.j2ee.internal.dialogs.TypeSearchEngine;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EntityRowTableWizardSection
extends Composite {
    protected static final String[] VALID_TYPES = new String[]{"int", "long", "short", "char", "boolean", "byte", "double", "float", "java.lang.String", "byte[]", "char[]", "java.lang.Byte[]", "java.lang.Character[]", "java.math.BigDecimal", "java.math.BigInteger", "java.sql.Date", "java.sql.Time", "java.sql.Timestamp", "java.util.Date", "java.util.Calendar"};
    private CheckboxTableViewer mTableViewer = null;
    private Table mTableWidget = null;
    private final int PK_COLUMN = 0;
    private final int NAME_COLUMN = 1;
    private final int TYPE_COLUMN = 2;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private String title = EntityWizardMsg.ENTITY_FIELDS_DIALOG_TITLE;
    private String[] labelsForCombo = VALID_TYPES;
    private String[] labelsForText = new String[]{EntityWizardMsg.TYPE_TEXT_FIELD, EntityWizardMsg.NAME_TEXT_FIELD};
    private IDataModel model;
    private String propertyName;
    private Image labelProviderImage = null;
    private DialogCallback callback;

    public EntityRowTableWizardSection(Composite parent, IDataModel model, String propertyName) {
        super(parent, 0);
        this.model = model;
        this.propertyName = propertyName;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 4;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        this.mTableWidget = new Table((Composite)this, 67616);
        this.mTableWidget.setHeaderVisible(true);
        this.mTableWidget.setLinesVisible(true);
        this.mTableViewer = new CheckboxTableViewer(this.mTableWidget);
        GridData data = new GridData(1808);
        data.verticalSpan = 2;
        this.mTableWidget.setLayoutData((Object)data);
        this.mTableViewer.setContentProvider((IContentProvider)new EntityRowContentProvider());
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new EntityRowLabelProvider());
        final Composite buttonComposition = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        buttonComposition.setLayout((Layout)layout);
        buttonComposition.setLayoutData((Object)new GridData(1042));
        this.addButton = new Button(buttonComposition, 8);
        this.addButton.setText(EntityWizardMsg.ADD_BUTTON_LABEL);
        this.addButton.setLayoutData((Object)new GridData(258));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EntityRowTableWizardSection.this.handleAddButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.editButton = new Button(buttonComposition, 8);
        this.editButton.setText(EntityWizardMsg.EDIT_BUTTON_LABEL);
        this.editButton.setLayoutData((Object)new GridData(258));
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EntityRowTableWizardSection.this.handleEditButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.editButton.setEnabled(false);
        this.mTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EntityRowTableWizardSection.this.handleEditButtonSelected();
            }
        });
        this.removeButton = new Button(buttonComposition, 8);
        this.removeButton.setText(EntityWizardMsg.REMOVE_BUTTON_LABEL);
        this.removeButton.setLayoutData((Object)new GridData(258));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EntityRowTableWizardSection.this.handleRemoveButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton.setEnabled(false);
        this.mTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (EntityRowTableWizardSection.this.editButton != null) {
                    boolean enabled = ((IStructuredSelection)selection).size() == 1;
                    EntityRowTableWizardSection.this.editButton.setEnabled(enabled);
                }
                EntityRowTableWizardSection.this.removeButton.setEnabled(!selection.isEmpty());
            }
        });
        final TableColumn pkColumn = new TableColumn(this.mTableWidget, 32);
        pkColumn.setText(EntityWizardMsg.KEY);
        pkColumn.pack();
        pkColumn.setResizable(false);
        TableColumn nameColumn = new TableColumn(this.mTableWidget, 0);
        nameColumn.setText(EntityWizardMsg.NAME_COLUMN);
        TableColumn typeColumn = new TableColumn(this.mTableWidget, 0);
        typeColumn.setText(EntityWizardMsg.TYPE_COLUMN);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = EntityRowTableWizardSection.this.mTableViewer.getTable();
                TableColumn[] columns = table.getColumns();
                Point buttonArea = buttonComposition.computeSize(-1, -1);
                Rectangle area = table.getParent().getClientArea();
                Point preferredSize = EntityRowTableWizardSection.this.mTableViewer.getTable().computeSize(-1, -1);
                int width = area.width - 2 * table.getBorderWidth() - buttonArea.x - columns.length * 2 - pkColumn.getWidth();
                if (preferredSize.y > area.height + table.getHeaderHeight()) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                int consumeWidth = 0;
                int col = columns.length - 1;
                int i = 1;
                while (i < columns.length) {
                    if (oldSize.x > area.width) {
                        consumeWidth = this.setColumntWidth(width, columns, consumeWidth, i);
                        table.setSize(area.width - buttonArea.x - (col * 2 + pkColumn.getWidth()), area.height);
                    } else {
                        consumeWidth = this.setColumntWidth(width, columns, consumeWidth, i);
                        table.setSize(area.width - buttonArea.x - (col * 2 + pkColumn.getWidth()), area.height);
                    }
                    ++i;
                }
            }

            private int setColumntWidth(int width, TableColumn[] columns, int consumeWidth, int i) {
                if (i < columns.length - 1) {
                    columns[i].setWidth(width / (columns.length - 1));
                    consumeWidth += columns[i].getWidth();
                } else {
                    columns[i].setWidth(width - consumeWidth);
                }
                return consumeWidth;
            }
        });
        this.mTableViewer.addCheckStateListener((ICheckStateListener)new PKFieldCheckStateListener());
        this.callback = new FieldDialogCallback();
    }

    private void handleAddButtonSelected() {
        AddFieldDialog dialog = new AddFieldDialog(this.getShell(), this.title, this.labelsForCombo, this.labelsForText);
        int result = dialog.open();
        if (result == 1) {
            return;
        }
        EntityRow entityRow = dialog.getEntityRow();
        this.addEntityRow(entityRow);
        if (!entityRow.couldBeKey()) {
            this.mTableViewer.setGrayed((Object)entityRow, true);
        }
    }

    private void addEntityRow(EntityRow entity) {
        if (entity == null) {
            return;
        }
        ArrayList<EntityRow> valueList = (ArrayList<EntityRow>)this.mTableViewer.getInput();
        if (valueList == null) {
            valueList = new ArrayList<EntityRow>();
        }
        valueList.add(entity);
        this.setInput(valueList);
    }

    private void handleEditButtonSelected() {
        ISelection s = this.mTableViewer.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return;
        }
        Object selectedObj = selection.getFirstElement();
        EntityRow entityForEdit = (EntityRow)selectedObj;
        int index = this.mTableWidget.getSelectionIndex();
        boolean isChecked = this.mTableViewer.getChecked((Object)entityForEdit);
        EditFieldDialog dialog = new EditFieldDialog(this.getShell(), this.title, this.labelsForCombo, this.labelsForText, entityForEdit);
        dialog.open();
        EntityRow entityRow = dialog.getEntityRow();
        if (entityRow != null) {
            this.editEntityRow(index, entityRow);
            this.mTableViewer.setChecked((Object)entityRow, isChecked);
            if (!entityRow.couldBeKey()) {
                this.mTableViewer.setChecked((Object)entityRow, false);
                this.mTableViewer.setGrayed((Object)entityRow, true);
            } else {
                this.mTableViewer.setGrayed((Object)entityRow, false);
            }
        }
    }

    private void editEntityRow(int index, EntityRow newEntity) {
        if (newEntity == null) {
            return;
        }
        ArrayList<EntityRow> valueList = (ArrayList<EntityRow>)this.mTableViewer.getInput();
        if (valueList == null) {
            valueList = new ArrayList<EntityRow>();
        }
        if (index == -1) {
            valueList.add(newEntity);
        } else {
            valueList.set(index, newEntity);
        }
        this.setInput(valueList);
    }

    private void handleRemoveButtonSelected() {
        ISelection selection = this.mTableViewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        List selectedObject = ((IStructuredSelection)selection).toList();
        this.removeEntityRow(selectedObject);
    }

    private void removeEntityRow(Collection entities) {
        ArrayList valueList = (ArrayList)this.mTableViewer.getInput();
        valueList.removeAll(entities);
        this.setInput(valueList);
    }

    private void setInput(List input) {
        this.mTableViewer.setInput((Object)input);
        ArrayList newInput = new ArrayList();
        newInput.addAll(input);
        this.model.setProperty(this.propertyName, newInput);
    }

    public TableViewer getTableViewer() {
        return this.mTableViewer;
    }

    private class AddFieldDialog
    extends Dialog
    implements ModifyListener,
    SelectionListener {
        protected String windowTitle;
        protected String[] labelsForCombo;
        protected String[] labelsForText;
        protected Text[] texts;
        protected EntityRow entityRow;
        protected Combo combo;

        public AddFieldDialog(Shell shell, String windowTitle, String[] labelsForCombo, String[] labelsForText) {
            super(shell);
            this.windowTitle = windowTitle;
            this.labelsForCombo = labelsForCombo;
            this.labelsForText = labelsForText;
        }

        public Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.getShell().setText(this.windowTitle);
            GridLayout layout = new GridLayout();
            layout.numColumns = 4;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.horizontalAlignment = 4;
            data.widthHint = 300;
            composite.setLayoutData((Object)data);
            Label label = new Label(composite, 16384);
            label.setText(this.labelsForText[0]);
            label.setLayoutData((Object)new GridData(32));
            this.combo = new Combo(composite, 2052);
            this.combo.setItems(this.labelsForCombo);
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.combo.setLayoutData((Object)data);
            Button browseButton = new Button(composite, 8);
            browseButton.setText(EntityWizardMsg.BROWSE_BUTTON_LABEL);
            GridData browseButtonData = new GridData(256);
            browseButtonData.horizontalSpan = 1;
            browseButton.setLayoutData((Object)browseButtonData);
            browseButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AddFieldDialog.this.handleChooseEntityTypeButtonPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            int n = this.labelsForText.length;
            this.texts = new Text[n - 1];
            int i = 1;
            while (i < n) {
                Label labelI = new Label(composite, 16384);
                labelI.setText(this.labelsForText[i]);
                labelI.setLayoutData((Object)new GridData(32));
                this.texts[i - 1] = new Text(composite, 2052);
                data = new GridData(768);
                data.widthHint = 100;
                this.texts[i - 1].setLayoutData((Object)data);
                ++i;
            }
            this.combo.setFocus();
            Dialog.applyDialogFont((Control)parent);
            return composite;
        }

        private void handleChooseEntityTypeButtonPressed() {
            IPackageFragmentRoot packRoot = (IPackageFragmentRoot)EntityRowTableWizardSection.this.model.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
            if (packRoot == null) {
                return;
            }
            IJavaSearchScope scope = TypeSearchEngine.createJavaSearchScopeForAProject((IJavaProject)packRoot.getJavaProject(), (boolean)true, (boolean)true);
            FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, null, scope, 0);
            dialog.setTitle(EntityWizardMsg.TYPE_DIALOG_TITLE);
            dialog.setMessage(EntityWizardMsg.TYPE_DIALOG_DESCRIPTION);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getFirstResult();
                String superclassFullPath = "";
                if (type != null) {
                    superclassFullPath = type.getFullyQualifiedName();
                }
                this.combo.setText(superclassFullPath);
                return;
            }
        }

        protected Control createContents(Composite parent) {
            Composite composite = (Composite)super.createContents(parent);
            this.combo.addSelectionListener((SelectionListener)this);
            int i = 0;
            while (i < this.texts.length) {
                this.texts[i].addModifyListener((ModifyListener)this);
                ++i;
            }
            this.updateOKButton();
            return composite;
        }

        protected void okPressed() {
            this.entityRow = EntityRowTableWizardSection.this.callback.retrieveResultStrings(this.combo, this.texts);
            super.okPressed();
        }

        public EntityRow getEntityRow() {
            return this.entityRow;
        }

        public void modifyText(ModifyEvent e) {
            this.updateOKButton();
        }

        private void updateOKButton() {
            this.getButton(0).setEnabled(EntityRowTableWizardSection.this.callback.validate(this.combo, this.texts));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateOKButton();
        }
    }

    public static interface DialogCallback {
        public boolean validate(Combo var1, Text[] var2);

        public EntityRow retrieveResultStrings(Combo var1, Text[] var2);
    }

    private class EditFieldDialog
    extends AddFieldDialog {
        protected EntityRow entityRow;

        public EditFieldDialog(Shell shell, String windowTitle, String[] labelsForCombo, String[] labelsForText, EntityRow entity) {
            super(shell, windowTitle, labelsForCombo, labelsForText);
            this.entityRow = entity;
        }

        public Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.combo.setText(this.entityRow.getFqnTypeName());
            this.texts[0].setText(this.entityRow.getName());
            return composite;
        }
    }

    protected class EntityRowContentProvider
    implements IStructuredContentProvider {
        protected EntityRowContentProvider() {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public Object[] getElements(Object element) {
            if (element instanceof List) {
                return ((List)element).toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    protected class EntityRowLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected EntityRowLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return EntityRowTableWizardSection.this.labelProviderImage;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            EntityRow entity = (EntityRow)element;
            if (columnIndex == 1) {
                return entity.getName();
            }
            if (columnIndex == 2) {
                return entity.getFqnTypeName();
            }
            if (entity.couldBeKey()) {
                EntityRowTableWizardSection.this.mTableViewer.setChecked((Object)entity, entity.isKey());
            }
            return "";
        }

        public Image getImage(Object element) {
            return EntityRowTableWizardSection.this.labelProviderImage;
        }

        public String getText(Object element) {
            String[] array = (String[])element;
            if (array.length > 0) {
                return array[0];
            }
            return super.getText(element);
        }
    }

    public class FieldDialogCallback
    implements DialogCallback {
        public boolean validate(Combo combo, Text[] texts) {
            if (texts.length > 0) {
                return texts[0].getText().trim().length() > 0;
            }
            return true;
        }

        public EntityRow retrieveResultStrings(Combo combo, Text[] texts) {
            EntityRow entity = new EntityRow();
            entity.setFqnTypeName(combo.getText());
            entity.setName(texts[0].getText());
            return entity;
        }
    }

    private class PKFieldCheckStateListener
    implements ICheckStateListener {
        private PKFieldCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object[] checkedElements = EntityRowTableWizardSection.this.mTableViewer.getCheckedElements();
            ArrayList<String> pkFields = new ArrayList<String>();
            Object[] objectArray = checkedElements;
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                EntityRow entity = (EntityRow)object;
                if (entity.couldBeKey()) {
                    pkFields.add(entity.getName());
                } else {
                    EntityRowTableWizardSection.this.mTableViewer.setChecked((Object)entity, false);
                }
                ++n2;
            }
            EntityRowTableWizardSection.this.model.setProperty("IEntityDataModelProperties.PK_FIELDS", pkFields);
        }
    }
}

