/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.RandomAccess;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.Range;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.GenericIteratorWrapper;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionTools {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final Random RANDOM = new Random();

    private static <E> E[] newArray(E[] array, int length) {
        return (Object[])Array.newInstance(array.getClass().getComponentType(), length);
    }

    public static <E> E[] add(E[] array, E value) {
        int len = array.length;
        E[] result = CollectionTools.newArray(array, len + 1);
        if (len > 0) {
            System.arraycopy(array, 0, result, 0, len);
        }
        result[len] = value;
        return result;
    }

    public static <E> E[] add(E[] array, int index, E value) {
        int len = array.length;
        E[] result = CollectionTools.newArray(array, len + 1);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        result[index] = value;
        if (len > index) {
            System.arraycopy(array, index, result, index + 1, len - index);
        }
        return result;
    }

    public static char[] add(char[] array, char value) {
        int len = array.length;
        char[] result = new char[len + 1];
        if (len > 0) {
            System.arraycopy(array, 0, result, 0, len);
        }
        result[len] = value;
        return result;
    }

    public static char[] add(char[] array, int index, char value) {
        int len = array.length;
        char[] result = new char[len + 1];
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        result[index] = value;
        if (len > index) {
            System.arraycopy(array, index, result, index + 1, len - index);
        }
        return result;
    }

    public static int[] add(int[] array, int value) {
        int len = array.length;
        int[] result = new int[len + 1];
        if (len > 0) {
            System.arraycopy(array, 0, result, 0, len);
        }
        result[len] = value;
        return result;
    }

    public static int[] add(int[] array, int index, int value) {
        int len = array.length;
        int[] result = new int[len + 1];
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        result[index] = value;
        if (len > index) {
            System.arraycopy(array, index, result, index + 1, len - index);
        }
        return result;
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterable<? extends E> iterable) {
        return CollectionTools.addAll(collection, iterable.iterator());
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterable<? extends E> iterable, int size) {
        return CollectionTools.addAll(collection, iterable.iterator(), size);
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterator<? extends E> iterator) {
        return iterator.hasNext() ? collection.addAll(CollectionTools.list(iterator)) : false;
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterator<? extends E> iterator, int size) {
        return iterator.hasNext() ? collection.addAll(CollectionTools.list(iterator, size)) : false;
    }

    public static <E> boolean addAll(Collection<? super E> collection, E[] array) {
        return array.length == 0 ? false : collection.addAll(Arrays.asList(array));
    }

    public static <E> boolean addAll(List<? super E> list, int index, Iterable<E> iterable) {
        return CollectionTools.addAll(list, index, iterable.iterator());
    }

    public static <E> boolean addAll(List<? super E> list, int index, Iterable<E> iterable, int size) {
        return CollectionTools.addAll(list, index, iterable.iterator(), size);
    }

    public static <E> boolean addAll(List<? super E> list, int index, Iterator<? extends E> iterator) {
        return iterator.hasNext() ? list.addAll(index, CollectionTools.list(iterator)) : false;
    }

    public static <E> boolean addAll(List<? super E> list, int index, Iterator<? extends E> iterator, int size) {
        return iterator.hasNext() ? list.addAll(index, CollectionTools.list(iterator, size)) : false;
    }

    public static <E> boolean addAll(List<? super E> list, int index, E[] array) {
        return array.length == 0 ? false : list.addAll(index, Arrays.asList(array));
    }

    public static <E> E[] addAll(E[] array, Collection<? extends E> collection) {
        int size = collection.size();
        return size == 0 ? array : CollectionTools.addAll(array, collection, size);
    }

    private static <E> E[] addAll_(E[] array, Collection<? extends E> collection) {
        return CollectionTools.addAll(array, collection, collection.size());
    }

    private static <E> E[] addAll(E[] array, Collection<? extends E> collection, int collectionSize) {
        int len = array.length;
        E[] result = CollectionTools.newArray(array, len + collectionSize);
        if (len > 0) {
            System.arraycopy(array, 0, result, 0, len);
        }
        int i = len;
        for (E item : collection) {
            result[i++] = item;
        }
        return result;
    }

    public static <E> E[] addAll(E[] array, Iterable<? extends E> iterable) {
        return CollectionTools.addAll(array, iterable.iterator());
    }

    public static <E> E[] addAll(E[] array, Iterable<? extends E> iterable, int size) {
        return CollectionTools.addAll(array, iterable.iterator(), size);
    }

    public static <E> E[] addAll(E[] array, Iterator<? extends E> iterator) {
        return iterator.hasNext() ? CollectionTools.addAll_(array, CollectionTools.list(iterator)) : array;
    }

    public static <E> E[] addAll(E[] array, Iterator<? extends E> iterator, int size) {
        return iterator.hasNext() ? CollectionTools.addAll_(array, CollectionTools.list(iterator, size)) : array;
    }

    public static <E> E[] addAll(E[] array1, E[] array2) {
        int array2Length = array2.length;
        return array2Length == 0 ? array1 : CollectionTools.addAll(array1, array2, array2Length);
    }

    private static <E> E[] addAll(E[] array1, E[] array2, int array2Length) {
        int array1Length = array1.length;
        return array1Length == 0 ? array2 : CollectionTools.addAll(array1, array2, array1Length, array2Length);
    }

    private static <E> E[] addAll(E[] array1, E[] array2, int array1Length, int array2Length) {
        E[] result = CollectionTools.newArray(array1, array1Length + array2Length);
        System.arraycopy(array1, 0, result, 0, array1Length);
        System.arraycopy(array2, 0, result, array1Length, array2Length);
        return result;
    }

    public static <E> E[] addAll(E[] array1, int index, E[] array2) {
        int array2Length = array2.length;
        return array2Length == 0 ? array1 : CollectionTools.addAll(array1, index, array2, array2Length);
    }

    private static <E> E[] addAll(E[] array1, int index, E[] array2, int array2Length) {
        int array1Length = array1.length;
        return index == array1Length ? (array1Length == 0 ? array2 : CollectionTools.addAll(array1, array2, array1Length, array2Length)) : CollectionTools.addAll(array1, index, array2, array1Length, array2Length);
    }

    private static <E> E[] addAll(E[] array1, int index, E[] array2, int array1Length, int array2Length) {
        E[] result = CollectionTools.newArray(array1, array1Length + array2Length);
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, array2Length);
        System.arraycopy(array1, index, result, index + array2Length, array1Length - index);
        return result;
    }

    public static <E> E[] addAll(E[] array, int index, Collection<? extends E> collection) {
        int size = collection.size();
        return size == 0 ? array : CollectionTools.addAll(array, index, collection, size);
    }

    private static <E> E[] addAll_(E[] array, int index, Collection<? extends E> collection) {
        return CollectionTools.addAll(array, index, collection, collection.size());
    }

    private static <E> E[] addAll(E[] array, int index, Collection<? extends E> collection, int collectionSize) {
        int arrayLength = array.length;
        E[] result = CollectionTools.newArray(array, arrayLength + collectionSize);
        if (arrayLength == 0 && index == 0) {
            return collection.toArray(result);
        }
        System.arraycopy(array, 0, result, 0, index);
        int i = index;
        for (E item : collection) {
            result[i++] = item;
        }
        System.arraycopy(array, index, result, index + collectionSize, arrayLength - index);
        return result;
    }

    public static <E> E[] addAll(E[] array, int index, Iterable<? extends E> iterable) {
        return CollectionTools.addAll(array, index, iterable.iterator());
    }

    public static <E> E[] addAll(E[] array, int index, Iterable<? extends E> iterable, int size) {
        return CollectionTools.addAll(array, index, iterable.iterator(), size);
    }

    public static <E> E[] addAll(E[] array, int index, Iterator<? extends E> iterator) {
        return iterator.hasNext() ? CollectionTools.addAll_(array, index, CollectionTools.list(iterator)) : array;
    }

    public static <E> E[] addAll(E[] array, int index, Iterator<? extends E> iterator, int size) {
        return iterator.hasNext() ? CollectionTools.addAll_(array, index, CollectionTools.list(iterator, size)) : array;
    }

    public static char[] addAll(char[] array1, char[] array2) {
        int array2Length = array2.length;
        return array2Length == 0 ? array1 : CollectionTools.addAll(array1, array2, array2Length);
    }

    private static char[] addAll(char[] array1, char[] array2, int array2Length) {
        int array1Length = array1.length;
        return array1Length == 0 ? array2 : CollectionTools.addAll(array1, array2, array1Length, array2Length);
    }

    private static char[] addAll(char[] array1, char[] array2, int array1Length, int array2Length) {
        char[] result = new char[array1Length + array2Length];
        System.arraycopy(array1, 0, result, 0, array1Length);
        System.arraycopy(array2, 0, result, array1Length, array2Length);
        return result;
    }

    public static char[] addAll(char[] array1, int index, char[] array2) {
        int array2Length = array2.length;
        return array2Length == 0 ? array1 : CollectionTools.addAll(array1, index, array2, array2Length);
    }

    private static char[] addAll(char[] array1, int index, char[] array2, int array2Length) {
        int array1Length = array1.length;
        return index == array1Length ? (array1Length == 0 ? array2 : CollectionTools.addAll(array1, array2, array1Length, array2Length)) : CollectionTools.addAll(array1, index, array2, array1Length, array2Length);
    }

    private static char[] addAll(char[] array1, int index, char[] array2, int array1Length, int array2Length) {
        char[] result = new char[array1Length + array2Length];
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, array2Length);
        System.arraycopy(array1, index, result, index + array2Length, array1Length - index);
        return result;
    }

    public static int[] addAll(int[] array1, int[] array2) {
        int array2Length = array2.length;
        return array2Length == 0 ? array1 : CollectionTools.addAll(array1, array2, array2Length);
    }

    private static int[] addAll(int[] array1, int[] array2, int array2Length) {
        int array1Length = array1.length;
        return array1Length == 0 ? array2 : CollectionTools.addAll(array1, array2, array1Length, array2Length);
    }

    private static int[] addAll(int[] array1, int[] array2, int array1Length, int array2Length) {
        int[] result = new int[array1Length + array2Length];
        System.arraycopy(array1, 0, result, 0, array1Length);
        System.arraycopy(array2, 0, result, array1Length, array2Length);
        return result;
    }

    public static int[] addAll(int[] array1, int index, int[] array2) {
        int array2Length = array2.length;
        return array2Length == 0 ? array1 : CollectionTools.addAll(array1, index, array2, array2Length);
    }

    private static int[] addAll(int[] array1, int index, int[] array2, int array2Length) {
        int array1Length = array1.length;
        return index == array1Length ? (array1Length == 0 ? array2 : CollectionTools.addAll(array1, array2, array1Length, array2Length)) : CollectionTools.addAll(array1, index, array2, array1Length, array2Length);
    }

    private static int[] addAll(int[] array1, int index, int[] array2, int array1Length, int array2Length) {
        int[] result = new int[array1Length + array2Length];
        System.arraycopy(array1, 0, result, 0, index);
        System.arraycopy(array2, 0, result, index, array2Length);
        System.arraycopy(array1, index, result, index + array2Length, array1Length - index);
        return result;
    }

    public static Object[] array(Iterable<?> iterable) {
        return CollectionTools.array(iterable.iterator());
    }

    public static Object[] array(Iterable<?> iterable, int size) {
        return CollectionTools.array(iterable.iterator(), size);
    }

    public static <E> E[] array(Iterable<? extends E> iterable, E[] array) {
        return CollectionTools.array(iterable.iterator(), array);
    }

    public static <E> E[] array(Iterable<? extends E> iterable, int size, E[] array) {
        return CollectionTools.array(iterable.iterator(), size, array);
    }

    public static Object[] array(Iterator<?> iterator) {
        return iterator.hasNext() ? CollectionTools.list(iterator).toArray() : EMPTY_OBJECT_ARRAY;
    }

    public static Object[] array(Iterator<?> iterator, int size) {
        return iterator.hasNext() ? CollectionTools.list(iterator, size).toArray() : EMPTY_OBJECT_ARRAY;
    }

    public static <E> E[] array(Iterator<? extends E> iterator, E[] array) {
        return iterator.hasNext() ? CollectionTools.list(iterator).toArray(array) : CollectionTools.newArray(array, 0);
    }

    public static <E> E[] array(Iterator<? extends E> iterator, int size, E[] array) {
        return iterator.hasNext() ? CollectionTools.list(iterator, size).toArray(array) : CollectionTools.newArray(array, 0);
    }

    public static <E> HashBag<E> bag(Enumeration<? extends E> enumeration) {
        return CollectionTools.bag(enumeration, new HashBag());
    }

    public static <E> HashBag<E> bag(Enumeration<? extends E> enumeration, int size) {
        return CollectionTools.bag(enumeration, new HashBag(size));
    }

    private static <E> HashBag<E> bag(Enumeration<? extends E> enumeration, HashBag<E> bag) {
        while (enumeration.hasMoreElements()) {
            bag.add(enumeration.nextElement());
        }
        return bag;
    }

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable) {
        return CollectionTools.bag(iterable.iterator());
    }

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable, int size) {
        return CollectionTools.bag(iterable.iterator(), size);
    }

    public static <E> HashBag<E> bag(Iterator<? extends E> iterator) {
        return CollectionTools.bag(iterator, new HashBag());
    }

    public static <E> HashBag<E> bag(Iterator<? extends E> iterator, int size) {
        return CollectionTools.bag(iterator, new HashBag(size));
    }

    private static <E> HashBag<E> bag(Iterator<? extends E> iterator, HashBag<E> bag) {
        while (iterator.hasNext()) {
            bag.add(iterator.next());
        }
        return bag;
    }

    public static <E> HashBag<E> bag(E ... array) {
        int len = array.length;
        HashBag<E> bag = new HashBag<E>(len);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            bag.add(item);
            ++n2;
        }
        return bag;
    }

    public static <E> E[] clear(E[] array) {
        if (array.length == 0) {
            return array;
        }
        return CollectionTools.newArray(array, 0);
    }

    public static <E> HashBag<E> collection(Enumeration<? extends E> enumeration) {
        return CollectionTools.bag(enumeration);
    }

    public static <E> HashBag<E> collection(Enumeration<? extends E> enumeration, int size) {
        return CollectionTools.bag(enumeration, size);
    }

    public static <E> HashBag<E> collection(Iterable<? extends E> iterable) {
        return CollectionTools.collection(iterable.iterator());
    }

    public static <E> HashBag<E> collection(Iterable<? extends E> iterable, int size) {
        return CollectionTools.collection(iterable.iterator(), size);
    }

    public static <E> HashBag<E> collection(Iterator<? extends E> iterator) {
        return CollectionTools.bag(iterator);
    }

    public static <E> HashBag<E> collection(Iterator<? extends E> iterator, int size) {
        return CollectionTools.bag(iterator, size);
    }

    public static <E> HashBag<E> collection(E ... array) {
        return CollectionTools.bag(array);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(Enumeration<?> enumeration, Object value) {
        block2: {
            if (value != null) ** GOTO lbl8
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() != null) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(enumeration.nextElement())) continue;
                return true;
lbl8:
                // 2 sources

                ** while (enumeration.hasMoreElements())
            }
        }
        return false;
    }

    public static boolean contains(Iterable<?> iterable, Object value) {
        return CollectionTools.contains(iterable.iterator(), value);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(Iterator<?> iterator, Object value) {
        block2: {
            if (value != null) ** GOTO lbl8
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(iterator.next())) continue;
                return true;
lbl8:
                // 2 sources

                ** while (iterator.hasNext())
            }
        }
        return false;
    }

    public static boolean contains(Object[] array, Object value) {
        if (value == null) {
            int i = array.length;
            while (i-- > 0) {
                if (array[i] != null) continue;
                return true;
            }
        } else {
            int i = array.length;
            while (i-- > 0) {
                if (!value.equals(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(char[] array, char value) {
        return CollectionTools.contains(array, value, array.length);
    }

    private static boolean contains(char[] array, char value, int arrayLength) {
        int i = arrayLength;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array, int value) {
        return CollectionTools.contains(array, value, array.length);
    }

    private static boolean contains(int[] array, int value, int arrayLength) {
        int i = arrayLength;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.containsAll(collection, iterable.iterator());
    }

    public static boolean containsAll(Collection<?> collection, Iterator<?> iterator) {
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Collection<?> collection, Object[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (collection.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Iterable<?> iterable, Collection<?> collection) {
        return CollectionTools.containsAll(iterable.iterator(), collection);
    }

    public static boolean containsAll(Iterable<?> iterable, int size, Collection<?> collection) {
        return CollectionTools.containsAll(iterable.iterator(), size, collection);
    }

    public static boolean containsAll(Iterable<?> iterable1, Iterable<?> iterable2) {
        return CollectionTools.containsAll(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean containsAll(Iterable<?> iterable1, int size, Iterable<?> iterable2) {
        return CollectionTools.containsAll(iterable1.iterator(), size, iterable2.iterator());
    }

    public static boolean containsAll(Iterable<?> iterable, Iterator<?> iterator) {
        return CollectionTools.containsAll(iterable.iterator(), iterator);
    }

    public static boolean containsAll(Iterable<?> iterable, int size, Iterator<?> iterator) {
        return CollectionTools.containsAll(iterable.iterator(), size, iterator);
    }

    public static boolean containsAll(Iterable<?> iterable, Object[] array) {
        return CollectionTools.containsAll(iterable.iterator(), array);
    }

    public static boolean containsAll(Iterable<?> iterable, int size, Object[] array) {
        return CollectionTools.containsAll(iterable.iterator(), size, array);
    }

    public static boolean containsAll(Iterator<?> iterator, Collection<?> collection) {
        return CollectionTools.collection(iterator).containsAll(collection);
    }

    public static boolean containsAll(Iterator<?> iterator, int size, Collection<?> collection) {
        return CollectionTools.collection(iterator, size).containsAll(collection);
    }

    public static boolean containsAll(Iterator<?> iterator, Iterable<?> iterable) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator), iterable);
    }

    public static boolean containsAll(Iterator<?> iterator, int size, Iterable<?> iterable) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator, size), iterable);
    }

    public static boolean containsAll(Iterator<?> iterator1, Iterator<?> iterator2) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator1), iterator2);
    }

    public static boolean containsAll(Iterator<?> iterator1, int size, Iterator<?> iterator2) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator1, size), iterator2);
    }

    public static boolean containsAll(Iterator<?> iterator, Object[] array) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator), array);
    }

    public static boolean containsAll(Iterator<?> iterator, int size, Object[] array) {
        return CollectionTools.containsAll(CollectionTools.collection(iterator, size), array);
    }

    public static boolean containsAll(Object[] array, Collection<?> collection) {
        return CollectionTools.containsAll(array, collection.iterator());
    }

    public static boolean containsAll(Object[] array, Iterable<?> iterable) {
        return CollectionTools.containsAll(array, iterable.iterator());
    }

    public static boolean containsAll(Object[] array, Iterator<?> iterator) {
        while (iterator.hasNext()) {
            if (CollectionTools.contains(array, iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Object[] array1, Object[] array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (CollectionTools.contains(array1, array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(char[] array1, char[] array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (CollectionTools.contains(array1, array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(int[] array1, int[] array2) {
        int i = array2.length;
        while (i-- > 0) {
            if (CollectionTools.contains(array1, array2[i])) continue;
            return false;
        }
        return true;
    }

    public static int diffEnd(Object[] array1, Object[] array2) {
        return CollectionTools.diffEnd(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static int diffEnd(List<?> list1, List<?> list2) {
        int size2;
        int size1 = list1.size();
        if (size1 != (size2 = list2.size())) {
            return Math.max(size1, size2) - 1;
        }
        int end = size1 - 1;
        while (end > -1) {
            Object o = list1.get(end);
            if (o == null) {
                if (list2.get(end) == null) {
                    --end;
                    continue;
                }
                return end;
            }
            if (o.equals(list2.get(end))) {
                --end;
                continue;
            }
            return end;
        }
        return end;
    }

    public static Range diffRange(Object[] array1, Object[] array2) {
        return CollectionTools.diffRange(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static Range diffRange(List<?> list1, List<?> list2) {
        int end = CollectionTools.diffEnd(list1, list2);
        if (end == -1) {
            return new Range(list1.size(), end);
        }
        return new Range(CollectionTools.diffStart(list1, list2), end);
    }

    public static int diffStart(Object[] array1, Object[] array2) {
        return CollectionTools.diffStart(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static int diffStart(List<?> list1, List<?> list2) {
        int end = Math.min(list1.size(), list2.size());
        int start = 0;
        while (start < end) {
            Object o = list1.get(start);
            if (o == null) {
                if (list2.get(start) == null) {
                    ++start;
                    continue;
                }
                return start;
            }
            if (o.equals(list2.get(start))) {
                ++start;
                continue;
            }
            return start;
        }
        return start;
    }

    public static boolean equals(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            Object o1 = iterator1.next();
            Object o2 = iterator2.next();
            if (!(o1 == null ? o2 != null : !o1.equals(o2))) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static <E> E get(ListIterator<? extends E> iterator, int index) {
        while (iterator.hasNext()) {
            E next = iterator.next();
            if (iterator.previousIndex() != index) continue;
            return next;
        }
        throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(index)) + ':' + String.valueOf(iterator.previousIndex()));
    }

    public static boolean identical(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        int length = array1.length;
        if (array2.length != length) {
            return false;
        }
        int i = length;
        while (i-- > 0) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean identical(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (iterator1.next() == iterator2.next()) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static int identityDiffEnd(Object[] array1, Object[] array2) {
        return CollectionTools.identityDiffEnd(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static int identityDiffEnd(List<?> list1, List<?> list2) {
        int end;
        int size2;
        int size1 = list1.size();
        if (size1 != (size2 = list2.size())) {
            return Math.max(size1, size2) - 1;
        }
        for (end = size1 - 1; end > -1; --end) {
            if (list1.get(end) == list2.get(end)) {
                continue;
            }
            return end;
        }
        return end;
    }

    public static Range identityDiffRange(Object[] array1, Object[] array2) {
        return CollectionTools.identityDiffRange(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static Range identityDiffRange(List<?> list1, List<?> list2) {
        int end = CollectionTools.identityDiffEnd(list1, list2);
        if (end == -1) {
            return new Range(list1.size(), end);
        }
        return new Range(CollectionTools.identityDiffStart(list1, list2), end);
    }

    public static int identityDiffStart(Object[] array1, Object[] array2) {
        return CollectionTools.identityDiffStart(Arrays.asList(array1), Arrays.asList(array2));
    }

    public static int identityDiffStart(List<?> list1, List<?> list2) {
        int start;
        int end = Math.min(list1.size(), list2.size());
        for (start = 0; start < end; ++start) {
            if (list1.get(start) == list2.get(start)) {
                continue;
            }
            return start;
        }
        return start;
    }

    public static int indexOf(Iterator<?> iterator, Object value) {
        if (value == null) {
            int i = 0;
            while (iterator.hasNext()) {
                if (iterator.next() == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (iterator.hasNext()) {
                if (value.equals(iterator.next())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int indexOf(Object[] array, Object value) {
        int len = array.length;
        if (value == null) {
            int i = 0;
            while (i < len) {
                if (array[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (value.equals(array[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] array, char value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int value) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <E extends Comparable<? super E>> int insertionIndexOf(List<E> sortedList, Comparable<E> value) {
        int len = sortedList.size();
        int i = 0;
        while (i < len) {
            if (value.compareTo((Comparable)sortedList.get(i)) < 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static <E> int insertionIndexOf(List<E> sortedList, E value, Comparator<? super E> comparator) {
        int len = sortedList.size();
        int i = 0;
        while (i < len) {
            if (comparator.compare(value, sortedList.get(i)) < 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static <E extends Comparable<? super E>> int insertionIndexOf(E[] sortedArray, Comparable<E> value) {
        int len = sortedArray.length;
        int i = 0;
        while (i < len) {
            if (value.compareTo(sortedArray[i]) < 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static <E> int insertionIndexOf(E[] sortedArray, E value, Comparator<? super E> comparator) {
        int len = sortedArray.length;
        int i = 0;
        while (i < len) {
            if (comparator.compare(value, sortedArray[i]) < 0) {
                return i;
            }
            ++i;
        }
        return len;
    }

    public static <E> Iterable<E> iterable(Iterator<? extends E> iterator) {
        return new SingleUseIterable<E>(iterator);
    }

    public static <E> Iterable<E> iterable(E ... array) {
        return Arrays.asList(array);
    }

    public static <E> Iterator<E> iterator(E ... array) {
        return new ArrayIterator<E>(array);
    }

    public static int lastIndexOf(Iterator<?> iterator, Object value) {
        return iterator.hasNext() ? CollectionTools.list(iterator).lastIndexOf(value) : -1;
    }

    public static int lastIndexOf(Iterator<?> iterator, int size, Object value) {
        return iterator.hasNext() ? CollectionTools.list(iterator, size).lastIndexOf(value) : -1;
    }

    public static int lastIndexOf(Object[] array, Object value) {
        int len = array.length;
        if (value == null) {
            int i = len;
            while (i-- > 0) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            int i = len;
            while (i-- > 0) {
                if (!value.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int value) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static <E> ArrayList<E> list(Iterable<? extends E> iterable) {
        return CollectionTools.list(iterable.iterator());
    }

    public static <E> ArrayList<E> list(Iterable<? extends E> iterable, int size) {
        return CollectionTools.list(iterable.iterator(), size);
    }

    public static <E> ArrayList<E> list(Iterator<? extends E> iterator) {
        return CollectionTools.list(iterator, new ArrayList());
    }

    public static <E> ArrayList<E> list(Iterator<? extends E> iterator, int size) {
        return CollectionTools.list(iterator, new ArrayList(size));
    }

    private static <E> ArrayList<E> list(Iterator<? extends E> iterator, ArrayList<E> list) {
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <E> ArrayList<E> list(E ... array) {
        ArrayList<E> list = new ArrayList<E>(array.length);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            list.add(item);
            ++n2;
        }
        return list;
    }

    public static <E> ListIterator<E> listIterator(E ... array) {
        return CollectionTools.listIterator(array, 0);
    }

    public static <E> ListIterator<E> listIterator(E[] array, int index) {
        return Arrays.asList(array).listIterator(index);
    }

    public static char max(char ... array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        char max = array[0];
        int i = 1;
        while (i < len) {
            char next = array[i];
            if (next > max) {
                max = next;
            }
            ++i;
        }
        return max;
    }

    public static int max(int ... array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int max = array[0];
        int i = 1;
        while (i < len) {
            int next = array[i];
            if (next > max) {
                max = next;
            }
            ++i;
        }
        return max;
    }

    public static char min(char ... array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        char min = array[0];
        int i = 1;
        while (i < len) {
            char next = array[i];
            if (next < min) {
                min = next;
            }
            ++i;
        }
        return min;
    }

    public static int min(int ... array) {
        int len = array.length;
        if (len == 0) {
            throw new IndexOutOfBoundsException();
        }
        int min = array[0];
        int i = 1;
        while (i < len) {
            int next = array[i];
            if (next < min) {
                min = next;
            }
            ++i;
        }
        return min;
    }

    public static <E> E[] move(E[] array, int targetIndex, int sourceIndex) {
        return targetIndex == sourceIndex ? array : CollectionTools.move_(array, targetIndex, sourceIndex);
    }

    private static <E> E[] move_(E[] array, int targetIndex, int sourceIndex) {
        E temp = array[sourceIndex];
        if (targetIndex < sourceIndex) {
            System.arraycopy(array, targetIndex, array, targetIndex + 1, sourceIndex - targetIndex);
        } else {
            System.arraycopy(array, sourceIndex + 1, array, sourceIndex, targetIndex - sourceIndex);
        }
        array[targetIndex] = temp;
        return array;
    }

    public static <E> E[] move(E[] array, int targetIndex, int sourceIndex, int length) {
        if (targetIndex == sourceIndex || length == 0) {
            return array;
        }
        if (length == 1) {
            return CollectionTools.move_(array, targetIndex, sourceIndex);
        }
        E[] temp = CollectionTools.newArray(array, length);
        System.arraycopy(array, sourceIndex, temp, 0, length);
        if (targetIndex < sourceIndex) {
            System.arraycopy(array, targetIndex, array, targetIndex + length, sourceIndex - targetIndex);
        } else {
            System.arraycopy(array, sourceIndex + length, array, sourceIndex, targetIndex - sourceIndex);
        }
        System.arraycopy(temp, 0, array, targetIndex, length);
        return array;
    }

    public static int[] move(int[] array, int targetIndex, int sourceIndex) {
        return targetIndex == sourceIndex ? array : CollectionTools.move_(array, targetIndex, sourceIndex);
    }

    private static int[] move_(int[] array, int targetIndex, int sourceIndex) {
        int temp = array[sourceIndex];
        if (targetIndex < sourceIndex) {
            System.arraycopy(array, targetIndex, array, targetIndex + 1, sourceIndex - targetIndex);
        } else {
            System.arraycopy(array, sourceIndex + 1, array, sourceIndex, targetIndex - sourceIndex);
        }
        array[targetIndex] = temp;
        return array;
    }

    public static int[] move(int[] array, int targetIndex, int sourceIndex, int length) {
        if (targetIndex == sourceIndex || length == 0) {
            return array;
        }
        if (length == 1) {
            return CollectionTools.move_(array, targetIndex, sourceIndex);
        }
        int[] temp = new int[length];
        System.arraycopy(array, sourceIndex, temp, 0, length);
        if (targetIndex < sourceIndex) {
            System.arraycopy(array, targetIndex, array, targetIndex + length, sourceIndex - targetIndex);
        } else {
            System.arraycopy(array, sourceIndex + length, array, sourceIndex, targetIndex - sourceIndex);
        }
        System.arraycopy(temp, 0, array, targetIndex, length);
        return array;
    }

    public static char[] move(char[] array, int targetIndex, int sourceIndex) {
        return targetIndex == sourceIndex ? array : CollectionTools.move_(array, targetIndex, sourceIndex);
    }

    private static char[] move_(char[] array, int targetIndex, int sourceIndex) {
        char temp = array[sourceIndex];
        if (targetIndex < sourceIndex) {
            System.arraycopy(array, targetIndex, array, targetIndex + 1, sourceIndex - targetIndex);
        } else {
            System.arraycopy(array, sourceIndex + 1, array, sourceIndex, targetIndex - sourceIndex);
        }
        array[targetIndex] = temp;
        return array;
    }

    public static char[] move(char[] array, int targetIndex, int sourceIndex, int length) {
        if (targetIndex == sourceIndex || length == 0) {
            return array;
        }
        if (length == 1) {
            return CollectionTools.move_(array, targetIndex, sourceIndex);
        }
        char[] temp = new char[length];
        System.arraycopy(array, sourceIndex, temp, 0, length);
        if (targetIndex < sourceIndex) {
            System.arraycopy(array, targetIndex, array, targetIndex + length, sourceIndex - targetIndex);
        } else {
            System.arraycopy(array, sourceIndex + length, array, sourceIndex, targetIndex - sourceIndex);
        }
        System.arraycopy(temp, 0, array, targetIndex, length);
        return array;
    }

    public static <E> List<E> move(List<E> list, int targetIndex, int sourceIndex) {
        return targetIndex == sourceIndex ? list : CollectionTools.move_(list, targetIndex, sourceIndex);
    }

    private static <E> List<E> move_(List<E> list, int targetIndex, int sourceIndex) {
        if (list instanceof RandomAccess) {
            E temp = list.get(sourceIndex);
            if (targetIndex < sourceIndex) {
                int i = sourceIndex;
                while (i-- > targetIndex) {
                    list.set(i + 1, list.get(i));
                }
            } else {
                int i = sourceIndex;
                while (i < targetIndex) {
                    list.set(i, list.get(i + 1));
                    ++i;
                }
            }
            list.set(targetIndex, temp);
        } else {
            list.add(targetIndex, list.remove(sourceIndex));
        }
        return list;
    }

    public static <E> List<E> move(List<E> list, int targetIndex, int sourceIndex, int length) {
        if (targetIndex == sourceIndex || length == 0) {
            return list;
        }
        if (length == 1) {
            return CollectionTools.move_(list, targetIndex, sourceIndex);
        }
        if (list instanceof RandomAccess) {
            int i;
            ArrayList<E> temp = new ArrayList<E>(list.subList(sourceIndex, sourceIndex + length));
            if (targetIndex < sourceIndex) {
                i = sourceIndex;
                while (i-- > targetIndex) {
                    list.set(i + length, list.get(i));
                }
            } else {
                i = sourceIndex;
                while (i < targetIndex) {
                    list.set(i, list.get(i + length));
                    ++i;
                }
            }
            i = 0;
            while (i < length) {
                list.set(targetIndex + i, temp.get(i));
                ++i;
            }
        } else {
            list.addAll(targetIndex, CollectionTools.removeElementsAtIndex(list, sourceIndex, length));
        }
        return list;
    }

    public static <E> E[] replaceAll(E[] array, Object oldValue, E newValue) {
        if (oldValue == null) {
            int i = array.length;
            while (i-- > 0) {
                if (array[i] != null) continue;
                array[i] = newValue;
            }
        } else {
            int i = array.length;
            while (i-- > 0) {
                if (!oldValue.equals(array[i])) continue;
                array[i] = newValue;
            }
        }
        return array;
    }

    public static int[] replaceAll(int[] array, int oldValue, int newValue) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != oldValue) continue;
            array[i] = newValue;
        }
        return array;
    }

    public static char[] replaceAll(char[] array, char oldValue, char newValue) {
        int i = array.length;
        while (i-- > 0) {
            if (array[i] != oldValue) continue;
            array[i] = newValue;
        }
        return array;
    }

    public static <E> E[] remove(E[] array, Object value) {
        return CollectionTools.removeElementAtIndex(array, CollectionTools.indexOf(array, value));
    }

    public static char[] remove(char[] array, char value) {
        return CollectionTools.removeElementAtIndex(array, CollectionTools.indexOf(array, value));
    }

    public static int[] remove(int[] array, int value) {
        return CollectionTools.removeElementAtIndex(array, CollectionTools.indexOf(array, value));
    }

    public static boolean removeAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.removeAll(collection, iterable.iterator());
    }

    public static boolean removeAll(Collection<?> collection, Iterable<?> iterable, int size) {
        return CollectionTools.removeAll(collection, iterable.iterator(), size);
    }

    public static boolean removeAll(Collection<?> collection, Iterator<?> iterator) {
        return iterator.hasNext() ? collection.removeAll(CollectionTools.set(iterator)) : false;
    }

    public static boolean removeAll(Collection<?> collection, Iterator<?> iterator, int size) {
        return iterator.hasNext() ? collection.removeAll(CollectionTools.set(iterator, size)) : false;
    }

    public static boolean removeAll(Collection<?> collection, Object[] array) {
        return collection.removeAll(CollectionTools.set(array));
    }

    public static <E> E[] removeAll(E[] array, Iterable<?> iterable) {
        return CollectionTools.removeAll(array, iterable.iterator());
    }

    public static <E> E[] removeAll(E[] array, Iterable<?> iterable, int size) {
        return CollectionTools.removeAll(array, iterable.iterator(), size);
    }

    public static <E> E[] removeAll(E[] array, Iterator<?> iterator) {
        return iterator.hasNext() ? CollectionTools.removeAll_(array, CollectionTools.set(iterator)) : array;
    }

    public static <E> E[] removeAll(E[] array, Iterator<?> iterator, int size) {
        return iterator.hasNext() ? CollectionTools.removeAll_(array, CollectionTools.set(iterator, size)) : array;
    }

    public static <E> E[] removeAll(E[] array, Collection<?> collection) {
        return collection.isEmpty() ? array : CollectionTools.removeAll_(array, collection);
    }

    private static <E> E[] removeAll_(E[] array, Collection<?> collection) {
        int arrayLength = array.length;
        return arrayLength == 0 ? array : CollectionTools.removeAll(array, collection, arrayLength);
    }

    private static <E> E[] removeAll(E[] array, Collection<?> collection, int arrayLength) {
        int[] indices = new int[arrayLength];
        int j = 0;
        int i = 0;
        while (i < arrayLength) {
            if (!collection.contains(array[i])) {
                indices[j++] = i;
            }
            ++i;
        }
        if (j == arrayLength) {
            return array;
        }
        E[] result = CollectionTools.newArray(array, j);
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static <E> E[] removeAll(E[] array1, Object[] array2) {
        return array2.length == 0 ? array1 : CollectionTools.removeAll_(array1, CollectionTools.set(array2));
    }

    public static char[] removeAll(char[] array1, char[] array2) {
        if (array2.length == 0) {
            return array1;
        }
        int array1Length = array1.length;
        if (array1Length == 0) {
            return array1;
        }
        int[] indices = new int[array1Length];
        int j = 0;
        int i = 0;
        while (i < array1Length) {
            if (!CollectionTools.contains(array2, array1[i])) {
                indices[j++] = i;
            }
            ++i;
        }
        if (j == array1Length) {
            return array1;
        }
        char[] result = new char[j];
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array1[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static int[] removeAll(int[] array1, int[] array2) {
        if (array2.length == 0) {
            return array1;
        }
        int array1Length = array1.length;
        if (array1Length == 0) {
            return array1;
        }
        int[] indices = new int[array1Length];
        int j = 0;
        int i = 0;
        while (i < array1Length) {
            if (!CollectionTools.contains(array2, array1[i])) {
                indices[j++] = i;
            }
            ++i;
        }
        if (j == array1Length) {
            return array1;
        }
        int[] result = new int[j];
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array1[indices[i2]];
            ++i2;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean removeAllOccurrences(Collection<?> collection, Object value) {
        block2: {
            modified = false;
            stream = collection.iterator();
            if (value != null) ** GOTO lbl13
            while (stream.hasNext()) {
                if (stream.next() != null) continue;
                stream.remove();
                modified = true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(stream.next())) continue;
                stream.remove();
                modified = true;
lbl13:
                // 3 sources

                ** while (stream.hasNext())
            }
        }
        return modified;
    }

    public static <E> E[] removeAllOccurrences(E[] array, Object value) {
        int i;
        int arrayLength = array.length;
        if (arrayLength == 0) {
            return array;
        }
        int[] indices = new int[arrayLength];
        int j = 0;
        if (value == null) {
            i = arrayLength;
            while (i-- > 0) {
                if (array[i] == null) continue;
                indices[j++] = i;
            }
        } else {
            i = array.length;
            while (i-- > 0) {
                if (value.equals(array[i])) continue;
                indices[j++] = i;
            }
        }
        if (j == arrayLength) {
            return array;
        }
        E[] result = CollectionTools.newArray(array, j);
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static char[] removeAllOccurrences(char[] array, char value) {
        int arrayLength = array.length;
        if (arrayLength == 0) {
            return array;
        }
        int[] indices = new int[arrayLength];
        int j = 0;
        int i = arrayLength;
        while (i-- > 0) {
            if (array[i] == value) continue;
            indices[j++] = i;
        }
        if (j == arrayLength) {
            return array;
        }
        char[] result = new char[j];
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static int[] removeAllOccurrences(int[] array, int value) {
        int arrayLength = array.length;
        if (arrayLength == 0) {
            return array;
        }
        int[] indices = new int[arrayLength];
        int j = 0;
        int i = arrayLength;
        while (i-- > 0) {
            if (array[i] == value) continue;
            indices[j++] = i;
        }
        if (j == arrayLength) {
            return array;
        }
        int[] result = new int[j];
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static <E> E[] removeElementAtIndex(E[] array, int index) {
        return CollectionTools.removeElementsAtIndex(array, index, 1);
    }

    public static char[] removeElementAtIndex(char[] array, int index) {
        return CollectionTools.removeElementsAtIndex(array, index, 1);
    }

    public static int[] removeElementAtIndex(int[] array, int index) {
        return CollectionTools.removeElementsAtIndex(array, index, 1);
    }

    public static <E> ArrayList<E> removeElementsAtIndex(List<E> list, int index, int length) {
        List<E> subList = list.subList(index, index + length);
        ArrayList<E> result = new ArrayList<E>(subList);
        subList.clear();
        return result;
    }

    public static <E> E[] removeElementsAtIndex(E[] array, int index, int length) {
        int arrayLength = array.length;
        int newLength = arrayLength - length;
        E[] result = CollectionTools.newArray(array, newLength);
        if (newLength == 0 && index == 0) {
            return result;
        }
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + length, result, index, newLength - index);
        return result;
    }

    public static char[] removeElementsAtIndex(char[] array, int index, int length) {
        int arrayLength = array.length;
        int newLength = arrayLength - length;
        if (newLength == 0 && index == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[newLength];
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + length, result, index, newLength - index);
        return result;
    }

    public static int[] removeElementsAtIndex(int[] array, int index, int length) {
        int arrayLength = array.length;
        int newLength = arrayLength - length;
        if (newLength == 0 && index == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[newLength];
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + length, result, index, newLength - index);
        return result;
    }

    public static <E> E[] removeDuplicateElements(E ... array) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        ArrayList<E> temp = CollectionTools.list(array);
        return CollectionTools.removeDuplicateElements(temp, len) ? temp.toArray(CollectionTools.newArray(array, temp.size())) : array;
    }

    public static <E> boolean removeDuplicateElements(List<E> list) {
        int size = list.size();
        if (size == 0 || size == 1) {
            return false;
        }
        return CollectionTools.removeDuplicateElements(list, size);
    }

    private static <E> boolean removeDuplicateElements(List<E> list, int size) {
        LinkedHashSet<E> temp = new LinkedHashSet<E>(size);
        boolean changed = false;
        for (E item : list) {
            if (temp.add(item)) continue;
            changed = true;
        }
        if (changed) {
            int i = 0;
            Iterator stream = temp.iterator();
            while (stream.hasNext()) {
                list.set(i, stream.next());
                ++i;
            }
            int tempSize = temp.size();
            i = list.size();
            while (i-- > tempSize) {
                list.remove(i);
            }
        }
        return changed;
    }

    public static boolean retainAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.retainAll(collection, iterable.iterator());
    }

    public static boolean retainAll(Collection<?> collection, Iterable<?> iterable, int size) {
        return CollectionTools.retainAll(collection, iterable.iterator(), size);
    }

    public static boolean retainAll(Collection<?> collection, Iterator<?> iterator) {
        if (iterator.hasNext()) {
            return collection.retainAll(CollectionTools.set(iterator));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Iterator<?> iterator, int size) {
        if (iterator.hasNext()) {
            return collection.retainAll(CollectionTools.set(iterator, size));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Object[] array) {
        if (array.length > 0) {
            return collection.retainAll(CollectionTools.set(array));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static <E> E[] retainAll(E[] array, Iterable<?> iterable) {
        int arrayLength = array.length;
        return arrayLength == 0 ? array : CollectionTools.retainAll(array, arrayLength, iterable.iterator());
    }

    public static <E> E[] retainAll(E[] array, Iterable<?> iterable, int size) {
        int arrayLength = array.length;
        return arrayLength == 0 ? array : CollectionTools.retainAll(array, arrayLength, iterable.iterator(), size);
    }

    public static <E> E[] retainAll(E[] array, Iterator<?> iterator) {
        int arrayLength = array.length;
        return arrayLength == 0 ? array : CollectionTools.retainAll(array, arrayLength, iterator);
    }

    public static <E> E[] retainAll(E[] array, Iterator<?> iterator, int size) {
        int arrayLength = array.length;
        return arrayLength == 0 ? array : CollectionTools.retainAll(array, arrayLength, iterator, size);
    }

    private static <E> E[] retainAll(E[] array, int arrayLength, Iterator<?> iterator) {
        return iterator.hasNext() ? CollectionTools.retainAll_(array, CollectionTools.set(iterator), arrayLength) : CollectionTools.newArray(array, 0);
    }

    private static <E> E[] retainAll(E[] array, int arrayLength, Iterator<?> iterator, int iteratorSize) {
        return iterator.hasNext() ? CollectionTools.retainAll_(array, CollectionTools.set(iterator, iteratorSize), arrayLength) : CollectionTools.newArray(array, 0);
    }

    public static <E> E[] retainAll(E[] array, Collection<?> collection) {
        int arrayLength = array.length;
        return arrayLength == 0 ? array : CollectionTools.retainAll(array, collection, arrayLength);
    }

    private static <E> E[] retainAll(E[] array, Collection<?> collection, int arrayLength) {
        return collection.isEmpty() ? CollectionTools.newArray(array, 0) : CollectionTools.retainAll_(array, collection, arrayLength);
    }

    private static <E> E[] retainAll_(E[] array, Collection<?> collection, int arrayLength) {
        int[] indices = new int[arrayLength];
        int j = 0;
        int i = 0;
        while (i < arrayLength) {
            if (collection.contains(array[i])) {
                indices[j++] = i;
            }
            ++i;
        }
        if (j == arrayLength) {
            return array;
        }
        E[] result = CollectionTools.newArray(array, j);
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static <E> E[] retainAll(E[] array1, Object[] array2) {
        int array1Length = array1.length;
        return array2.length == 0 ? (array1Length == 0 ? array1 : CollectionTools.newArray(array1, 0)) : CollectionTools.retainAll(array1, CollectionTools.set(array2), array1Length);
    }

    public static char[] retainAll(char[] array1, char[] array2) {
        int array1Length = array1.length;
        return array1Length == 0 ? array1 : CollectionTools.retainAll(array1, array2, array1Length);
    }

    private static char[] retainAll(char[] array1, char[] array2, int array1Length) {
        int array2Length = array2.length;
        return array2Length == 0 ? EMPTY_CHAR_ARRAY : CollectionTools.retainAll(array1, array2, array1Length, array2Length);
    }

    private static char[] retainAll(char[] array1, char[] array2, int array1Length, int array2Length) {
        int[] indices = new int[array1Length];
        int j = 0;
        int i = 0;
        while (i < array1Length) {
            if (CollectionTools.contains(array2, array1[i], array2Length)) {
                indices[j++] = i;
            }
            ++i;
        }
        if (j == array1Length) {
            return array1;
        }
        char[] result = new char[j];
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array1[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static int[] retainAll(int[] array1, int[] array2) {
        int array1Length = array1.length;
        return array1Length == 0 ? array1 : CollectionTools.retainAll(array1, array2, array1Length);
    }

    private static int[] retainAll(int[] array1, int[] array2, int array1Length) {
        int array2Length = array2.length;
        return array2Length == 0 ? EMPTY_INT_ARRAY : CollectionTools.retainAll(array1, array2, array1Length, array2Length);
    }

    private static int[] retainAll(int[] array1, int[] array2, int array1Length, int array2Length) {
        int[] indices = new int[array1Length];
        int j = 0;
        int i = 0;
        while (i < array1Length) {
            if (CollectionTools.contains(array2, array1[i], array2Length)) {
                indices[j++] = i;
            }
            ++i;
        }
        if (j == array1Length) {
            return array1;
        }
        int[] result = new int[j];
        int resultLength = result.length;
        int i2 = 0;
        while (i2 < resultLength) {
            result[i2] = array1[indices[i2]];
            ++i2;
        }
        return result;
    }

    public static <E> E[] reverse(E ... array) {
        int len = array.length;
        int i = 0;
        int mid = len >> 1;
        int j = len - 1;
        while (i < mid) {
            CollectionTools.swap(array, i, j);
            ++i;
            --j;
        }
        return array;
    }

    public static char[] reverse(char ... array) {
        int len = array.length;
        int i = 0;
        int mid = len >> 1;
        int j = len - 1;
        while (i < mid) {
            CollectionTools.swap(array, i, j);
            ++i;
            --j;
        }
        return array;
    }

    public static int[] reverse(int ... array) {
        int len = array.length;
        int i = 0;
        int mid = len >> 1;
        int j = len - 1;
        while (i < mid) {
            CollectionTools.swap(array, i, j);
            ++i;
            --j;
        }
        return array;
    }

    public static <E> List<E> reverseList(Iterable<? extends E> iterable) {
        return CollectionTools.reverse(CollectionTools.list(iterable));
    }

    public static <E> List<E> reverseList(Iterable<? extends E> iterable, int size) {
        return CollectionTools.reverse(CollectionTools.list(iterable, size));
    }

    public static <E> List<E> reverseList(Iterator<? extends E> iterator) {
        return CollectionTools.reverse(CollectionTools.list(iterator));
    }

    public static <E> List<E> reverseList(Iterator<? extends E> iterator, int size) {
        return CollectionTools.reverse(CollectionTools.list(iterator, size));
    }

    public static <E> E[] rotate(E ... array) {
        return CollectionTools.rotate(array, 1);
    }

    public static <E> E[] rotate(E[] array, int distance) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return array;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != len) {
            E displaced = array[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                E temp = array[i];
                array[i] = displaced;
                displaced = temp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
        return array;
    }

    public static char[] rotate(char ... array) {
        return CollectionTools.rotate(array, 1);
    }

    public static char[] rotate(char[] array, int distance) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return array;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != len) {
            char displaced = array[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                char temp = array[i];
                array[i] = displaced;
                displaced = temp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
        return array;
    }

    public static int[] rotate(int ... array) {
        return CollectionTools.rotate(array, 1);
    }

    public static int[] rotate(int[] array, int distance) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return array;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != len) {
            int displaced = array[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                int temp = array[i];
                array[i] = displaced;
                displaced = temp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
        return array;
    }

    public static <E> HashSet<E> set(Iterable<? extends E> iterable) {
        return CollectionTools.set(iterable.iterator());
    }

    public static <E> HashSet<E> set(Iterable<? extends E> iterable, int size) {
        return CollectionTools.set(iterable.iterator(), size);
    }

    public static <E> HashSet<E> set(Iterator<? extends E> iterator) {
        return CollectionTools.set(iterator, new HashSet());
    }

    public static <E> HashSet<E> set(Iterator<? extends E> iterator, int size) {
        return CollectionTools.set(iterator, new HashSet(size));
    }

    private static <E> HashSet<E> set(Iterator<? extends E> iterator, HashSet<E> set) {
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <E> HashSet<E> set(E ... array) {
        HashSet<E> set = new HashSet<E>(array.length);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            set.add(item);
            ++n2;
        }
        return set;
    }

    public static <E> E[] shuffle(E ... array) {
        return CollectionTools.shuffle(array, RANDOM);
    }

    public static <E> E[] shuffle(E[] array, Random random) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        int i = len;
        while (i-- > 0) {
            CollectionTools.swap(array, i, random.nextInt(len));
        }
        return array;
    }

    public static char[] shuffle(char ... array) {
        return CollectionTools.shuffle(array, RANDOM);
    }

    public static char[] shuffle(char[] array, Random random) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        int i = len;
        while (i-- > 0) {
            CollectionTools.swap(array, i, random.nextInt(len));
        }
        return array;
    }

    public static int[] shuffle(int ... array) {
        return CollectionTools.shuffle(array, RANDOM);
    }

    public static int[] shuffle(int[] array, Random random) {
        int len = array.length;
        if (len == 0 || len == 1) {
            return array;
        }
        int i = len;
        while (i-- > 0) {
            CollectionTools.swap(array, i, random.nextInt(len));
        }
        return array;
    }

    public static <E> Iterator<E> singletonIterator(E value) {
        return new SingleElementIterator<E>(value);
    }

    public static int size(Iterable<?> iterable) {
        return CollectionTools.size(iterable.iterator());
    }

    public static int size(Iterator<?> iterator) {
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterable<? extends E> iterable) {
        return CollectionTools.sortedSet(iterable, null);
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterable<? extends E> iterable, int size) {
        return CollectionTools.sortedSet(iterable, size, null);
    }

    public static <E> TreeSet<E> sortedSet(Iterable<? extends E> iterable, Comparator<? super E> comparator) {
        return CollectionTools.sortedSet(iterable.iterator(), comparator);
    }

    public static <E> TreeSet<E> sortedSet(Iterable<? extends E> iterable, int size, Comparator<? super E> comparator) {
        return CollectionTools.sortedSet(iterable.iterator(), size, comparator);
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterator<? extends E> iterator) {
        return CollectionTools.sortedSet(iterator, null);
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterator<? extends E> iterator, int size) {
        return CollectionTools.sortedSet(iterator, size, null);
    }

    public static <E> TreeSet<E> sortedSet(Iterator<? extends E> iterator, Comparator<? super E> comparator) {
        return CollectionTools.sortedSet(CollectionTools.list(iterator), comparator);
    }

    public static <E> TreeSet<E> sortedSet(Iterator<? extends E> iterator, int size, Comparator<? super E> comparator) {
        return CollectionTools.sortedSet(CollectionTools.list(iterator, size), comparator);
    }

    private static <E> TreeSet<E> sortedSet(List<E> list, Comparator<? super E> comparator) {
        TreeSet<E> sortedSet = new TreeSet<E>(comparator);
        sortedSet.addAll(list);
        return sortedSet;
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(E ... array) {
        return CollectionTools.sortedSet(array, null);
    }

    public static <E> TreeSet<E> sortedSet(E[] array, Comparator<? super E> comparator) {
        TreeSet<E> sortedSet = new TreeSet<E>(comparator);
        sortedSet.addAll(Arrays.asList(array));
        return sortedSet;
    }

    public static <E> E[] subArray(E[] array, int start, int length) {
        E[] result = CollectionTools.newArray(array, length);
        if (length > 0) {
            System.arraycopy(array, start, result, 0, length);
        }
        return result;
    }

    public static int[] subArray(int[] array, int start, int length) {
        int[] result = new int[length];
        if (length > 0) {
            System.arraycopy(array, start, result, 0, length);
        }
        return result;
    }

    public static char[] subArray(char[] array, int start, int length) {
        char[] result = new char[length];
        if (length > 0) {
            System.arraycopy(array, start, result, 0, length);
        }
        return result;
    }

    public static <E> E[] swap(E[] array, int i, int j) {
        E temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        return array;
    }

    public static char[] swap(char[] array, int i, int j) {
        char temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        return array;
    }

    public static int[] swap(int[] array, int i, int j) {
        int temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        return array;
    }

    public static <E> Vector<E> vector(Iterable<? extends E> iterable) {
        return CollectionTools.vector(iterable.iterator());
    }

    public static <E> Vector<E> vector(Iterable<? extends E> iterable, int size) {
        return CollectionTools.vector(iterable.iterator(), size);
    }

    public static <E> Vector<E> vector(Iterator<? extends E> iterator) {
        return CollectionTools.vector(iterator, new Vector());
    }

    public static <E> Vector<E> vector(Iterator<? extends E> iterator, int size) {
        return CollectionTools.vector(iterator, new Vector(size));
    }

    private static <E> Vector<E> vector(Iterator<? extends E> iterator, Vector<E> v) {
        while (iterator.hasNext()) {
            v.addElement(iterator.next());
        }
        return v;
    }

    public static <E> Vector<E> vector(E ... array) {
        Vector<E> v = new Vector<E>(array.length);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            v.addElement(item);
            ++n2;
        }
        return v;
    }

    public static <E> List<? super E> copy(List<? super E> dest, List<? extends E> src) {
        Collections.copy(dest, src);
        return dest;
    }

    public static <E> List<? super E> fill(List<? super E> list, E value) {
        Collections.fill(list, value);
        return list;
    }

    public static <E> List<E> reverse(List<E> list) {
        Collections.reverse(list);
        return list;
    }

    public static <E> List<E> rotate(List<E> list) {
        return CollectionTools.rotate(list, 1);
    }

    public static <E> List<E> rotate(List<E> list, int distance) {
        Collections.rotate(list, distance);
        return list;
    }

    public static <E> List<E> shuffle(List<E> list) {
        Collections.shuffle(list);
        return list;
    }

    public static <E> List<E> shuffle(List<E> list, Random random) {
        Collections.shuffle(list, random);
        return list;
    }

    public static <E extends Comparable<? super E>> List<E> sort(List<E> list) {
        Collections.sort(list);
        return list;
    }

    public static <E> List<E> sort(List<E> list, Comparator<? super E> comparator) {
        Collections.sort(list, comparator);
        return list;
    }

    public static <E extends Comparable<? super E>> Iterable<E> sort(Iterable<E> iterable) {
        return CollectionTools.sort(iterable, null);
    }

    public static <E> Iterable<E> sort(Iterable<E> iterable, Comparator<? super E> comparator) {
        return CollectionTools.sort(CollectionTools.list(iterable), comparator);
    }

    public static <E extends Comparable<? super E>> Iterator<E> sort(Iterator<? extends E> iterator) {
        return CollectionTools.sort(iterator, null);
    }

    public static <E> Iterator<E> sort(Iterator<? extends E> iterator, Comparator<? super E> comparator) {
        return CollectionTools.sort(CollectionTools.list(iterator), comparator).iterator();
    }

    public static <E> List<E> swap(List<E> list, int i, int j) {
        Collections.swap(list, i, j);
        return list;
    }

    public static boolean[] fill(boolean[] array, boolean value) {
        Arrays.fill(array, value);
        return array;
    }

    public static boolean[] fill(boolean[] array, int fromIndex, int toIndex, boolean value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static byte[] fill(byte[] array, byte value) {
        Arrays.fill(array, value);
        return array;
    }

    public static byte[] fill(byte[] array, int fromIndex, int toIndex, byte value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static char[] fill(char[] array, char value) {
        Arrays.fill(array, value);
        return array;
    }

    public static char[] fill(char[] array, int fromIndex, int toIndex, char value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static double[] fill(double[] array, double value) {
        Arrays.fill(array, value);
        return array;
    }

    public static double[] fill(double[] array, int fromIndex, int toIndex, double value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static float[] fill(float[] array, float value) {
        Arrays.fill(array, value);
        return array;
    }

    public static float[] fill(float[] array, int fromIndex, int toIndex, float value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static int[] fill(int[] array, int value) {
        Arrays.fill(array, value);
        return array;
    }

    public static int[] fill(int[] array, int fromIndex, int toIndex, int value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static <E> E[] fill(E[] array, E value) {
        Arrays.fill(array, value);
        return array;
    }

    public static <E> E[] fill(E[] array, int fromIndex, int toIndex, E value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static long[] fill(long[] array, long value) {
        Arrays.fill(array, value);
        return array;
    }

    public static long[] fill(long[] array, int fromIndex, int toIndex, long value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static short[] fill(short[] array, short value) {
        Arrays.fill(array, value);
        return array;
    }

    public static short[] fill(short[] array, int fromIndex, int toIndex, short value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        return array;
    }

    public static byte[] sort(byte ... array) {
        Arrays.sort(array);
        return array;
    }

    public static byte[] sort(byte[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static char[] sort(char ... array) {
        Arrays.sort(array);
        return array;
    }

    public static char[] sort(char[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static double[] sort(double ... array) {
        Arrays.sort(array);
        return array;
    }

    public static double[] sort(double[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static float[] sort(float ... array) {
        Arrays.sort(array);
        return array;
    }

    public static float[] sort(float[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static int[] sort(int ... array) {
        Arrays.sort(array);
        return array;
    }

    public static int[] sort(int[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static <E> E[] sort(E ... array) {
        Arrays.sort(array);
        return array;
    }

    public static <E> E[] sort(E[] array, Comparator<? super E> comparator) {
        Arrays.sort(array, comparator);
        return array;
    }

    public static <E> E[] sort(E[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static <E> E[] sort(E[] array, int fromIndex, int toIndex, Comparator<? super E> comparator) {
        Arrays.sort(array, fromIndex, toIndex, comparator);
        return array;
    }

    public static long[] sort(long ... array) {
        Arrays.sort(array);
        return array;
    }

    public static long[] sort(long[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    public static short[] sort(short ... array) {
        Arrays.sort(array);
        return array;
    }

    public static short[] sort(short[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
        return array;
    }

    private CollectionTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SingleUseIterable<E>
    implements Iterable<E> {
        private Iterator<E> iterator;

        public SingleUseIterable(Iterator<? extends E> iterator) {
            if (iterator == null) {
                throw new NullPointerException();
            }
            this.iterator = new GenericIteratorWrapper<E>(iterator);
        }

        @Override
        public Iterator<E> iterator() {
            if (this.iterator == null) {
                throw new IllegalStateException("This method has already been called.");
            }
            Iterator<E> result = this.iterator;
            this.iterator = null;
            return result;
        }

        public String toString() {
            return StringTools.buildToStringFor(this, this.iterator);
        }
    }
}

